/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.IOException;
import java.io.InputStream;

class ActiveInputStream
extends InputStream {
    private static final int buflen = 2048;
    private static final int halflen = 1024;
    byte[] buffer = new byte[2048];
    int off = 0;
    int len = 0;
    boolean closed = false;
    boolean interrupted = false;

    ActiveInputStream() {
    }

    public synchronized int available() {
        return this.closed || this.interrupted ? -1 : this.len - this.off;
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.closed = true;
        this.notifyAll();
    }

    public synchronized int read() throws IOException {
        this.waitForInput();
        if (this.closed && this.len - this.off == 0) {
            return -1;
        }
        int n = this.buffer[this.off++] & 0xFF;
        if (this.off >= this.len) {
            this.off = 0;
            this.len = 0;
            this.notifyAll();
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.waitForInput();
        int n3 = this.len - this.off;
        if (this.closed && n3 == 0) {
            return -1;
        }
        if (n2 >= n3) {
            int n4 = n3;
            System.arraycopy(this.buffer, this.off, byArray, n, n3);
            this.off = 0;
            this.len = 0;
            this.notifyAll();
            return n4;
        }
        System.arraycopy(this.buffer, this.off, byArray, n, n2);
        if ((this.off += n2) > 1024) {
            System.arraycopy(this.buffer, this.off, this.buffer, 0, this.len - this.off);
            this.off = 0;
            this.len -= this.off;
            this.notifyAll();
        }
        return n2;
    }

    public synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        while (n < n2) {
            if (this.closed) {
                throw new IOException("Write to closed stream.");
            }
            int n3 = this.buffer.length - this.len;
            if (n3 >= n2 - n || n3 > 1024) {
                int n4 = Math.min(n2 - n, n3);
                System.arraycopy(byArray, n, this.buffer, this.len, n4);
                this.len += n4;
                n += n4;
                this.notifyAll();
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitForInput() throws IOException {
        while (true) {
            if (this.interrupted) {
                throw new IOException("Broken active pipe.");
            }
            int n = this.len - this.off;
            if (this.closed || n > 0) {
                return;
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

