/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Date;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.ParseState;

public class HttpParser {
    private static final boolean debug = false;
    private static byte[][] monthes = new byte[][]{{74, 97, 110}, {70, 101, 98}, {77, 97, 114}, {65, 112, 114}, {77, 97, 121}, {74, 117, 110}, {74, 117, 108}, {65, 117, 103}, {83, 101, 112}, {79, 99, 116}, {78, 111, 118}, {68, 101, 99}};

    public static final int compare(byte[] byArray, int n, int n2, byte[] byArray2) {
        return HttpParser.compare(byArray, n, n2, byArray2, 0, byArray2.length);
    }

    public static final int compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            int n5 = (byArray[n] & 0xFF) - (byArray2[n3] & 0xFF);
            if (n5 != 0) {
                return n5;
            }
            ++n;
            ++n3;
        }
        return n == n2 && n3 == n4 ? 0 : n4 - n2;
    }

    protected static void error(String string, String string2) throws HttpInvalidValueException {
        throw new HttpInvalidValueException(String.valueOf(string) + ": " + string2);
    }

    private static final byte lowerCase(int n) {
        if (n >= 65 && n <= 90) {
            n = n - 65 + 97;
        }
        return (byte)(n & 0xFF);
    }

    public static final int nextItem(byte[] byArray, ParseState parseState) {
        int n = -1;
        int n2 = -1;
        parseState.start = parseState.isSkipable ? (n = HttpParser.skipSpaces(byArray, parseState)) : (n = parseState.ioff);
        int n3 = n2 = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        if (n >= n2) {
            return -1;
        }
        parseState.start = n;
        block0: while (n < n2) {
            if (byArray[n] == 34) {
                ++n;
                while (n < n2) {
                    if (byArray[n] == 92) {
                        n += 2;
                        continue;
                    }
                    if (byArray[n] == 34) {
                        ++n;
                        continue block0;
                    }
                    ++n;
                }
                if (n == n2) {
                    HttpParser.error("nextItem", "Un-terminated quoted item.");
                }
            } else if (byArray[n] == parseState.separator || parseState.spaceIsSep && (byArray[n] == 32 || byArray[n] == 9)) break;
            ++n;
        }
        parseState.end = n;
        if (parseState.isSkipable) {
            parseState.ioff = n;
            parseState.ooff = HttpParser.skipSpaces(byArray, parseState);
        }
        if (parseState.ooff < parseState.bufend && byArray[parseState.ooff] == parseState.separator) {
            ++parseState.ooff;
        }
        return parseState.end > parseState.start ? parseState.start : -1;
    }

    public static long parseDate(byte[] byArray, ParseState parseState) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        ParseState parseState2 = new ParseState();
        parseState2.ioff = parseState.ioff;
        int n7 = parseState2.bufend = parseState.bufend > -1 ? parseState.bufend : byArray.length;
        if (HttpParser.nextItem(byArray, parseState) < 0) {
            HttpParser.error("parseDate", "Invalid date format (no day)");
        }
        parseState.prepare();
        int n8 = HttpParser.skipSpaces(byArray, parseState);
        if (byArray[n8] >= 48 && byArray[n8] <= 57) {
            n = HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            if (byArray[parseState.ioff] == 32) {
                n2 = HttpParser.parseMonth(byArray, parseState);
                parseState.prepare();
                n3 = HttpParser.parseInt(byArray, parseState) - 1900;
                if (n3 < 0) {
                    n3 += 1900;
                }
                parseState.prepare();
                parseState.separator = (byte)58;
                n4 = HttpParser.parseInt(byArray, parseState);
                parseState.prepare();
                n5 = HttpParser.parseInt(byArray, parseState);
                parseState.prepare();
                n6 = HttpParser.parseInt(byArray, parseState);
            } else {
                parseState.separator = (byte)45;
                n2 = HttpParser.parseMonth(byArray, parseState);
                parseState.prepare();
                n3 = HttpParser.parseInt(byArray, parseState);
                parseState.prepare();
                parseState.separator = (byte)58;
                n4 = HttpParser.parseInt(byArray, parseState);
                parseState.prepare();
                n5 = HttpParser.parseInt(byArray, parseState);
                parseState.prepare();
                n6 = HttpParser.parseInt(byArray, parseState);
            }
        } else {
            n2 = HttpParser.parseMonth(byArray, parseState);
            parseState.prepare();
            n = HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            parseState.separator = (byte)58;
            n4 = HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            n5 = HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            n6 = HttpParser.parseInt(byArray, parseState);
            parseState.prepare();
            parseState.separator = (byte)32;
            n3 = HttpParser.parseInt(byArray, parseState) - 1900;
        }
        return Date.UTC(n3, n2, n, n4, n5, n6);
    }

    public static long parseDateOrDeltaSeconds(byte[] byArray, ParseState parseState) {
        return HttpParser.parseDateOrDeltaSeconds(byArray, parseState, -1L);
    }

    public static long parseDateOrDeltaSeconds(byte[] byArray, ParseState parseState, long l) {
        int n = -1;
        n = parseState.isSkipable ? (parseState.start = HttpParser.skipSpaces(byArray, parseState)) : parseState.ioff;
        int n2 = parseState.bufend >= 0 ? parseState.bufend : byArray.length;
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] > 57 || byArray[n3] < 48) {
                return HttpParser.parseDate(byArray, parseState);
            }
            ++n3;
        }
        long l2 = HttpParser.parseInt(byArray, parseState);
        return l >= 0L ? l + l2 * 1000L : System.currentTimeMillis() + l2 * 1000L;
    }

    public static long parseDeltaSecond(byte[] byArray, ParseState parseState) {
        return HttpParser.parseInt(byArray, parseState);
    }

    public static final int parseInt(byte[] byArray, int n, ParseState parseState) {
        int n2 = -1;
        parseState.start = parseState.isSkipable ? (n2 = HttpParser.skipSpaces(byArray, parseState)) : (n2 = parseState.ioff);
        int n3 = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        int n4 = 0;
        boolean bl = false;
        if (byArray[n2] == 45) {
            bl = true;
            ++n2;
        }
        while (n2 < n3) {
            int n5 = byArray[n2] & 0xFF;
            if (n5 >= 48 && n5 <= 57) {
                n4 = n4 * n + (n5 - 48);
            } else {
                if (n < 10) break;
                if (n5 >= 65 && n5 <= 90) {
                    if (n5 - 65 + 10 >= n) break;
                    n4 = n4 * n + (n5 - 65 + 10);
                } else {
                    if (n5 < 97 || n5 > 122 || n5 - 97 + 10 >= n) break;
                    n4 = n4 * n + n5 - 97 + 10;
                }
            }
            ++n2;
        }
        parseState.ooff = n2;
        parseState.end = n2;
        if (parseState.ooff == parseState.ioff) {
            HttpParser.error("parseInt", "No number available.");
        }
        return bl ? -n4 : n4;
    }

    public static final int parseInt(byte[] byArray, ParseState parseState) {
        return HttpParser.parseInt(byArray, 10, parseState);
    }

    public static int parseMonth(byte[] byArray, ParseState parseState) {
        int n;
        int n2 = -1;
        n2 = parseState.isSkipable ? (parseState.start = HttpParser.skipSpaces(byArray, parseState)) : (parseState.start = parseState.ioff);
        int n3 = n = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        if (n < 3) {
            HttpParser.error("parseMonth", "Invalid month name (too short).");
            return -1;
        }
        int n4 = 0;
        while (n4 < monthes.length) {
            int n5 = n2;
            byte[] byArray2 = monthes[n4];
            boolean bl = true;
            int n6 = 0;
            while (n6 < byArray2.length) {
                if (HttpParser.lowerCase(byArray2[n6]) != HttpParser.lowerCase(byArray[n5])) {
                    bl = false;
                    break;
                }
                ++n6;
                ++n5;
            }
            if (bl) {
                if (n5 - n2 == byArray2.length) {
                    n2 += 3;
                    while (n2 < n) {
                        byte by;
                        if ((by = HttpParser.lowerCase(byArray[n2++])) < 97 || by > 122) break;
                    }
                    parseState.ooff = parseState.end = n2;
                }
                return n4;
            }
            ++n4;
        }
        HttpParser.error("parseMonth", "Invalid month name (unknown).");
        return -1;
    }

    public static double parseQuality(byte[] byArray, ParseState parseState) {
        int n = -1;
        parseState.start = parseState.isSkipable ? (n = HttpParser.skipSpaces(byArray, parseState)) : (n = parseState.ioff);
        int n2 = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        String string = new String(byArray, 0, n, n2 - n);
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            HttpParser.error("parseQuality", "Invalid floating point number.");
            return 1.0;
        }
    }

    public static final int skipSpaces(byte[] byArray, ParseState parseState) {
        int n = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        int n2 = parseState.ioff;
        while (n2 < n) {
            if (byArray[n2] != 32 && byArray[n2] != 9 && byArray[n2] != parseState.separator) {
                parseState.ioff = n2;
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static boolean unquote(byte[] byArray, ParseState parseState) {
        int n = -1;
        int n2 = -1;
        n = parseState.isSkipable ? HttpParser.skipSpaces(byArray, parseState) : parseState.ioff;
        int n3 = n2 = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        if (n < n2 && byArray[n] == 34) {
            parseState.start = parseState.ioff = ++n;
            while (n < n2) {
                if (byArray[n] == 34) {
                    parseState.end = parseState.bufend = n;
                    return true;
                }
                ++n;
            }
        } else {
            parseState.start = n;
            parseState.end = n2;
        }
        return false;
    }
}

