/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Date;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.ParseState;

public class HttpDate
extends BasicValue {
    protected static String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    protected static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected Long date = null;
    protected int tz = -1;

    HttpDate() {
        this.isValid = false;
    }

    HttpDate(boolean bl, long l) {
        this.isValid = bl;
        this.date = new Long(l);
    }

    public Object getValue() {
        this.validate();
        return this.date;
    }

    public static void main(String[] stringArray) {
        Date date = new Date();
        System.out.println("tz offset: " + date.getTimezoneOffset());
        System.out.println("local: " + date.toString());
        System.out.println("gmt  : " + date.toGMTString());
        long l = date.getTime();
        System.out.println("hacke: " + new Date(l += (long)(date.getTimezoneOffset() * 60 * 1000)));
    }

    protected void parse() {
        ParseState parseState = new ParseState();
        parseState.ioff = this.roff;
        parseState.bufend = this.rlen;
        this.date = new Long(HttpParser.parseDateOrDeltaSeconds(this.raw, parseState));
    }

    public void setValue(long l) {
        if (l == this.date) {
            return;
        }
        this.invalidateByteValue();
        this.date = new Long(l);
        this.isValid = true;
    }

    protected void updateByteValue() {
        if (this.tz == -1) {
            this.tz = new Date().getTimezoneOffset();
        }
        HttpBuffer httpBuffer = new HttpBuffer();
        Date date = new Date(this.date + (long)(this.tz * 60 * 1000));
        httpBuffer.append(days[date.getDay()]);
        httpBuffer.append(',');
        httpBuffer.append(' ');
        httpBuffer.appendInt(date.getDate(), 2, (byte)48);
        httpBuffer.append(' ');
        httpBuffer.append(months[date.getMonth()]);
        httpBuffer.append(' ');
        httpBuffer.appendInt(date.getYear() + 1900, 2, (byte)48);
        httpBuffer.append(' ');
        httpBuffer.appendInt(date.getHours(), 2, (byte)48);
        httpBuffer.append(':');
        httpBuffer.appendInt(date.getMinutes(), 2, (byte)48);
        httpBuffer.append(':');
        httpBuffer.appendInt(date.getSeconds(), 2, (byte)48);
        httpBuffer.append(" GMT");
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

