/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.w3c.tools.widgets.ImageCache;

public class Slider
extends Canvas {
    int marginx = 10;
    int marginy = 5;
    int defaultWidth = 180;
    int defaultHeight = 53;
    int width = 0;
    int height = 0;
    int minheight = 53;
    int minwidth = 150;
    int rect_margin_x = 20;
    int rect_margin_y = 10;
    int pointerWidth = 12;
    int pointerHeight = 20;
    int pointerX = 0;
    int pointerY = 0;
    int guideHeight = 2;
    int graduationHeight = 5;
    double min = 0.0;
    double max = 0.0;
    double step = 0.0;
    int minpixelstep = 2;
    boolean border = false;
    boolean manageLong = false;
    Color color = Color.gray;
    Dimension size = null;
    Point pposition = null;
    Graduation[] graduations = null;
    Graduation currentGraduation = null;
    protected Pointer pointer = null;
    private Dimension oldsize = new Dimension(0, 0);

    public Slider() {
        this.pposition = new Point(this.marginx + this.rect_margin_x, this.marginy + this.rect_margin_y);
        this.pointer = new Pointer(this.pointerWidth, this.pointerHeight, this.pposition);
        PointerClickListener pointerClickListener = new PointerClickListener(this);
        PointerMotionListener pointerMotionListener = new PointerMotionListener(this);
        this.addMouseListener(pointerClickListener);
        this.addMouseMotionListener(pointerMotionListener);
        this.setVisible(false);
    }

    public Slider(int n, boolean bl) {
        this();
        this.minpixelstep = n;
        this.border = bl;
    }

    protected int getGoodX(int n) {
        if (n > this.width - this.marginx - this.rect_margin_x) {
            if (this.graduations[this.graduations.length - 1].x1 != this.pointer.getCenterX()) {
                this.currentGraduation = this.graduations[this.graduations.length - 1];
                return this.graduations[this.graduations.length - 1].x1;
            }
            return -1;
        }
        if (n < this.marginx + this.rect_margin_x) {
            if (this.graduations[0].x1 != this.pointer.getCenterX()) {
                this.currentGraduation = this.graduations[0];
                return this.graduations[0].x1;
            }
            return -1;
        }
        int n2 = -1;
        int n3 = this.getGraduationLength() + 50;
        int n4 = 0;
        while (n4 < this.graduations.length) {
            n2 = this.graduations[n4].dx(n);
            if (n2 >= n3) break;
            n3 = n2;
            ++n4;
        }
        if (this.graduations[n4 - 1].x1 != this.pointer.getCenterX()) {
            this.currentGraduation = this.graduations[n4 - 1];
            return this.graduations[n4 - 1].x1;
        }
        return -1;
    }

    protected int getGraduationLength() {
        int n = this.width - 2 * (this.marginx + this.rect_margin_x);
        int n2 = (int)((this.max - this.min) / this.step);
        int n3 = n / n2;
        return n3 * n2;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minwidth, this.minheight);
    }

    public double getValue() {
        if (this.currentGraduation != null) {
            return this.currentGraduation.value;
        }
        return this.min;
    }

    public void initialize(double d, double d2, double d3) {
        this.manageLong = false;
        this.min = d;
        this.max = d2;
        this.step = d3;
        this.update();
    }

    public void initialize(double d, double d2, double d3, boolean bl) {
        this.initialize(d, d2, d3);
        this.border = bl;
    }

    public void initialize(long l, long l2, long l3) {
        this.initialize((double)l, (double)l2, (double)l3);
        this.manageLong = true;
        this.update();
    }

    public void initialize(long l, long l2, long l3, boolean bl) {
        this.initialize(l, l2, l3);
        this.border = bl;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Slider");
        frame.setLayout(new GridLayout(6, 1));
        Slider slider = null;
        slider = new Slider();
        slider.initialize(0.0, 1.0, 0.1);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        slider = new Slider();
        slider.initialize(0.0, 0.1, 0.01);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        slider = new Slider();
        slider.initialize(0.0, 0.01, 5.0E-4);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        slider = new Slider();
        slider.initialize(0L, 100L, 10L);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        slider = new Slider();
        slider.initialize(0L, 30000L, 5000L);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        slider = new Slider();
        slider.initialize(0L, 30000L, 1000L);
        slider.setColor(Color.lightGray);
        frame.add(slider);
        if (stringArray.length > 1) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            slider.setSize(n, n2);
        }
        frame.pack();
        frame.show();
    }

    protected void movePointerTo(int n, int n2) {
        int n3 = this.getGoodX(n);
        if (n3 != -1) {
            this.pointer.setLocation(n3, this.pposition.y);
            if (this.getGraphics() != null) {
                this.paint(this.getGraphics());
            }
        }
    }

    protected void movePointerTo(Point point) {
        int n = this.getGoodX(point.x);
        if (n != -1) {
            this.pointer.setLocation(n, this.pposition.y);
            if (this.getGraphics() != null) {
                this.paint(this.getGraphics());
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.updateSize(dimension);
        Shape shape = graphics.getClip();
        Image image = null;
        Graphics graphics2 = null;
        image = ImageCache.getImage(this, dimension.width, dimension.height);
        graphics2 = image.getGraphics();
        graphics2.setClip(shape);
        graphics2.setColor(this.color);
        graphics2.clearRect(0, 0, dimension.width, dimension.height);
        graphics2.fillRect(this.marginx, this.marginy, this.width - 2 * this.marginx, this.height - 2 * this.marginy);
        if (this.border) {
            graphics2.setColor(this.color.darker());
            graphics2.drawRect(this.marginx, this.marginy, this.width - 2 * this.marginx, this.height - 2 * this.marginy);
        }
        graphics2.setColor(Color.white);
        graphics2.fill3DRect(this.marginx + this.rect_margin_x, this.marginy + this.rect_margin_y - this.guideHeight / 2, this.getGraduationLength(), this.guideHeight, false);
        this.paintGraduation(graphics2);
        graphics2.setColor(this.color.darker());
        this.pointer.paint(graphics2);
        graphics.drawImage(image, 0, 0, this);
    }

    protected void paintGraduation(Graphics graphics) {
        graphics.setColor(Color.black);
        Font font = new Font(graphics.getFont().getName(), graphics.getFont().getStyle(), graphics.getFont().getSize() - 1);
        graphics.setFont(font);
        int n = 0;
        while (n < this.graduations.length) {
            this.graduations[n].draw(graphics, n == 0 || n == this.graduations.length - 1);
            ++n;
        }
        graphics.setColor(Color.white);
        this.currentGraduation.showValue(graphics);
    }

    public void setBounds(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.update();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void setDefaultSize(double d, double d2, double d3) {
        int n = this.minwidth - 2 * (this.marginx + this.rect_margin_x);
        int n2 = (int)((d2 - d) / d3);
        int n3 = n / n2;
        if (n3 < this.minpixelstep) {
            this.defaultWidth = this.minwidth = this.minpixelstep * n2 + 2 * (this.marginx + this.rect_margin_x);
        }
        this.updateSize(this.defaultWidth, this.defaultHeight);
        this.pposition = new Point(this.pposition.x, this.marginy + this.rect_margin_y);
        this.pointer.setLocation(this.pposition);
        this.currentGraduation = this.graduations[0];
    }

    public void setMax(double d) {
        this.max = d;
        this.update();
    }

    public void setMin(double d) {
        this.min = d;
        this.update();
    }

    public void setStep(double d) {
        this.step = d;
        this.update();
    }

    public void setValue(double d) {
        this.updatePointerPosition(d);
        this.updateCurrentGraduation();
        if (this.getGraphics() != null) {
            this.paint(this.getGraphics());
        }
    }

    public void setValue(long l) {
        this.setValue((double)l);
    }

    protected void update() {
        this.setDefaultSize(this.min, this.max, this.step);
        this.updateGraduationPosition();
        if (this.graduations != null) {
            this.currentGraduation = this.graduations[0];
        }
        this.setVisible(true);
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void updateCurrentGraduation() {
        if (this.pposition.x > this.width - this.marginx - this.rect_margin_x) {
            this.currentGraduation = this.graduations[this.graduations.length - 1];
        } else if (this.pposition.x < this.marginx + this.rect_margin_x) {
            this.currentGraduation = this.graduations[0];
        } else {
            int n = -1;
            int n2 = this.getGraduationLength() + 50;
            int n3 = 0;
            while (n3 < this.graduations.length) {
                n = this.graduations[n3].dx(this.pposition.x);
                if (n >= n2) break;
                n2 = n;
                ++n3;
            }
            this.currentGraduation = this.graduations[n3 - 1];
        }
    }

    protected void updateGraduationPosition() {
        int n = this.width - 2 * (this.marginx + this.rect_margin_x);
        int n2 = (int)((this.max - this.min) / this.step);
        int n3 = n / n2;
        int n4 = this.marginy + 5 * this.rect_margin_y / 3;
        int n5 = n4 + this.graduationHeight;
        int n6 = this.marginx + this.rect_margin_x;
        int n7 = n + n6;
        int n8 = n6;
        this.graduations = new Graduation[n2 + 1];
        int n9 = 0;
        while (n9 < this.graduations.length) {
            this.graduations[n9] = this.manageLong ? new Graduation(n8, n4, n8, n5, (long)(this.min + (double)n9 * this.step)) : new Graduation(n8, n4, n8, n5, this.min + (double)n9 * this.step);
            n8 += n3;
            ++n9;
        }
    }

    protected void updatePointerPosition(double d) {
        if (d <= this.graduations[0].value) {
            this.pointer.setLocation(this.graduations[0].x1, this.pposition.y);
            return;
        }
        int n = this.graduations.length - 1;
        if (d == this.graduations[n].value) {
            this.pointer.setLocation(this.graduations[n].x1, this.pposition.y);
            return;
        }
        if (d > this.graduations[this.graduations.length - 1].value) {
            this.setMax(d + 10.0 * this.step);
        }
        int n2 = 1;
        while (n2 < this.graduations.length - 2) {
            if (d - this.graduations[n2].value < this.step) {
                this.pointer.setLocation(this.graduations[n2].x1, this.pposition.y);
                return;
            }
            ++n2;
        }
    }

    public void updateSize(int n, int n2) {
        if (this.oldsize.width != n || this.oldsize.height != n2) {
            double d = this.getValue();
            if (n2 < this.minheight) {
                n2 = this.minheight;
            }
            if (n < this.minwidth) {
                n = this.minwidth;
            }
            super.setSize(n, n2);
            this.oldsize = this.getSize();
            this.width = n;
            this.height = n2;
            this.rect_margin_y = (n2 - 2 * this.marginy) / 3;
            this.updateGraduationPosition();
            this.pposition.y = this.marginy + this.rect_margin_y;
            this.updatePointerPosition(d);
            this.updateCurrentGraduation();
        }
    }

    public void updateSize(Dimension dimension) {
        this.updateSize(dimension.width, dimension.height);
    }

    class PointerClickListener
    extends MouseAdapter {
        Slider slider = null;

        public PointerClickListener(Slider slider2) {
            this.slider = slider2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component == this.slider) {
                this.slider.movePointerTo(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class PointerMotionListener
    implements MouseMotionListener {
        Slider slider = null;

        PointerMotionListener(Slider slider2) {
            this.slider = slider2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component == this.slider) {
                this.slider.movePointerTo(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class Pointer {
        private int width = 0;
        private int height = 0;
        private int centerX = 0;
        Dimension size = null;
        int x = 0;
        int y = 0;

        Pointer(int n, int n2, Point point) {
            this.setSize(n, n2);
            this.setLocation(point);
        }

        public void fill3DPointer(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            int n5 = 3;
            Color color = graphics.getColor();
            Color color2 = color.brighter();
            Color color3 = color.darker();
            if (!bl) {
                graphics.setColor(color3);
            }
            graphics.fillRect(n + 1, n2 + 1, n3 - 2, 2 * n4 / 3);
            nArray[0] = n;
            nArray2[0] = n2 + 2 * n4 / 3;
            nArray[1] = n + n3 / 2;
            nArray2[1] = n2 + n4;
            nArray[2] = n + n3;
            nArray2[2] = n2 + 2 * n4 / 3;
            graphics.fillPolygon(nArray, nArray2, n5);
            graphics.setColor(bl ? color2 : color3);
            graphics.drawLine(n, n2, n, n2 + 2 * n4 / 3 - 1);
            graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.setColor(bl ? color3 : color2);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + 2 * n4 / 3 - 2);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2] - 1, nArray2[2] - 1);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public Point getLocation() {
            return new Point(this.x, this.y);
        }

        public Point getNewLocation(int n, int n2) {
            return new Point(this.getLocation().x + n, this.getLocation().y + n2);
        }

        public void paint(Graphics graphics) {
            this.fill3DPointer(graphics, this.getLocation().x, this.getLocation().y, this.width, this.height, true);
        }

        public void setLocation(int n, int n2) {
            Slider.this.pposition = new Point(n, n2);
            this.x = n - this.width / 2;
            this.y = n2 - this.height / 2;
            this.centerX = n;
        }

        public void setLocation(Point point) {
            this.setLocation(point.x, point.y);
        }

        public void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.size = new Dimension(n, n2);
        }
    }

    class Graduation {
        boolean isDouble;
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public double value;

        public Graduation(int n, int n2, int n3, int n4, double d) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.value = d;
            this.isDouble = true;
        }

        public Graduation(int n, int n2, int n3, int n4, long l) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.value = l;
            this.isDouble = false;
        }

        public void draw(Graphics graphics, boolean bl) {
            graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
            if (bl) {
                String string = this.getStringValue();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.getHeight();
                int n2 = fontMetrics.stringWidth(string);
                graphics.drawString(string, this.x1 - n2 / 2, this.y2 + n);
            }
        }

        public int dx(int n) {
            int n2 = this.x1 - n;
            return n2 < 0 ? -n2 : n2;
        }

        public String getStringValue() {
            if (this.isDouble) {
                return String.valueOf((float)this.value);
            }
            return String.valueOf((long)this.value);
        }

        public void showValue(Graphics graphics) {
            String string = this.getStringValue();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.stringWidth(string);
            graphics.drawString(string, this.x1 - n2 / 2, this.y2 + n);
        }
    }
}

