/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.util.LookupTable;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSubsetReader
extends HandlerBase
implements JigXML {
    Vector tables = null;
    LookupTable table = null;
    LookupTable[] lookuptables = null;
    String[] attributes = null;
    String attribute = null;
    boolean readAttr = false;
    int level = 0;
    int len = 0;
    Parser parser = null;
    Reader reader = null;
    boolean isavalue = false;

    public XMLSubsetReader(Reader reader, Parser parser, String[] stringArray) {
        this.reader = reader;
        this.parser = parser;
        this.attributes = stringArray;
        this.len = stringArray.length;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        if (this.level == 0 && this.readAttr && (string = new String(cArray, n, n2)).equals("@@NULL@@")) {
            this.table.put(this.attribute, string);
        }
    }

    public void endDocument() throws SAXException {
        this.lookuptables = new LookupTable[this.tables.size()];
        this.tables.copyInto(this.lookuptables);
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("resource")) {
            if (this.level == 0) {
                this.tables.addElement(this.table);
            }
        } else if (string.equals("attribute")) {
            if (this.level == 0) {
                this.readAttr = false;
            }
        } else if (string.equals("array")) {
            --this.level;
        } else if (string.equals("resourcearray")) {
            --this.level;
        } else if (string.equals("value")) {
            this.isavalue = false;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("FATAL ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    private boolean load(String string) {
        int n = 0;
        while (n < this.len) {
            if (this.attributes[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void parse() throws SAXException, IOException {
        this.parser.setDocumentHandler(this);
        this.parser.setErrorHandler(this);
        this.parser.parse(new InputSource(this.reader));
    }

    public LookupTable[] readAttributeTables() throws IOException, SerializationException {
        try {
            this.parse();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return new LookupTable[0];
        }
        return this.lookuptables;
    }

    public void startDocument() throws SAXException {
        this.tables = new Vector(10);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("resource")) {
            if (this.level == 0) {
                this.table = new LookupTable(this.len);
            }
        } else if (string.equals("attribute")) {
            if (this.level == 0) {
                String string2 = attributeList.getValue("name");
                this.readAttr = this.load(string2);
            }
        } else if (string.equals("array")) {
            ++this.level;
        } else if (string.equals("resourcearray")) {
            ++this.level;
        } else if (string.equals("value")) {
            this.isavalue = true;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("WARNING in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }
}

