/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Writer;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.FrameArrayAttribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.EmptyDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLWriter;

public class XMLDescrWriter
extends XMLWriter
implements JigXML {
    public XMLDescrWriter(Writer writer) {
        super(writer);
    }

    protected void closeDescription() throws IOException {
        this.writer.write("</description>\n");
    }

    protected void startDescription(ResourceDescription resourceDescription) throws IOException {
        String string = resourceDescription.getClassName();
        this.writer.write("<description class='" + string + "' ");
        String string2 = resourceDescription.getIdentifier();
        if (string2 == null) {
            string2 = "@@NULL@@";
        }
        this.writer.write("name='" + string2 + "'>\n");
    }

    protected void startResource(ResourceDescription resourceDescription) throws IOException {
        String string = resourceDescription.getClassName();
        this.writer.write("<resource class='" + string + "'>\n");
        this.writeInherit(resourceDescription.getClassHierarchy(), 1);
        this.writeInterfaces(resourceDescription.getInterfaces());
    }

    protected void writeAttributeDescription(AttributeDescription attributeDescription) throws IOException {
        ++this.level;
        String string = attributeDescription.getClassName();
        Attribute attribute = attributeDescription.getAttribute();
        Object object = attributeDescription.getValue();
        if (attribute instanceof SimpleAttribute) {
            this.indent();
            this.writer.write("<attribute name='" + attributeDescription.getName() + "' ");
            this.writer.write("flag='" + attribute.getFlag() + "' ");
            this.writer.write("class='" + string + "'>");
            if (object == null) {
                this.writer.write("@@NULL@@");
            } else {
                this.writer.write(XMLWriter.encode(((SimpleAttribute)attribute).pickle(object)));
            }
            this.writer.write("</attribute>\n");
        } else if (attribute instanceof ArrayAttribute) {
            this.indent();
            this.writer.write("<array name='" + attributeDescription.getName() + "' ");
            this.writer.write("flag='" + attribute.getFlag() + "' ");
            this.writer.write("class='" + string + "' ");
            String[] stringArray = null;
            stringArray = object == null ? new String[]{} : ((ArrayAttribute)attribute).pickle(object);
            int n = stringArray.length;
            this.writer.write("length='" + n + "'>\n");
            ++this.level;
            int n2 = 0;
            while (n2 < n) {
                this.indent();
                this.writer.write("<value>" + XMLWriter.encode(stringArray[n2]) + "</" + "value" + ">\n");
                ++n2;
            }
            --this.level;
            this.indent();
            this.writer.write("</array>\n");
        } else if (attribute instanceof FrameArrayAttribute) {
            this.indent();
            this.writer.write("<resourcearray name='" + attributeDescription.getName() + "' ");
            this.writer.write("class='" + string + "' ");
            ResourceDescription[] resourceDescriptionArray = null;
            resourceDescriptionArray = object == null ? new ResourceDescription[]{} : (ResourceDescription[])object;
            int n = resourceDescriptionArray.length;
            this.writer.write("length='" + n + "'>\n");
            int n3 = 0;
            while (n3 < n) {
                this.writeResourceDescription(resourceDescriptionArray[n3]);
                ++n3;
            }
            this.indent();
            this.writer.write("</resourcearray>\n");
        }
        --this.level;
    }

    protected void writeInherit(String[] stringArray, int n) throws IOException {
        if (n < stringArray.length) {
            ++this.level;
            this.indent();
            this.writer.write("<inherit class='" + stringArray[n] + "'>\n");
            this.writeInherit(stringArray, ++n);
            this.indent();
            this.writer.write("</inherit>\n");
            --this.level;
        }
    }

    protected void writeInterfaces(String[] stringArray) throws IOException {
        ++this.level;
        int n = 0;
        while (n < stringArray.length) {
            this.indent();
            this.writer.write("<implements class='" + stringArray[n] + "'/>\n");
            ++n;
        }
        --this.level;
    }

    public void writeResourceDescription(ResourceDescription resourceDescription) throws IOException {
        ++this.level;
        this.indent();
        if (resourceDescription instanceof EmptyDescription) {
            this.startDescription(resourceDescription);
            this.indent();
            this.closeDescription();
        } else {
            this.startResource(resourceDescription);
            AttributeDescription[] attributeDescriptionArray = resourceDescription.getAttributeDescriptions();
            int n = 0;
            while (n < attributeDescriptionArray.length) {
                this.writeAttributeDescription(attributeDescriptionArray[n]);
                ++n;
            }
            this.indent();
            this.closeResource();
        }
        --this.level;
    }
}

