/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.util.Vector;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;

public class LookupState {
    private int index;
    private String[] components;
    private RequestInterface request;
    private boolean is_directory = false;
    private boolean is_internal = false;
    private String uri = null;
    private String query = null;
    private String fragment = null;
    private String type = null;

    public LookupState(String string) throws ProtocolException {
        this.request = null;
        this.is_internal = true;
        this.uri = string;
        this.parseURI();
    }

    public LookupState(RequestInterface requestInterface) throws ProtocolException {
        this.request = requestInterface;
        this.uri = requestInterface.getURLPath();
        this.is_internal = requestInterface.isInternal();
        if (this.uri == null) {
            ReplyInterface replyInterface = requestInterface.makeBadRequestReply();
            replyInterface.setContent("Invalid URI (unparsable)");
            throw new ProtocolException(replyInterface);
        }
        this.parseURI();
    }

    public int countRemainingComponents() {
        return this.components.length - this.index;
    }

    public String getFragment() {
        return this.fragment;
    }

    public final String getNextComponent() {
        return this.components[this.index++];
    }

    public String getQuery() {
        return this.query;
    }

    public final String getRemainingPath() {
        return this.getRemainingPath(false);
    }

    public final String getRemainingPath(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.index;
        while (n < this.components.length) {
            stringBuffer.append("/" + this.components[n]);
            ++n;
        }
        if (bl) {
            this.index = this.components.length;
        }
        return stringBuffer.toString();
    }

    public final RequestInterface getRequest() {
        return this.request;
    }

    public String getType() {
        return this.type;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean hasMoreComponents() {
        return this.index < this.components.length;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public boolean isDirectory() {
        return this.is_directory;
    }

    public boolean isInternal() {
        return this.is_internal;
    }

    public void markInternal() {
        this.is_internal = true;
    }

    protected void parseURI() throws ProtocolException {
        int n = this.uri.length();
        int n2 = 0;
        int n3 = -1;
        Vector<String> vector = new Vector<String>(8);
        int n4 = this.uri.indexOf(63, n2);
        int n5 = this.uri.indexOf(35, n2);
        int n6 = this.uri.indexOf(59, n2);
        int n7 = -1;
        n7 = n4 >= 0 ? (n5 >= 0 ? (n6 >= 0 ? Math.min(n4, Math.min(n6, n5)) : Math.min(n4, n5)) : (n6 >= 0 ? Math.min(n4, n6) : n4)) : (n5 >= 0 ? (n6 >= 0 ? Math.min(n5, n6) : n5) : (n6 >= 0 ? n6 : n));
        this.uri = this.uri;
        while ((n3 = this.uri.indexOf(47, n2)) < n7 && n3 >= 0) {
            if (n3 == n2) {
                n2 = n3 + 1;
                continue;
            }
            if (n3 <= 0) continue;
            String string = LookupState.unescape(this.uri.substring(n2, n3));
            vector.addElement(string);
            n2 = n3 + 1;
        }
        if (n4 >= 0 || n5 >= 0 || n6 >= 0) {
            if (n4 > 0) {
                if (n5 > 0) {
                    if (n6 > 0) {
                        if (n4 < n5 && n5 < n6) {
                            if (n4 + 1 < n5) {
                                this.query = this.uri.substring(n4 + 1, n5);
                            }
                            if (n5 + 1 < n6) {
                                this.fragment = this.uri.substring(n5 + 1, n6);
                            }
                            if (n6 + 1 < n) {
                                this.type = this.uri.substring(n6 + 1, n);
                            }
                        } else if (n5 < n4 && n4 < n6) {
                            if (n5 + 1 < n4) {
                                this.query = this.uri.substring(n5 + 1, n4);
                            }
                            if (n4 + 1 < n6) {
                                this.fragment = this.uri.substring(n4 + 1, n6);
                            }
                            if (n6 + 1 < n) {
                                this.type = this.uri.substring(n6 + 1, n);
                            }
                        } else if (n5 < n6 && n6 < n4) {
                            if (n5 + 1 < n6) {
                                this.query = this.uri.substring(n5 + 1, n6);
                            }
                            if (n6 + 1 < n4) {
                                this.fragment = this.uri.substring(n6 + 1, n4);
                            }
                            if (n4 + 1 < n) {
                                this.type = this.uri.substring(n4 + 1, n);
                            }
                        } else if (n4 < n6 && n6 < n5) {
                            if (n4 + 1 < n6) {
                                this.query = this.uri.substring(n4 + 1, n6);
                            }
                            if (n6 + 1 < n5) {
                                this.fragment = this.uri.substring(n6 + 1, n5);
                            }
                            if (n5 + 1 < n) {
                                this.type = this.uri.substring(n5 + 1, n);
                            }
                        } else if (n6 < n4 && n4 < n5) {
                            if (n6 + 1 < n4) {
                                this.query = this.uri.substring(n6 + 1, n4);
                            }
                            if (n4 + 1 < n5) {
                                this.fragment = this.uri.substring(n4 + 1, n5);
                            }
                            if (n5 + 1 < n) {
                                this.type = this.uri.substring(n5 + 1, n);
                            }
                        } else {
                            if (n6 + 1 < n4) {
                                this.query = this.uri.substring(n6 + 1, n4);
                            }
                            if (n4 + 1 < n5) {
                                this.fragment = this.uri.substring(n4 + 1, n5);
                            }
                            if (n5 + 1 < n) {
                                this.type = this.uri.substring(n5 + 1, n);
                            }
                        }
                    } else if (n5 > n4) {
                        if (n4 + 1 < n5) {
                            this.query = this.uri.substring(n4 + 1, n5);
                        }
                        if (n5 + 1 < n) {
                            this.fragment = this.uri.substring(n5 + 1, n);
                        }
                    } else {
                        if (n5 + 1 < n4) {
                            this.fragment = this.uri.substring(n5 + 1, n4);
                        }
                        if (n4 + 1 < n) {
                            this.query = this.uri.substring(n4 + 1, n);
                        }
                    }
                } else if (n6 > 0) {
                    if (n6 > n4) {
                        if (n4 + 1 < n6) {
                            this.query = this.uri.substring(n4 + 1, n6);
                        }
                        if (n6 + 1 < n) {
                            this.type = this.uri.substring(n6 + 1, n);
                        }
                    } else {
                        if (n6 + 1 < n4) {
                            this.type = this.uri.substring(n6 + 1, n4);
                        }
                        if (n4 + 1 < n) {
                            this.query = this.uri.substring(n4 + 1, n);
                        }
                    }
                } else if (n4 + 1 < n) {
                    this.query = this.uri.substring(n4 + 1, n);
                }
            } else if (n6 > 0) {
                if (n5 > 0) {
                    if (n6 > n5) {
                        if (n5 + 1 < n6) {
                            this.fragment = this.uri.substring(n5 + 1, n6);
                        }
                        if (n6 + 1 < n) {
                            this.type = this.uri.substring(n6 + 1, n);
                        }
                    } else {
                        if (n6 + 1 < n5) {
                            this.type = this.uri.substring(n6 + 1, n5);
                        }
                        if (n5 + 1 < n) {
                            this.fragment = this.uri.substring(n5 + 1, n);
                        }
                    }
                } else if (n6 + 1 < n) {
                    this.type = this.uri.substring(n6 + 1, n);
                }
            } else if (n5 + 1 < n) {
                this.fragment = this.uri.substring(n5 + 1, n);
            }
        }
        if (this.request != null) {
            if (this.query != null) {
                this.request.setState("query", this.query);
            }
            if (this.fragment != null) {
                this.request.setState("frag", this.fragment);
            }
            if (this.type != null) {
                this.request.setState("type", this.type);
            }
        }
        if (n2 < n7) {
            vector.addElement(LookupState.unescape(this.uri.substring(n2, n7)));
        }
        if (--n7 >= 0) {
            this.is_directory = this.uri.charAt(n7) == '/';
        }
        this.components = new String[vector.size()];
        vector.copyInto(this.components);
        this.index = 0;
    }

    public final String peekNextComponent() {
        if (this.index < this.components.length) {
            return this.components[this.index];
        }
        return null;
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c;
            switch (c) {
                case '%': {
                    n2 = string.charAt(++n3);
                    int n4 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n2 = string.charAt(++n3);
                    int n5 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    stringBuffer.append((char)(n4 << 4 | n5));
                    break;
                }
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append((char)n2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

