/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceReference;

public class LookupResult {
    public static final int FILTERS_INIT_SIZE = 8;
    public static final int FILTERS_INCR = 4;
    protected ReplyInterface reply = null;
    protected ResourceReference target = null;
    protected ResourceFilter[] filters = null;
    protected int flength = -1;

    public LookupResult(ResourceReference resourceReference) {
        this.target = resourceReference;
    }

    public void addFilter(ResourceFilter resourceFilter) {
        if (this.filters == null) {
            this.filters = new ResourceFilter[8];
            this.flength = 0;
            this.filters[this.flength++] = resourceFilter;
        } else {
            if (this.flength >= this.filters.length) {
                ResourceFilter[] resourceFilterArray = new ResourceFilter[this.filters.length + 4];
                System.arraycopy(this.filters, 0, resourceFilterArray, 0, this.filters.length);
                this.filters = resourceFilterArray;
            }
            this.filters[this.flength++] = resourceFilter;
        }
    }

    public void addFilters(ResourceFilter[] resourceFilterArray) {
        if (this.filters == null) {
            this.flength = resourceFilterArray.length;
            this.filters = new ResourceFilter[Math.max(8, this.flength)];
            System.arraycopy(resourceFilterArray, 0, this.filters, 0, this.flength);
        } else {
            int n = this.flength + resourceFilterArray.length;
            if (n >= this.filters.length) {
                int n2 = Math.max(n, this.filters.length + 4);
                ResourceFilter[] resourceFilterArray2 = new ResourceFilter[n2];
                System.arraycopy(this.filters, 0, resourceFilterArray2, 0, this.flength);
                this.filters = resourceFilterArray2;
            }
            System.arraycopy(resourceFilterArray, 0, this.filters, this.flength, resourceFilterArray.length);
            this.flength += resourceFilterArray.length;
        }
    }

    public ResourceFilter[] getFilters() {
        if (this.filters != null && this.filters.length != this.flength) {
            ResourceFilter[] resourceFilterArray = new ResourceFilter[this.flength];
            System.arraycopy(this.filters, 0, resourceFilterArray, 0, this.flength);
            this.filters = resourceFilterArray;
        }
        return this.filters;
    }

    public ReplyInterface getReply() {
        return this.reply;
    }

    public ResourceReference getTarget() {
        return this.target;
    }

    public boolean hasReply() {
        return this.reply != null;
    }

    public void setReply(ReplyInterface replyInterface) {
        this.reply = replyInterface;
    }

    public void setTarget(ResourceReference resourceReference) {
        this.target = resourceReference;
    }
}

