/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.tools.jpeg.JpegCommentWriter;
import org.w3c.tools.jpeg.JpegException;
import org.w3c.tools.jpeg.JpegHeaders;

public class JpegCommentHandler {
    protected File jpegfile;
    protected InputStream in;

    public JpegCommentHandler(File file) throws FileNotFoundException {
        this.in = new BufferedInputStream(new FileInputStream(file));
        this.jpegfile = file;
    }

    public JpegCommentHandler(InputStream inputStream) {
        this.in = inputStream;
    }

    public String getComment() throws IOException, JpegException {
        JpegHeaders jpegHeaders = new JpegHeaders(this.in);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = jpegHeaders.getComments();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Writer getOutputStreamWriter(OutputStream outputStream) {
        return new JpegCommentWriter(outputStream, this.in);
    }

    public Writer getOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        return new JpegCommentWriter(outputStream, this.in, string);
    }

    public Reader getReader() throws IOException, JpegException {
        return new StringReader(this.getComment());
    }
}

