/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.zip;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.jigsaw.zip.ZipIndexer;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.indexer.ResourceIndexer;
import org.w3c.util.EmptyEnumeration;

public class ZipDirectoryResource
extends DirectoryResource {
    protected static int ATTR_ZIPFILE = -1;
    protected static int ATTR_ENTRYPATH = -1;
    protected Hashtable directories = new Hashtable(3);

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.zip.ZipDirectoryResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new FileAttribute("zipfile", null, 1);
        ATTR_ZIPFILE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("entrypath", null, 1);
        ATTR_ENTRYPATH = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public ResourceReference createDirectoryResource(String string) {
        return null;
    }

    public ResourceReference createResource(String string) {
        return null;
    }

    protected boolean entryExists(String string) {
        boolean bl;
        File file = this.getZipFile();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        String string2 = this.getEntryPath();
        String string3 = null;
        string3 = string2 != null ? (string2.endsWith("/") ? String.valueOf(string2) + string : String.valueOf(string2) + "/" + string) : string;
        try {
            bl = zipFile.getEntry(string3) != null || zipFile.getEntry(String.valueOf(string3) + "/") != null;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    protected synchronized Enumeration enumerateAllResourceIdentifiers() {
        return this.enumerateResourceIdentifiers(true);
    }

    public synchronized Enumeration enumerateResourceIdentifiers(boolean bl) {
        File file = this.getZipFile();
        ZipFile zipFile = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(20);
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            return new EmptyEnumeration();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = null;
        String string = null;
        int n = -1;
        String string2 = this.getEntryPath();
        if (string2 == null) {
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                string = zipEntry.getName();
                n = string.indexOf(47);
                if (n != -1) {
                    string = string.substring(0, n);
                    this.directories.put(string, Boolean.TRUE);
                }
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, Boolean.TRUE);
                if (this.lookup(string) != null) continue;
                this.createDefaultResource(string);
            }
        } else {
            int n2 = string2.length();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                string = zipEntry.getName();
                if (!string.startsWith(string2) || string.length() <= n2 + 1) continue;
                n = (string = string.substring(n2 + 1)).indexOf(47);
                if (n != -1) {
                    if ((string = string.substring(0, n)).length() == 0) continue;
                    this.directories.put(string, Boolean.TRUE);
                }
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, Boolean.TRUE);
                if (this.lookup(string) != null) continue;
                this.createDefaultResource(string);
            }
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {}
        ResourceSpace resourceSpace = this.getSpace();
        this.acquireChildren();
        return resourceSpace.enumerateResourceIdentifiers(this.getChildrenSpaceEntry());
    }

    public String getEntryPath() {
        return this.getString(ATTR_ENTRYPATH, null);
    }

    public synchronized File getZipFile() {
        return (File)this.getValue(ATTR_ZIPFILE, (Object)this.getDirectory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Resource index(String string, Hashtable hashtable, RequestInterface requestInterface) {
        if (!this.entryExists(string)) {
            return null;
        }
        hashtable.put("identifier", string);
        this.updateDefaultChildAttributes(hashtable);
        ResourceContext resourceContext = this.getContext();
        Resource resource = null;
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = null;
        while (true) {
            Object var10_8;
            block9: {
                if (resourceContext == null) {
                    return resource;
                }
                do {
                    resourceReference = this.getIndexer(resourceContext);
                    resourceContext = resourceContext.getParent();
                } while (resourceReference == resourceReference2 && resourceContext != null);
                resourceReference2 = resourceReference;
                if (resourceReference2 == null) continue;
                try {
                    try {
                        ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                        if (!(resourceIndexer instanceof ZipIndexer)) {
                            Resource resource2 = null;
                            var10_8 = null;
                            resourceReference.unlock();
                            return resource2;
                        }
                        ZipIndexer zipIndexer = (ZipIndexer)resourceIndexer;
                        resource = this.directories.get(string) != null ? zipIndexer.createDirectoryResource(this.getDirectory(), string, hashtable) : zipIndexer.createFileResource(this.getDirectory(), string, hashtable);
                        if (resource == null) break block9;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        resource = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    var10_8 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
                var10_8 = null;
                resourceReference.unlock();
                return resource;
            }
            var10_8 = null;
            resourceReference.unlock();
        }
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.disableEvent();
        if (this.getZipFile() != null) {
            this.setValue(DirectoryResource.ATTR_DIRECTORY, (Object)this.getZipFile());
        }
        this.enableEvent();
    }

    public synchronized void reindex() {
    }

    protected ResourceContext updateDefaultChildAttributes(Hashtable hashtable) {
        hashtable.put("zipfile", this.getZipFile());
        String string = null;
        string = this.getEntryPath() != null ? String.valueOf(this.getEntryPath()) + "/" + (String)hashtable.get("identifier") : (String)hashtable.get("identifier");
        hashtable.put("entrypath", string);
        return super.updateDefaultChildAttributes(hashtable);
    }
}

