/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.ServletWrapper;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.www.mime.MimeType;

public class ServletWrapperFrame
extends HTTPFrame {
    protected ServletWrapper wrapper = null;

    public Reply createDefaultReply(Request request, int n) {
        Reply reply = super.createDefaultReply(request, n);
        reply.setLastModified(-1L);
        return reply;
    }

    protected boolean lookupOther(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Request request;
        String string = lookupState.getRemainingPath(true);
        if (string == null || string.equals("")) {
            string = "/";
        }
        if ((request = (Request)lookupState.getRequest()) != null && request.getState("javax.servlet.include.path_info") == null) {
            request.setState("javax.servlet.include.path_info", string);
        }
        lookupResult.setTarget(this.resource.getResourceReference());
        return super.lookupOther(lookupState, lookupResult);
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        Reply reply;
        block26: {
            ReplyInterface replyInterface = this.performFrames(requestInterface);
            if (replyInterface != null) {
                return replyInterface;
            }
            if (!this.checkRequest(requestInterface)) {
                return null;
            }
            Request request = (Request)requestInterface;
            if (this.wrapper == null) {
                Reply reply2 = request.makeReply(500);
                reply2.setContent("Servlet Wrapper Frame not configured properly: must be attached to a ServletWrapper.");
                throw new HTTPException(reply2);
            }
            try {
                this.wrapper.checkServlet();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Reply reply3 = request.makeReply(500);
                reply3.setContent("The server was unable to find the servlet class : " + classNotFoundException.getMessage());
                throw new HTTPException(reply3);
            }
            catch (ServletException servletException) {
                Reply reply4 = request.makeReply(500);
                reply4.setContent("The server was unable to initialize the servlet : " + servletException.getMessage());
                throw new HTTPException(reply4);
            }
            if (!this.wrapper.isInited()) {
                Reply reply5 = request.makeReply(500);
                reply5.setContent("Servlet not configured properly");
                throw new HTTPException(reply5);
            }
            reply = this.createDefaultReply(request, 200);
            reply.setContentType(MimeType.TEXT_HTML);
            try {
                if (request.hasState("org.w3c.jigsaw.servlet.included")) {
                    this.wrapper.service(request, reply);
                    break block26;
                }
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                reply.setState("org.w3c.jigsaw.servlet.stream", pipedOutputStream);
                reply.setStream(pipedInputStream);
                Object object = new Object();
                reply.setState("org.w3c.jigsaw.servlet.monitor", object);
                ServerInterface serverInterface = this.getServer();
                if (serverInterface instanceof httpd) {
                    Object object2 = object;
                    synchronized (object2) {
                        this.wrapper.service(request, reply);
                        object.wait(((httpd)serverInterface).getRequestTimeOut());
                    }
                    object2 = reply.getState("org.w3c.jigsaw.servlet.stream");
                    if (object2 == null) break block26;
                    try {
                        pipedInputStream.close();
                        pipedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    if (object2 instanceof PipedOutputStream) {
                        Thread thread = (Thread)reply.getState("org.w3c.jigsaw.servlet.runner");
                        if (thread != null) {
                            thread.interrupt();
                        }
                        throw new ServletException("Timed out");
                    }
                    break block26;
                }
                Object object3 = object;
                synchronized (object3) {
                    this.wrapper.service(request, reply);
                    object.wait();
                }
            }
            catch (UnavailableException unavailableException) {
                reply = request.makeReply(503);
                if (unavailableException.isPermanent()) {
                    reply.setContent("<h2>The servlet is permanently unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>");
                } else {
                    int n = unavailableException.getUnavailableSeconds();
                    if (n > 0) {
                        reply.setRetryAfter(n);
                        reply.setContent("<h2>The servlet is temporarily unavailable :</h2>Delay : " + n + " seconds<br><br>Details: <b>" + unavailableException.getMessage() + "</b>");
                    } else {
                        reply.setContent("<h2>The servlet is temporarily unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>");
                    }
                }
            }
            catch (Exception exception) {
                reply = request.makeReply(500);
                reply.setContent("Servlet has thrown exception:" + exception.toString());
            }
        }
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
        if (framedResource instanceof ServletWrapper) {
            this.wrapper = (ServletWrapper)framedResource;
        }
    }
}

