/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.proxy.ForwardFrame;
import org.w3c.jigsaw.resources.VirtualHostResource;
import org.w3c.jigsaw.servlet.AutoReloadServletLoader;
import org.w3c.jigsaw.servlet.JigsawRequestDispatcher;
import org.w3c.jigsaw.servlet.ServletDirectoryFrame;
import org.w3c.jigsaw.servlet.ServletProps;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.tools.resources.event.StructureChangedAdapter;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.util.EmptyEnumeration;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.mime.Utils;

public class JigsawServletContext
extends StructureChangedAdapter
implements ServletContext,
PropertyMonitoring {
    public static final String TEMPDIR_P = "javax.servlet.context.tempdir";
    private ResourceReference reference = null;
    private Logger logger = null;
    private ObservableProperties props = null;
    private File directory = null;
    private Hashtable attributes = null;
    protected static String logdir = "logs";
    protected static String deflogfile = "servlets";
    private AutoReloadServletLoader loader = null;

    protected JigsawServletContext(ResourceReference resourceReference, ObservableProperties observableProperties) {
        this.reference = resourceReference;
        this.props = observableProperties;
        this.attributes = new Hashtable(3);
        this.logger = new Logger(this.getServletLogFile());
        this.loader = new AutoReloadServletLoader(this);
        observableProperties.registerObserver(this);
        try {
            try {
                Resource resource = this.reference.lock();
                if (!(resource instanceof ServletDirectoryFrame)) {
                    throw new IllegalArgumentException("This reference is not pointing on a ServletDirectoryFrame.");
                }
                ServletDirectoryFrame servletDirectoryFrame = (ServletDirectoryFrame)resource;
                FramedResource framedResource = servletDirectoryFrame.getResource();
                framedResource.addStructureChangedListener(this);
                if (framedResource.definesAttribute("directory")) {
                    this.directory = (File)framedResource.getValue("directory", null);
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                throw new IllegalArgumentException("This reference is pointing on an Invalid ServletDirectoryFrame.");
            }
            Object var4_6 = null;
            this.reference.unlock();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    protected synchronized AutoReloadServletLoader createNewLocalServletLoader(boolean bl) {
        this.loader = this.loader != null && bl ? new AutoReloadServletLoader(this.loader) : new AutoReloadServletLoader(this);
        return this.loader;
    }

    public Object getAttribute(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return v;
        }
        try {
            try {
                Resource resource = this.reference.lock();
                Object object = ((ServletDirectoryFrame)resource).getAttribute(string);
                Object var5_7 = null;
                this.reference.unlock();
                return object;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Object var3_6 = null;
                Object var5_8 = null;
                this.reference.unlock();
                return var3_6;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String string) {
        LookupState lookupState;
        if (string == null) {
            return null;
        }
        ResourceReference resourceReference = null;
        resourceReference = ((httpd)this.getServer()).getRootReference();
        FramedResource framedResource = null;
        framedResource = ((httpd)this.getServer()).getRoot();
        ResourceReference resourceReference2 = null;
        try {
            lookupState = new LookupState(string);
            LookupResult lookupResult = new LookupResult(resourceReference);
            framedResource.lookup(lookupState, lookupResult);
            resourceReference2 = lookupResult.getTarget();
        }
        catch (Exception exception) {
            resourceReference2 = null;
        }
        if (resourceReference2 != null) {
            try {
                try {
                    ServletDirectoryFrame servletDirectoryFrame;
                    Resource resource = resourceReference2.lock();
                    if (resource instanceof FramedResource && (servletDirectoryFrame = (ServletDirectoryFrame)((FramedResource)resource).getFrame("org.w3c.jigsaw.servlet.ServletDirectoryFrame")) != null) {
                        lookupState = servletDirectoryFrame.getServletContext();
                        Object var7_10 = null;
                        resourceReference2.unlock();
                        return lookupState;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                resourceReference2.unlock();
                throw throwable;
            }
            Object var7_11 = null;
            resourceReference2.unlock();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getFilePath(DirectoryResource directoryResource) {
        HTTPFrame hTTPFrame = (HTTPFrame)directoryResource.getFrame("org.w3c.jigsaw.frames.HTTPFrame");
        String[] stringArray = hTTPFrame.getIndexes();
        if (stringArray == null) {
            return directoryResource.getDirectory().getAbsolutePath();
        }
        int n = 0;
        while (true) {
            block10: {
                ResourceReference resourceReference;
                if (n >= stringArray.length) {
                    return directoryResource.getDirectory().getAbsolutePath();
                }
                String string = stringArray[n];
                if (string != null && string.length() > 0 && (resourceReference = directoryResource.lookup(string)) != null) {
                    String string2;
                    Object var8_6;
                    try {
                        try {
                            FramedResource framedResource = (FramedResource)resourceReference.lock();
                            if (framedResource instanceof FileResource) {
                                FileResource fileResource = (FileResource)framedResource;
                                File file = fileResource.getFile();
                                String string3 = file.getAbsolutePath();
                                var8_6 = null;
                                resourceReference.unlock();
                                return string3;
                            }
                            string2 = null;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            var8_6 = null;
                            resourceReference.unlock();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_6 = null;
                        resourceReference.unlock();
                        throw throwable;
                    }
                    var8_6 = null;
                    resourceReference.unlock();
                    return string2;
                }
            }
            ++n;
        }
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new EmptyEnumeration();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ResourceReference getLocalRoot(ResourceReference resourceReference, ResourceReference resourceReference2) {
        ResourceReference resourceReference3;
        block23: {
            ResourceReference resourceReference4;
            block22: {
                try {
                    try {
                        FramedResource framedResource = (FramedResource)resourceReference.lock();
                        if (framedResource instanceof VirtualHostResource) {
                            Object var10_18;
                            ResourceReference resourceReference5 = null;
                            ResourceReference resourceReference6 = null;
                            FramedResource framedResource2 = null;
                            try {
                                try {
                                    framedResource2 = (FramedResource)resourceReference2.lock();
                                    if (framedResource2 instanceof ResourceFrame) {
                                        ResourceFrame resourceFrame = (ResourceFrame)framedResource2;
                                        resourceReference5 = resourceFrame.getResource().getResourceReference();
                                    } else {
                                        resourceReference5 = resourceReference2;
                                    }
                                }
                                catch (InvalidResourceException invalidResourceException) {
                                    ResourceReference resourceReference7 = resourceReference;
                                    Object var10_17 = null;
                                    resourceReference2.unlock();
                                    Object var4_20 = null;
                                    resourceReference.unlock();
                                    return resourceReference7;
                                }
                                var10_18 = null;
                                resourceReference2.unlock();
                            }
                            catch (Throwable throwable) {
                                Object var10_19 = null;
                                resourceReference2.unlock();
                                throw throwable;
                            }
                            while (true) {
                                block20: {
                                    ResourceReference resourceReference8;
                                    try {
                                        try {
                                            framedResource2 = (FramedResource)resourceReference5.lock();
                                            resourceReference6 = framedResource2.getParent();
                                            if (resourceReference6 != resourceReference && resourceReference6 != null) break block20;
                                            resourceReference8 = JigsawServletContext.getLocalRoot(resourceReference5, resourceReference2);
                                            var10_18 = null;
                                            resourceReference5.unlock();
                                        }
                                        catch (InvalidResourceException invalidResourceException) {
                                            ResourceReference resourceReference9 = resourceReference;
                                            var10_18 = null;
                                            resourceReference5.unlock();
                                            Object var4_22 = null;
                                            resourceReference.unlock();
                                            return resourceReference9;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var10_18 = null;
                                        resourceReference5.unlock();
                                        throw throwable;
                                    }
                                    Object var4_21 = null;
                                    resourceReference.unlock();
                                    return resourceReference8;
                                }
                                var10_18 = null;
                                resourceReference5.unlock();
                                resourceReference5 = resourceReference6;
                            }
                        }
                        try {
                            FramedResource framedResource3 = (FramedResource)resourceReference.lock();
                            ForwardFrame forwardFrame = (ForwardFrame)framedResource3.getFrame("org.w3c.jigsaw.proxy.ForwardFrame");
                            if (forwardFrame == null) {
                                resourceReference4 = resourceReference;
                                break block22;
                            }
                            ResourceReference resourceReference10 = forwardFrame.getLocalRootResource();
                            resourceReference3 = JigsawServletContext.getLocalRoot(resourceReference10, resourceReference2);
                            break block23;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            ResourceReference resourceReference11 = resourceReference;
                            Object var4_25 = null;
                            resourceReference.unlock();
                            return resourceReference11;
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        ResourceReference resourceReference12 = resourceReference;
                        Object var4_26 = null;
                        resourceReference.unlock();
                        return resourceReference12;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_27 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
            }
            Object var4_23 = null;
            resourceReference.unlock();
            return resourceReference4;
        }
        Object var4_24 = null;
        resourceReference.unlock();
        return resourceReference3;
    }

    protected synchronized AutoReloadServletLoader getLocalServletLoader() {
        if (this.loader == null) {
            this.loader = new AutoReloadServletLoader(this);
        }
        return this.loader;
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String string) {
        return JigsawServletContext.guessContentTypeFromName(string);
    }

    public int getMinorVersion() {
        return 2;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        return JigsawRequestDispatcher.getRequestDispatcher(string, this.reference, (httpd)this.getServer());
    }

    public String getRealPath(String string) {
        ResourceReference resourceReference = ((httpd)this.getServer()).getRootReference();
        return JigsawServletContext.getRealPath(string, resourceReference, this.reference);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getRealPath(String string, ResourceReference resourceReference, ResourceReference resourceReference2) {
        String string2;
        ResourceReference resourceReference3;
        block13: {
            String string3;
            block12: {
                resourceReference3 = JigsawServletContext.getLocalRoot(resourceReference, resourceReference2);
                try {
                    try {
                        ResourceReference resourceReference4;
                        FramedResource framedResource = (FramedResource)resourceReference3.lock();
                        LookupState lookupState = new LookupState(string);
                        LookupResult lookupResult = new LookupResult(resourceReference3);
                        if (framedResource.lookup(lookupState, lookupResult) && (resourceReference4 = lookupResult.getTarget()) != null) {
                            block10: {
                                block11: {
                                    String string4;
                                    block9: {
                                        try {
                                            FramedResource framedResource2 = (FramedResource)resourceReference4.lock();
                                            if (framedResource2 instanceof FileResource) {
                                                File file = ((FileResource)framedResource2).getFile();
                                                string4 = file.getAbsolutePath();
                                                Object var12_16 = null;
                                                resourceReference4.unlock();
                                                break block9;
                                            }
                                            if (!(framedResource2 instanceof DirectoryResource)) break block10;
                                            DirectoryResource directoryResource = (DirectoryResource)framedResource2;
                                            string3 = directoryResource.getDirectory().getAbsolutePath();
                                            break block11;
                                        }
                                        catch (Throwable throwable) {
                                            Object var12_19 = null;
                                            resourceReference4.unlock();
                                            throw throwable;
                                        }
                                    }
                                    Object var6_20 = null;
                                    resourceReference3.unlock();
                                    return string4;
                                }
                                Object var12_17 = null;
                                resourceReference4.unlock();
                                break block12;
                            }
                            Object var12_18 = null;
                            resourceReference4.unlock();
                        }
                        string2 = null;
                        break block13;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        String string5 = null;
                        Object var6_23 = null;
                        resourceReference3.unlock();
                        return string5;
                    }
                    catch (ProtocolException protocolException) {
                        String string6 = null;
                        Object var6_24 = null;
                        resourceReference3.unlock();
                        return string6;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_25 = null;
                    resourceReference3.unlock();
                    throw throwable;
                }
            }
            Object var6_21 = null;
            resourceReference3.unlock();
            return string3;
        }
        Object var6_22 = null;
        resourceReference3.unlock();
        return string2;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return JigsawRequestDispatcher.getRequestDispatcher(string, (httpd)this.getServer(), this.reference);
    }

    public URL getResource(String string) throws MalformedURLException {
        File file = new File(string);
        if (file.exists()) {
            return new URL("file", "", file.getAbsolutePath());
        }
        String string2 = this.getRealPath(string);
        if (string2 != null) {
            file = new File(string2);
            if (file.exists()) {
                return new URL("file", "", file.getAbsolutePath());
            }
            return null;
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            try {
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ServerInterface getServer() {
        try {
            try {
                Resource resource = this.reference.lock();
                ServerInterface serverInterface = ((ServletDirectoryFrame)resource).getServer();
                Object var3_5 = null;
                this.reference.unlock();
                return serverInterface;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                ServerInterface serverInterface = null;
                Object var3_6 = null;
                this.reference.unlock();
                return serverInterface;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    public String getServerInfo() {
        try {
            try {
                Resource resource = this.reference.lock();
                String string = ((ServletDirectoryFrame)resource).getServerInfo();
                Object var3_5 = null;
                this.reference.unlock();
                return string;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                String string = null;
                Object var3_6 = null;
                this.reference.unlock();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    public Servlet getServlet(String string) {
        try {
            try {
                Resource resource = this.reference.lock();
                Servlet servlet = ((ServletDirectoryFrame)resource).getServlet(string);
                Object var4_6 = null;
                this.reference.unlock();
                return servlet;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Servlet servlet = null;
                Object var4_7 = null;
                this.reference.unlock();
                return servlet;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    public File getServletDirectory() {
        return this.directory;
    }

    public File getServletLogFile() {
        ServerInterface serverInterface = this.getServer();
        File file = null;
        String string = serverInterface.getProperties().getString(ServletProps.SERVLET_LOG_FILE_P, null);
        if (string != null) {
            file = new File(string);
        }
        if (file != null && file.getPath().length() < 1) {
            file = null;
        }
        if (file == null) {
            File file2 = serverInterface.getRootDirectory();
            if (file2 == null) {
                throw new RuntimeException("unable to build a default value for the servlet log file.");
            }
            file = new File(new File(file2, logdir), deflogfile);
            serverInterface.getProperties().putValue(ServletProps.SERVLET_LOG_FILE_P, file.getAbsolutePath());
        }
        return file;
    }

    public Enumeration getServletNames() {
        try {
            try {
                Resource resource = this.reference.lock();
                Enumeration enumeration = ((ServletDirectoryFrame)resource).getServletNames();
                Object var3_5 = null;
                this.reference.unlock();
                return enumeration;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Enumeration enumeration = null;
                Object var3_6 = null;
                this.reference.unlock();
                return enumeration;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    protected long getServletTimeout() {
        return this.props.getLong(ServletProps.SERVLET_TIMEOUT, -1L);
    }

    public Enumeration getServlets() {
        try {
            try {
                Resource resource = this.reference.lock();
                Enumeration enumeration = ((ServletDirectoryFrame)resource).getServlets();
                Object var3_5 = null;
                this.reference.unlock();
                return enumeration;
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Enumeration enumeration = null;
                Object var3_6 = null;
                this.reference.unlock();
                return enumeration;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.reference.unlock();
            throw throwable;
        }
    }

    protected static String guessContentTypeFromName(String string) {
        return Utils.guessContentTypeFromName(string);
    }

    public void log(Exception exception, String string) {
        this.logger.log(exception, string);
    }

    public void log(String string) {
        this.logger.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.logger.log(throwable, string);
    }

    public boolean propertyChanged(String string) {
        if (string.equals(ServletProps.SERVLET_LOG_FILE_P) && this.logger != null) {
            this.logger.close();
            File file = new File((String)((Hashtable)this.props).get(ServletProps.SERVLET_LOG_FILE_P));
            if (file.getPath().length() < 1) {
                file = this.getServletLogFile();
            }
            this.logger = new Logger(file);
        }
        return true;
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void resourceUnloaded(StructureChangedEvent structureChangedEvent) {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    class Logger {
        File logfile = null;
        RandomAccessFile log = null;
        byte[] msgbuf = null;
        boolean closed = true;
        private final String[] monthnames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        Logger(File file) {
            this.logfile = file;
            this.msgbuf = new byte[128];
            this.log("Servlet Logger started");
        }

        void close() {
            try {
                if (this.log != null) {
                    this.log.close();
                }
                this.closed = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        String getDate() {
            Date date = new Date();
            return String.valueOf(date.getDate()) + "/" + this.monthnames[date.getMonth()] + "/" + (date.getYear() + 1900) + (date.getHours() < 10 ? ":0" + date.getHours() : ":" + date.getHours()) + (date.getMinutes() < 10 ? ":0" + date.getMinutes() : ":" + date.getMinutes()) + (date.getSeconds() < 10 ? ":0" + date.getSeconds() : ":" + date.getSeconds()) + (date.getTimezoneOffset() < 0 ? " " + date.getTimezoneOffset() / 60 : " +" + date.getTimezoneOffset() / 60);
        }

        void log(Exception exception, String string) {
            this.log(String.valueOf(string) + " : " + exception.getClass().getName() + " (" + exception.getMessage() + ")");
        }

        void log(String string) {
            string = "[" + this.getDate() + "] " + string + "\n";
            try {
                if (this.log == null || this.closed) {
                    this.openLogFile();
                }
                if (this.log != null) {
                    int n = string.length();
                    if (n > this.msgbuf.length) {
                        this.msgbuf = new byte[n];
                    }
                    string.getBytes(0, n, this.msgbuf, 0);
                    this.log.write(this.msgbuf, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Can't write (" + string + ") to logfile [" + this.logfile + "] : " + iOException.getMessage());
            }
        }

        void log(Throwable throwable, String string) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            String string2 = byteArrayOutputStream.toString();
            this.log(String.valueOf(string) + " " + string2);
        }

        void openLogFile() throws IOException {
            RandomAccessFile randomAccessFile = this.log;
            this.log = new RandomAccessFile(this.logfile, "rw");
            this.log.seek(this.log.length());
            this.closed = false;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }
}

