/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.resources;

import java.util.Date;
import org.w3c.jigsaw.http.Logger;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.SimpleAttribute;

public class CheckpointResource
extends FramedResource
implements Runnable {
    private static final boolean debug = true;
    protected static int ATTR_INTERVAL = -1;
    protected static int ATTR_PRIORITY = -1;
    protected static int ATTR_FLUSHLOG = -1;
    protected static int ATTR_FLUSHPROPS = -1;
    protected static int ATTR_FLUSHCONFIG = -1;
    protected static int ATTR_TRACE_CHECK = -1;
    protected Thread thread = null;
    protected Date checkpoint = null;
    protected boolean alive = false;

    static {
        Class<?> clazz = null;
        SimpleAttribute simpleAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.resources.CheckpointResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new IntegerAttribute("interval", new Integer(60), 2);
        ATTR_INTERVAL = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("thread-priority", new Integer(2), 2);
        ATTR_PRIORITY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("flush-logs", Boolean.FALSE, 2);
        ATTR_FLUSHLOG = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("flush-properties", Boolean.FALSE, 2);
        ATTR_FLUSHPROPS = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("flush-configuration", Boolean.TRUE, 2);
        ATTR_FLUSHCONFIG = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("trace-checkpoint", Boolean.FALSE, 2);
        ATTR_TRACE_CHECK = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public boolean acceptUnload() {
        return false;
    }

    public synchronized void activate() {
        if ((this.getFlushLog() || this.getFlushProperties() || this.getFlushConfiguration()) && this.getInterval() > 0) {
            this.alive = true;
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setName("checkpointer");
                this.thread.setPriority(this.getPriority());
                this.thread.start();
                return;
            }
            return;
        }
        if (this.thread != null) {
            this.alive = false;
            this.thread.stop();
            this.thread = null;
        }
    }

    public boolean getFlushConfiguration() {
        return this.getBoolean(ATTR_FLUSHCONFIG, true);
    }

    public boolean getFlushLog() {
        return this.getBoolean(ATTR_FLUSHLOG, false);
    }

    public boolean getFlushProperties() {
        return this.getBoolean(ATTR_FLUSHPROPS, false);
    }

    public int getInterval() {
        return this.getInt(ATTR_INTERVAL, -1);
    }

    public int getPriority() {
        return this.getInt(ATTR_PRIORITY, 2);
    }

    public boolean getTraceFlag() {
        return this.getBoolean(ATTR_TRACE_CHECK, false);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        try {
            this.registerFrameIfNone("org.w3c.jigsaw.resources.CheckpointFrame", "checkpoint-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void notifyUnload() {
        this.stop();
        super.notifyUnload();
    }

    public void run() {
        httpd httpd2 = (httpd)this.getServer();
        int n = -1;
        try {
            try {
                while (this.alive) {
                    n = this.getInterval();
                    boolean bl = this.alive = (this.getFlushLog() || this.getFlushProperties() || this.getFlushConfiguration()) && n > 0;
                    if (!this.alive) break;
                    Object object = this;
                    synchronized (object) {
                        try {
                            this.wait(n * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.checkpoint = new Date();
                    if (this.getTraceFlag()) {
                        System.out.println("*** Checkpoint (" + httpd2.getIdentifier() + ") at " + this.checkpoint);
                    }
                    if (this.alive && this.getFlushConfiguration()) {
                        httpd2.checkpoint();
                    }
                    if (!this.alive || !this.getFlushLog() || (object = ((httpd)this.getServer()).getLogger()) == null) continue;
                    ((Logger)object).sync();
                }
            }
            catch (Exception exception) {
                String string = "exception while running \"" + exception.getMessage() + "\". Stopped.";
                httpd2.errlog(this, string);
            }
            Object var4_6 = null;
            this.thread = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.thread = null;
            throw throwable;
        }
    }

    protected synchronized void stop() {
        this.alive = false;
        this.thread = null;
        this.notify();
    }
}

