/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.proxy;

import java.io.File;
import org.w3c.jigsaw.config.PropertySet;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.proxy.CacheProp;
import org.w3c.jigsaw.proxy.ProxyDispatcherProp;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.util.ObservableProperties;
import org.w3c.www.protocol.http.micp.MICPProp;

class ProxyProp
extends PropertySet {
    private static String title = "Proxy properties";
    private static String MICP_PROP_NAME = "micp";
    private static String CACHE_PROP_NAME = "cache";
    private static String PROXY_DISP_PROP_NAME = "dispatcher";
    protected static int ATTR_FILTERS = -1;

    static {
        Class<?> clazz = null;
        Attribute attribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.proxy.ProxyProp");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new IntegerAttribute("org.w3c.www.protocol.http.connections.max", new Integer(20), 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("org.w3c.www.protocol.http.connections.timeout", new Integer(300000), 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("proxySet", null, 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("proxyHost", null, 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("proxyPort", new Integer(80), 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("org.w3c.www.protocol.http.lenient", null, 2);
        AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("org.w3c.www.protocol.http.filters", null, 2);
        ATTR_FILTERS = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    ProxyProp(String string, httpd httpd2) {
        super(string, httpd2);
        this.initializeFiltersProps();
    }

    protected String[] getFilters() {
        return (String[])this.getValue(ATTR_FILTERS, null);
    }

    public String getTitle() {
        return title;
    }

    protected void initializeFiltersProps() {
        String[] stringArray = this.getFilters();
        if (stringArray == null) {
            return;
        }
        PropertySet propertySet = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("org.w3c.www.protocol.http.micp.MICPFilter")) {
                if (this.server.getPropertySet(MICP_PROP_NAME) == null) {
                    propertySet = new MICPProp(MICP_PROP_NAME, this.server);
                    this.server.registerPropertySet(propertySet);
                }
            } else if (stringArray[n].equals("org.w3c.www.protocol.http.cache.CacheFilter")) {
                if (this.server.getPropertySet(CACHE_PROP_NAME) == null) {
                    propertySet = new CacheProp(CACHE_PROP_NAME, this.server);
                    this.server.registerPropertySet(propertySet);
                    ObservableProperties observableProperties = this.server.getProperties();
                    File file = observableProperties.getFile("org.w3c.www.protocol.http.cache.directory", null);
                    if (file == null) {
                        file = new File(this.server.getConfigDirectory(), "cache");
                        observableProperties.putValue("org.w3c.www.protocol.http.cache.directory", file.getAbsolutePath());
                    }
                }
            } else if (stringArray[n].equals("org.w3c.www.protocol.http.proxy.ProxyDispatcher") && this.server.getPropertySet(PROXY_DISP_PROP_NAME) == null) {
                propertySet = new ProxyDispatcherProp(PROXY_DISP_PROP_NAME, this.server);
                this.server.registerPropertySet(propertySet);
            }
            ++n;
        }
    }

    public synchronized void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_FILTERS) {
            this.initializeFiltersProps();
        }
    }
}

