/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import org.w3c.jigsaw.http.Reply;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;

public class HeaderFilter
extends ResourceFilter {
    protected static int ATTR_HEADER_NAME = -1;
    protected static int ATTR_HEADER_VALUE = -1;
    protected static int ATTR_NOCACHE = -1;
    protected static int ATTR_CONNECTION = -1;

    static {
        Class<?> clazz = null;
        SimpleAttribute simpleAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.HeaderFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new StringAttribute("header-name", null, 2);
        ATTR_HEADER_NAME = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("header-value", null, 2);
        ATTR_HEADER_VALUE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("no-cache", Boolean.FALSE, 2);
        ATTR_NOCACHE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("connection", Boolean.FALSE, 2);
        ATTR_CONNECTION = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public boolean checkConnection() {
        return this.getBoolean(ATTR_CONNECTION, false);
    }

    public boolean checkNoCache() {
        return this.getBoolean(ATTR_NOCACHE, false);
    }

    public String getHeaderName() {
        String string = this.getString(ATTR_HEADER_NAME, null);
        return string;
    }

    public String getHeaderValue() {
        return this.getString(ATTR_HEADER_VALUE, null);
    }

    public ReplyInterface ingoingFilter(RequestInterface requestInterface) throws ProtocolException {
        return null;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        Reply reply = (Reply)replyInterface;
        String string = this.getHeaderName();
        if (string != null) {
            String string2 = this.getHeaderValue();
            if (string2 == null) {
                reply.removeHeader(string);
            } else {
                reply.setValue(string, string2);
            }
            if (this.checkNoCache()) {
                reply.addNoCache(string);
            }
            if (this.checkConnection()) {
                reply.addConnection(string);
            }
        }
        return null;
    }
}

