/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.daemon;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.util.ObservableProperties;

public class DaemonProperties {
    protected Hashtable propspace = new Hashtable(5);
    protected Properties globprops = null;
    protected File configdir = null;

    public DaemonProperties(File file, Properties properties) {
        this.configdir = file;
        this.globprops = properties;
    }

    public String getProperty(String string) {
        return this.globprops != null ? this.globprops.getProperty(string) : null;
    }

    public ObservableProperties getPropertySpace(String string) {
        return (ObservableProperties)this.propspace.get(string);
    }

    public String getString(String string, String string2) {
        return this.globprops != null ? this.globprops.getProperty(string, string2) : string2;
    }

    public void load(InputStream inputStream) throws IOException {
        if (this.globprops == null) {
            this.globprops = new Properties();
        }
        this.globprops.load(inputStream);
    }

    public ObservableProperties loadPropertySpace(String string) throws IOException, FileNotFoundException {
        File file = new File(this.configdir, String.valueOf(string) + ".props");
        ObservableProperties observableProperties = null;
        observableProperties = this.loadPropertySpace(string, new BufferedInputStream(new FileInputStream(file)));
        ((Hashtable)observableProperties).put("org.w3c.jigsaw.propfile", file.getAbsolutePath());
        return observableProperties;
    }

    public ObservableProperties loadPropertySpace(String string, InputStream inputStream) throws IOException {
        ObservableProperties observableProperties = (ObservableProperties)this.propspace.get(string);
        if (observableProperties == null) {
            observableProperties = new ObservableProperties(this.globprops);
            this.propspace.put(string, observableProperties);
        }
        observableProperties.load(inputStream);
        return observableProperties;
    }

    public void save() {
        System.out.println("DaemonProperties.save: not implemented !");
    }

    public void savePropertySpace(String string) {
        System.out.println("DaemonProperties.save [" + string + "]; not implemented!");
    }
}

