/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.w3c.jigsaw.acl.AclPrincipal;
import org.w3c.jigsaw.acl.HTTPPrincipal;
import org.w3c.jigsaw.acl.InvalidAuthException;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.StringUtils;
import org.w3c.www.http.HttpCredential;

public class DigestAuthPrincipal
extends HTTPPrincipal {
    String dac_user = null;
    String dac_realm = null;
    String dac_nonce = null;
    String dac_uri = null;
    String dac_response = null;
    String dac_algorithm = null;
    String dac_method = null;
    String nonce = null;
    String old_nonce = null;
    String algo = null;
    boolean stale = false;
    boolean no_user = false;

    public DigestAuthPrincipal(Request request) throws InvalidAuthException {
        super(request);
        throw new InvalidAuthException("Bad call for authentification");
    }

    public DigestAuthPrincipal(Request request, String string, String string2, String string3) throws InvalidAuthException {
        super(request);
        HttpCredential httpCredential;
        HttpCredential httpCredential2 = httpCredential = request.isProxy() ? request.getProxyAuthorization() : request.getAuthorization();
        if (httpCredential == null || !httpCredential.getScheme().equalsIgnoreCase("Digest")) {
            this.no_user = true;
        } else {
            this.no_user = false;
            this.dac_user = httpCredential.getAuthParameter("username");
            this.dac_uri = httpCredential.getAuthParameter("uri");
            this.dac_response = httpCredential.getAuthParameter("response");
            this.dac_realm = httpCredential.getAuthParameter("realm");
            this.dac_method = request.getMethod();
            this.dac_nonce = httpCredential.getAuthParameter("nonce");
            this.nonce = string;
            this.old_nonce = string2;
            this.algo = string3;
            if (this.dac_user == null || this.dac_uri == null || this.dac_response == null || this.dac_realm == null) {
                String string4 = "Invalid authentication header";
                throw new InvalidAuthException(string4);
            }
        }
    }

    public boolean equals(Object object) {
        if (this.no_user) {
            return false;
        }
        if (object instanceof AclPrincipal) {
            AclPrincipal aclPrincipal = (AclPrincipal)object;
            String string = aclPrincipal.getName();
            String string2 = aclPrincipal.getRealm();
            String string3 = aclPrincipal.getPassword();
            if (!this.dac_user.equals(string)) {
                return false;
            }
            if (!this.dac_realm.equals(string2)) {
                return false;
            }
            if (this.dac_algorithm != null && !this.dac_algorithm.equals(this.algo)) {
                return false;
            }
            if (!this.dac_nonce.equals(this.nonce)) {
                if (!this.dac_nonce.equals(this.old_nonce)) {
                    String string4 = String.valueOf(string) + ":" + string2 + ":" + string3;
                    String string5 = String.valueOf(this.dac_method) + ":" + this.dac_uri;
                    MessageDigest messageDigest = null;
                    try {
                        messageDigest = MessageDigest.getInstance(this.algo);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return false;
                    }
                    messageDigest.update(string4.getBytes());
                    String string6 = StringUtils.toHexString(messageDigest.digest());
                    messageDigest.reset();
                    messageDigest.update(string5.getBytes());
                    String string7 = StringUtils.toHexString(messageDigest.digest());
                    messageDigest.reset();
                    String string8 = String.valueOf(string6) + ":" + this.dac_nonce + ":" + string7;
                    messageDigest.update(string8.getBytes());
                    String string9 = StringUtils.toHexString(messageDigest.digest());
                    this.stale = string9.equals(this.dac_response);
                    return false;
                }
                this.stale = true;
            }
            String string10 = String.valueOf(string) + ":" + string2 + ":" + string3;
            String string11 = String.valueOf(this.dac_method) + ":" + this.dac_uri;
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance(this.algo);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            messageDigest.update(string10.getBytes());
            String string12 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            messageDigest.update(string11.getBytes());
            String string13 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            String string14 = this.stale ? String.valueOf(string12) + ":" + this.old_nonce + ":" + string13 : String.valueOf(string12) + ":" + this.nonce + ":" + string13;
            messageDigest.update(string14.getBytes());
            String string15 = StringUtils.toHexString(messageDigest.digest());
            return string15.equals(this.dac_response);
        }
        if (object instanceof DigestAuthPrincipal) {
            return false;
        }
        return false;
    }

    public String getName() {
        return this.dac_user;
    }

    public int hashCode() {
        if (this.dac_nonce != null) {
            return this.dac_nonce.hashCode();
        }
        return -1;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String toString() {
        if (this.dac_user != null) {
            return this.dac_user;
        }
        return "Digest";
    }
}

