/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.accessibility.Accessible;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.ClosableFrame;
import org.w3c.www.mime.MimeType;

public class MimeTypeAttributeEditor
extends AttributeEditor {
    protected MimeTypeAttributeComponent comp = null;
    protected boolean hasChanged = false;
    protected String oldvalue = null;

    public void clearChanged() {
        this.hasChanged = false;
    }

    protected void createComponent(String string) {
        if (this.comp == null) {
            this.comp = new MimeTypeAttributeComponent(this, string);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public Object getValue() {
        try {
            return new MimeType(this.comp.getText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        MimeType mimeType = (MimeType)object;
        if (object == null) {
            this.oldvalue = "*none*";
            this.createComponent(this.oldvalue);
        } else {
            this.createComponent(mimeType.toString());
            this.oldvalue = mimeType.toString();
        }
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setText(this.oldvalue);
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public void setValue(Object object) {
        this.oldvalue = (String)object;
        this.comp.setText(this.oldvalue);
    }

    class MimeTypeAttributePopup
    extends ClosableFrame
    implements ActionListener {
        protected TextField mimetype = null;
        protected MimeTypeAttributeComponent parent = null;

        MimeTypeAttributePopup(MimeTypeAttributeComponent mimeTypeAttributeComponent) {
            Accessible accessible;
            Object object;
            this.parent = mimeTypeAttributeComponent;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.setLayout(gridBagLayout);
            MenuBar menuBar = new MenuBar();
            Menu menu = new Menu("MimeTypes");
            Hashtable hashtable = PropertyManager.getPropertyManager().getMimeTypes();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                accessible = new Menu((String)object);
                ((MenuItem)accessible).addActionListener(this);
                String[] stringArray = (String[])hashtable.get(object);
                int n = 0;
                while (n < stringArray.length) {
                    MenuItem menuItem = new MenuItem(stringArray[n]);
                    this.addMenuListener(menuItem, String.valueOf(object) + "/" + stringArray[n]);
                    ((Menu)accessible).add(menuItem);
                    ++n;
                }
                menu.add((MenuItem)accessible);
            }
            menuBar.add(menu);
            gridBagConstraints.gridwidth = -1;
            object = new Label("Mime Type : ");
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
            gridBagConstraints.gridwidth = 0;
            this.mimetype = new TextField(20);
            gridBagLayout.setConstraints(this.mimetype, gridBagConstraints);
            this.add(this.mimetype);
            accessible = new Button("Ok");
            ((Button)accessible).setActionCommand("update");
            ((Button)accessible).addActionListener(this);
            Button button = new Button("Cancel");
            button.setActionCommand("cancel");
            button.addActionListener(this);
            Panel panel = new Panel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            panel.setLayout(gridBagLayout2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout2.setConstraints((Component)((Object)accessible), gridBagConstraints);
            panel.add((Component)((Object)accessible));
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(button, gridBagConstraints);
            panel.add(button);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.add(panel);
            this.setMenuBar(menuBar);
            ((Component)this).setSize(300, 150);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals("update")) {
                    this.parent.setText(this.mimetype.getText());
                    ((Component)this).setVisible(false);
                } else if (string.equals("cancel")) {
                    this.close();
                } else {
                    this.mimetype.setText(string);
                }
            }
        }

        private void addMenuListener(MenuItem menuItem, String string) {
            menuItem.addActionListener(this);
            menuItem.setActionCommand(string);
        }

        protected void close() {
            ((Component)this).setVisible(false);
            this.mimetype.setText("");
        }
    }

    class MimeTypeAttributeComponent
    extends Panel
    implements ActionListener,
    TextListener {
        protected TextField type = null;
        protected MimeTypeAttributePopup popup = null;
        protected MimeTypeAttributeEditor editor = null;

        MimeTypeAttributeComponent(MimeTypeAttributeEditor mimeTypeAttributeEditor2, String string) {
            this.editor = mimeTypeAttributeEditor2;
            this.type = new TextField(20);
            this.type.setText(string);
            this.type.addTextListener(this);
            Button button = new Button("Change");
            button.setActionCommand("edit");
            button.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.type, "West");
            this.add((Component)button, "Center");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals("edit")) {
                if (this.popup == null) {
                    this.popup = new MimeTypeAttributePopup(this);
                }
                this.popup.show();
            }
        }

        public String getText() {
            return this.type.getText();
        }

        public void setText(String string) {
            this.type.setText(string);
            this.editor.setModified();
        }

        public void textValueChanged(TextEvent textEvent) {
            MimeTypeAttributeEditor.this.setModified();
        }
    }
}

