// XMLWriter.java
// $Id: XMLWriter.java,v 1.4 1999/09/20 13:41:33 bmahe Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html
package org.w3c.tools.resources.serialization.xml;

import java.io.Writer;
import java.io.Reader;
import java.io.IOException;

import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.FrameArrayAttribute;

/**
 * @version $Revision: 1.4 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class XMLWriter implements JigXML {
    
    protected Writer writer = null;
    protected int    level  = 0;

    protected void indent()
	throws IOException
    {
	for (int i = 0 ; i < level ; i++)
	    writer.write(" ");
    }

    protected void startDocument() 
	throws IOException
    {
	writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
	//writer.write("<!DOCTYPE jxml SYSTEM \""+dtd+"\">\n");
	writer.write("<"+JXML_TAG+" version=\""+version+"\" xmlns=\""+
		     ns+"\">\n");
    }

    protected void closeDocument() 
	throws IOException
    {
	writer.write("</"+JXML_TAG+">\n");
	writer.close();
    }

    protected void closeResource()
	throws IOException
    {
	writer.write("</"+RESOURCE_TAG+">\n");
    }

    public XMLWriter(Writer writer) {
	this.writer = writer;
    }

    /**
     * & => &amp; < => &lt;
     */
    public static String encode(String string) {
	int          len    = string.length();
	StringBuffer buffer = new StringBuffer(len);
	char         c;

	for (int i = 0 ; i < len ; i++) {
	    switch (c = string.charAt(i)) 
		{
		case '&':
		    buffer.append("&amp;");
		    break;
		case '<':
		    buffer.append("&lt;");
		    break;
		case '>':
		    buffer.append("&gt;");
		    break;
		default:
		    buffer.append(c);
		}
	}
	return buffer.toString();
    }

}
