// JdbcServerState.java
// $Id: JdbcServerState.java,v 1.1 2000/06/08 13:52:31 bmahe Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.jdbc;

import java.util.*;
import java.sql.*;

import org.w3c.util.*;

class JdbcServerState {
    JdbcServer server = null;
    Vector     conns  = null;

    final JdbcServer getServer() {
	return server;
    }

    void registerConnection(JdbcConnection conn) {
	if ( conns == null )
	    conns = new Vector(4);
	conns.addElement(conn);
    }

    void deleteConnection(JdbcConnection conn) {
	if ( conns != null ) 
	    conns.removeElement(conn);
    }

    void unregisterConnection(JdbcConnection conn) {
	if ( conns != null )
	    conns.removeElement(conn);
    }

    synchronized JdbcConnection getConnection() {
	if ((conns != null) && (conns.size() > 0)) {
	    JdbcConnection conn = (JdbcConnection) conns.elementAt(0);
	    conns.removeElementAt(0);
	    return conn;
	}
	return null;
    }
    

    JdbcServerState(JdbcServer server) {
	this.server = server;

    }
}
