// JdbcBean.java
// $Id: JdbcBean.java,v 1.7 2000/07/07 15:36:13 bmahe Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 2000.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.jdbc; 

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

/**
 * @version $Revision: 1.7 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class JdbcBean {

    protected Properties props     = null;

    protected ResultSet  sqlresult = null;

    // bean properties

    protected boolean debug      = false;
    protected String  driver     = null;
    protected String  username   = null;
    protected String  password   = null;
    protected String  url        = null;
    protected String  sqlrequest = null;
    protected String  result     = null;
    
    /**
     * Set the debug flag
     * @param debug a boolean
     */
    public void setDebug(boolean debug) {
	this.debug = debug;
    }

    /**
     * Get the debug flag
     * @return a boolean
     */
    public boolean getDebug() {
	return debug;
    }

    /**
     * Set the JDBC driver 
     * @param driver the jdbc driver
     */
    public void setDriver(String driver) {
	this.driver = driver;
    }

    /**
     * Get the JDBC driver
     * @return a String instance
     */
    public String getDriver() {
	return driver;
    }

    /**
     * Set the username property
     * @param username
     */
    public void setUsername(String username) {
	this.username = username;
    }

    /**
     * Get the username property
     * @return a String instance
     */
    public String getUsername() {
	return username;
    }

    /**
     * Set the password property
     * @param password
     */
    public void setPassword(String password) {
	this.password = password;
    }

    /**
     * Get the password property
     * @return a String
     */
    public String getPassword() {
	return password;
    }

    /**
     * Set the JDBC URI property
     * @param url
     */
    public void setUrl(String url) {
	this.url = url;
    }

    /**
     * Get the JDBC URI property
     * @return a String
     */
    public String getUrl() {
	return url;
    }

    /**
     * Set the SQL request property
     * @param sqlrequest
     */
    public void setSqlrequest(String sqlrequest) {
	this.sqlrequest = sqlrequest;
    }

    /**
     * Get the SQL request property
     * @return a String
     */
    public String getSqlrequest() {
	return sqlrequest;
    }

    /**
     * Set the max number of open connections to the DB
     * @param maxconn
     */
    public synchronized void setMaxconn(int maxconn) {
	Jdbc.setMaxConn(props, maxconn);
    }

    /**
     * Get the max number of open connections to the DB
     * @return an int
     */
    public int getMaxconn() {
	return Jdbc.getMaxConn(props);
    }

    /**
     * Send the SQL Request to the DB.
     * @param nocache we don't use the cache if true
     */
    public synchronized void executeSQL() {
	JdbcServer server = 
	    JdbcServer.getServer(url, username, password, driver, props);
	try {
	    sqlresult = server.runQuery(sqlrequest, false);
	    sqlresult.first();
	} catch (SQLException ex) {
	    this.sqlresult = null;
	}
    }

    /**
     * Send the given SQL Request to the DB.
     * @param sqlresult the SQL Request
     * @param nocache we don't use the cache if true
     */
    public synchronized void executeSQL(String sqlrequest) {
	setSqlrequest(sqlrequest);
	executeSQL();
    }

    /**
     * Warning: can be null!
     * @return a ResultSet instance or null.
     */
    public ResultSet getResult() {
	return sqlresult;
    }

    /**
     * Constructor
     */
    public JdbcBean() {
	props = new Properties();
    }

}
