// HTTPPrincipal.java
// $Id: HTTPPrincipal.java,v 1.6 2000/06/23 13:15:00 ylafon Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html
 
package org.w3c.jigsaw.acl;

import java.net.InetAddress;
import java.security.Principal;

import org.w3c.jigsaw.http.Request;

/**
 * @version $Revision: 1.6 $
 * @author  Benot Mah (bmahe@w3.org)
 */

/**
 * This class implements the most basic HTTP principal, allowing
 * you to check the IP of the request only
 */

public class HTTPPrincipal implements Principal {

    protected Request     request = null;

    protected Request getRequest() {
	return request;
    }

    protected InetAddress getInetAddress() {
	return request.getClient().getInetAddress();
    }

    public boolean equals(Object another) {
	return false;
    }

    public String getName() {
	return null;
    }

    public String getRealm() {
	return null;
    }

    public String toString() {
	return request.getClient().getInetAddress().toString();
    }

    public HTTPPrincipal(Request request) {
	this.request = request;
    }

}
