/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cookies;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.protocol.http.cookies.DomainTree;

class DomainNode {
    Hashtable nodes = new Hashtable(2);
    HttpSetCookie[] cookies = new HttpSetCookie[1];
    int nbcookies = 0;

    DomainNode() {
    }

    protected void addCookie(HttpSetCookie httpSetCookie) {
        int n = 0;
        while (n < this.nbcookies) {
            if (this.sameCookies(httpSetCookie, this.cookies[n])) {
                this.cookies[n] = httpSetCookie;
                return;
            }
            ++n;
        }
        if (this.nbcookies < this.cookies.length) {
            this.cookies[this.nbcookies++] = httpSetCookie;
        } else {
            HttpSetCookie[] httpSetCookieArray = new HttpSetCookie[this.cookies.length + 1];
            System.arraycopy(this.cookies, 0, httpSetCookieArray, 0, this.cookies.length);
            httpSetCookieArray[this.nbcookies++] = httpSetCookie;
            this.cookies = httpSetCookieArray;
        }
    }

    protected boolean sameCookies(HttpSetCookie httpSetCookie, HttpSetCookie httpSetCookie2) {
        if (httpSetCookie2.getPath() == null && httpSetCookie.getPath() == null) {
            return httpSetCookie.getName().equals(httpSetCookie2.getName());
        }
        if (httpSetCookie2.getPath() == null || httpSetCookie.getPath() == null) {
            return false;
        }
        return httpSetCookie.getName().equals(httpSetCookie2.getName()) && httpSetCookie.getPath().equals(httpSetCookie2.getPath());
    }

    protected void sync(FileWriter fileWriter) throws IOException {
        if (this.nbcookies > 0) {
            int n = 0;
            while (n < this.nbcookies) {
                if (this.cookies[n].getMaxAge() > 0) {
                    fileWriter.write(DomainTree.cookie2String(this.cookies[n]));
                }
                ++n;
            }
        }
        Enumeration enumeration = this.nodes.elements();
        DomainNode domainNode = null;
        while (enumeration.hasMoreElements()) {
            domainNode = (DomainNode)enumeration.nextElement();
            domainNode.sync(fileWriter);
        }
    }
}

