/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpWarning;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.ActiveStream;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheStore;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.CachedResourceFactory;
import org.w3c.www.protocol.http.cache.EntityCachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;

public class CacheFilter
implements PropRequestFilter,
PropertyMonitoring {
    public static final String SERIALIZER_P = "org.w3c.www.protocol.http.cache.serializerclass";
    public static final String SWEEPER_P = "org.w3c.www.protocol.http.cache.sweeperclass";
    public static final String VALIDATOR_P = "org.w3c.www.protocol.http.cache.validatorclass";
    public static final String CACHE_CONNECTED_P = "org.w3c.www.protocol.http.cache.connected";
    public static final String SHARED_P = "org.w3c.www.protocol.http.cache.shared";
    public static final String CACHE_SIZE_P = "org.w3c.www.protocol.http.cache.size";
    public static final String DEBUG_P = "org.w3c.www.protocol.http.cache.debug";
    public static final String STATE_NOCACHE = "org.w3c.www.protocol.http.cache.dont";
    public static final String STATE_WARNINGS = "org.w3c.www.protocol.http.cache.CacheFilter.warns";
    public static final String STATE_ORIGREQ = "org.w3c.www.protocol.http.cache.CacheFilter.origreq";
    public static final String STATE_REVALIDATION = "org.w3c.www.protocol.http.cache.revalidation";
    protected static HttpWarning WARN_DISCONNECTED = null;
    protected static HttpWarning WARN_STALE = null;
    protected static HttpWarning WARN_HEURISTIC = null;
    protected ObservableProperties props = null;
    protected CacheValidator validator;
    protected CacheStore store;
    protected CacheSweeper sweeper;
    protected CacheSerializer serializer;
    protected boolean connected = true;
    protected boolean shared = false;
    protected long size = 0x1400000L;
    protected File directory = null;
    protected boolean debug = false;
    protected Hashtable precache = new Hashtable(10);
    protected Hashtable uritable = new Hashtable(10);

    static {
        HttpWarning httpWarning = null;
        httpWarning = HttpFactory.makeWarning(112);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("The required cached resource is stale.");
        WARN_DISCONNECTED = httpWarning;
        httpWarning = HttpFactory.makeWarning(110);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("The returned entry is stale.");
        WARN_STALE = httpWarning;
        httpWarning = HttpFactory.makeWarning(113);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("Heuristic expiration time used on this entry.");
        WARN_HEURISTIC = httpWarning;
    }

    protected void addWarning(Request request, HttpWarning httpWarning) {
        Vector<HttpWarning> vector = (Vector<HttpWarning>)request.getState(STATE_WARNINGS);
        if (vector == null) {
            vector = new Vector<HttpWarning>(4);
            request.setState(STATE_WARNINGS, vector);
        }
        vector.addElement(httpWarning);
    }

    public boolean canCache(Request request, Reply reply) {
        String string = request.getMethod();
        if (!string.equals("GET")) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (request.getMajorVersion() == 0) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (reply.getSetCookie() != null) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        int n = reply.getStatus();
        if (n != 200 && n != 203 && n != 206 && n != 300 && n != 301 && n != 410) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        HttpCacheControl httpCacheControl = null;
        try {
            httpCacheControl = reply.getCacheControl();
        }
        catch (HttpInvalidValueException httpInvalidValueException) {
            httpCacheControl = HttpFactory.parseCacheControl("no-cache");
            reply.setCacheControl(httpCacheControl);
        }
        if (httpCacheControl != null) {
            if (httpCacheControl.checkPublic()) {
                reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
                return true;
            }
            if (this.isShared() && httpCacheControl.getPrivate() != null) {
                reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
                return false;
            }
        }
        if (reply.getNoCache() != null) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (reply.hasPragma("no-cache")) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (request.getURL().getFile().indexOf(63) != -1 && reply.getMajorVersion() == 1 && reply.getMinorVersion() == 0 && reply.getExpires() == -1L) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
        return true;
    }

    public boolean canStore(Request request, Reply reply) {
        if (request.checkNoStore() || reply.checkNoStore()) {
            reply.setState("org.w3c.www.protocol.http.cache.storable", Boolean.FALSE);
            return false;
        }
        reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
        return true;
    }

    public boolean canUseCache(Request request) {
        if (request.hasPragma("no-cache") || request.getNoCache() != null) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            return false;
        }
        String string = request.getMethod();
        if (!string.equals("GET")) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            return false;
        }
        return true;
    }

    protected synchronized void cleanUpload(CachedResource cachedResource) {
        block2: {
            this.precache.remove(cachedResource.getIdentifier());
            try {
                this.store.storeCachedResource(cachedResource);
            }
            catch (InvalidCacheException invalidCacheException) {
                if (!this.debug) break block2;
                invalidCacheException.printStackTrace();
            }
        }
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        Hashtable hashtable = this.uritable;
        synchronized (hashtable) {
            this.uritable.remove(request.getURL().toExternalForm());
            this.uritable.notifyAll();
        }
        return false;
    }

    public CacheSerializer getSerializer() {
        return this.serializer;
    }

    public CacheStore getStore() {
        return this.store;
    }

    public CacheSweeper getSweeper() {
        return this.sweeper;
    }

    public CacheValidator getValidator() {
        return this.validator;
    }

    /*
     * Unable to fully structure code
     */
    public Reply ingoingFilter(Request var1_1) throws HttpException {
        if (!this.canUseCache(var1_1)) {
            if (this.debug) {
                this.trace(var1_1, "*** Can't use cache");
            }
            if (this.connected) {
                var2_2 = null;
                var3_5 = null;
                try {
                    var4_8 = var1_1.getURL().toExternalForm();
                    var2_2 = this.store.getCachedResourceReference(var4_8);
                    if (var2_2 != null) {
                        var3_5 = (EntityCachedResource)var2_2.lookupResource(var1_1);
                    }
                }
                catch (InvalidCacheException v0) {
                    var3_5 = null;
                }
                if (var3_5 != null) {
                    var3_5.setWillRevalidate(true);
                }
                var1_1.setState("org.w3c.www.protocol.http.cache.dont", Boolean.TRUE);
                return null;
            }
            var2_3 = var1_1.makeReply(504);
            var2_3.setContent("The cache cannot be use for <p><code>" + var1_1.getMethod() + "</code> " + "<strong>" + var1_1.getURL() + "</strong>" + ". <p>It is disconnected.");
            return var2_3;
        }
        var2_4 = var1_1.getURL().toExternalForm();
        if (this.precache.containsKey(var2_4)) {
            if (this.debug) {
                System.out.println("*** Already downloading: " + var2_4);
            }
            try {
                var3_6 = (CachedResource)this.precache.get(var2_4);
                return var3_6.perform(var1_1);
            }
            catch (Exception v1) {}
        }
        var3_7 = null;
        try {
            var3_7 = this.store.getCachedResourceReference(var2_4);
        }
        catch (InvalidCacheException v2) {
            var3_7 = null;
        }
        if (var1_1.checkOnlyIfCached() || !this.connected) {
            var4_9 = null;
            if (var3_7 != null) {
                var4_9 = (EntityCachedResource)var3_7.lookupResource(var1_1);
            }
            if (var3_7 == null || var4_9 == null) {
                if (this.debug) {
                    this.trace(var1_1, "unavailable (disconnected).");
                }
                var5_12 = var1_1.makeReply(504);
                var5_12.setContent("The cache doesn't have an entry for <p><strong>" + var1_1.getURL() + "</strong>" + ". <p>And it is disconnected.");
                return var5_12;
            }
            if (this.debug) {
                this.trace(var1_1, this.connected != false ? " hit - only if cached" : " hit while disconneced");
            }
            if (!this.validator.isValid(var4_9, var1_1)) {
                this.addWarning(var1_1, CacheFilter.WARN_STALE);
            }
            this.addWarning(var1_1, CacheFilter.WARN_DISCONNECTED);
            var5_13 = var4_9.perform(var1_1);
            this.setWarnings(var1_1, var5_13);
            return var5_13;
        }
        if (var3_7 == null) ** GOTO lbl89
        if (var3_7.getLoadState() == 2 || var3_7.getLoadState() == 4) {
            this.setRequestRevalidation(var3_7, var1_1);
            return null;
        }
        if (this.validator.isValid(var3_7, var1_1)) {
            try {
                this.store.updateResourceGeneration(var3_7);
            }
            catch (InvalidCacheException v3) {}
            var4_10 = var3_7.perform(var1_1);
            return var4_10;
        }
        if (this.debug) {
            System.out.println("*** Revalidation asked for " + var2_4);
        }
        this.setRequestRevalidation(var3_7, var1_1);
        return null;
lbl-1000:
        // 1 sources

        {
            var4_11 = this.uritable;
            synchronized (var4_11) {
                try {
                    this.uritable.wait();
                }
                catch (InterruptedException v4) {}
            }
            if (this.precache.containsKey(var2_4)) {
                if (this.debug) {
                    System.out.println("*** Already downloading: " + var2_4);
                }
                var4_11 = (CachedResource)this.precache.get(var2_4);
                return var4_11.perform(var1_1);
            }
            this.uritable.put(var2_4, var2_4);
lbl89:
            // 2 sources

            ** while (this.uritable.containsKey((Object)var2_4))
        }
lbl90:
        // 1 sources

        return null;
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        block4: {
            this.props = httpManager.getProperties();
            this.shared = this.props.getBoolean(SHARED_P, false);
            this.connected = this.props.getBoolean(CACHE_CONNECTED_P, true);
            this.debug = this.props.getBoolean(DEBUG_P, false);
            String string = this.props.getString(VALIDATOR_P, "org.w3c.www.protocol.http.cache.SimpleCacheValidator");
            String string2 = this.props.getString(SWEEPER_P, "org.w3c.www.protocol.http.cache.SimpleCacheSweeper");
            String string3 = this.props.getString(SERIALIZER_P, "org.w3c.www.protocol.http.cache.SimpleCacheSerializer");
            try {
                Class<?> clazz = Class.forName(string);
                this.validator = (CacheValidator)clazz.newInstance();
                this.validator.initialize(this);
                clazz = Class.forName(string2);
                this.sweeper = (CacheSweeper)clazz.newInstance();
                this.sweeper.initialize(this);
                clazz = Class.forName(string3);
                this.serializer = (CacheSerializer)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PropRequestFilterException("Unable to start cache");
            }
            this.store = new CacheStore();
            try {
                this.store.initialize(this);
            }
            catch (InvalidCacheException invalidCacheException) {
                if (!this.debug) break block4;
                invalidCacheException.printStackTrace();
            }
        }
        this.sweeper.start();
        ActiveStream.initialize();
        this.props.registerObserver(this);
        httpManager.setFilter(this);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isShared() {
        return this.shared;
    }

    public Reply outgoingFilter(Request request, Reply reply) throws HttpException {
        URL uRL = request.getURL();
        CachedResource cachedResource = (CachedResource)request.getState("org.w3c.www.protocol.http.cache.resource");
        if (cachedResource != null) {
            if (this.debug) {
                this.trace(request, "revalidated " + reply.getStatus());
            }
            if (reply.getStatus() == 304) {
                block15: {
                    this.validator.revalidateResource(cachedResource, request, reply);
                    try {
                        this.store.storeCachedResource(cachedResource, cachedResource.getCurrentLength());
                    }
                    catch (InvalidCacheException invalidCacheException) {
                        if (!this.debug) break block15;
                        invalidCacheException.printStackTrace();
                    }
                }
                Request request2 = (Request)request.getState(STATE_ORIGREQ);
                return cachedResource.perform(request2);
            }
            cachedResource.delete();
            this.store.getState().notifyResourceDeleted(cachedResource);
        }
        if (!this.canCache(request, reply)) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            if (this.debug) {
                System.out.println("*** Can't cache reply");
            }
            String string = uRL.toExternalForm();
            this.precache.remove(string);
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            return null;
        }
        if (!this.canStore(request, reply)) {
            if (this.debug) {
                System.out.println("*** Can't store reply");
            }
            String string = uRL.toExternalForm();
            this.precache.remove(string);
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            return null;
        }
        this.pushDocument(request, reply);
        return null;
    }

    public boolean propertyChanged(String string) {
        if (string.equals(SERIALIZER_P)) {
            CacheSerializer cacheSerializer = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheSerializer = (CacheSerializer)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.serializer = cacheSerializer;
            return true;
        }
        if (string.equals(SWEEPER_P)) {
            CacheSweeper cacheSweeper = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheSweeper = (CacheSweeper)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.sweeper.destroy();
            this.sweeper = cacheSweeper;
            this.sweeper.start();
            return true;
        }
        if (string.equals(VALIDATOR_P)) {
            CacheValidator cacheValidator = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheValidator = (CacheValidator)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.validator = cacheValidator;
            return true;
        }
        if (string.equals(DEBUG_P)) {
            this.debug = this.props.getBoolean(string, this.debug);
            return true;
        }
        if (string.equals(SHARED_P)) {
            this.shared = this.props.getBoolean(string, this.shared);
            return true;
        }
        if (string.equals(CACHE_CONNECTED_P)) {
            this.connected = this.props.getBoolean(string, true);
            return true;
        }
        return this.store.propertyChanged(string);
    }

    public void pushDocument(Request request, Reply reply) {
        URL uRL = request.getURL();
        try {
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                CachedResource cachedResource = null;
                String string = uRL.toExternalForm();
                cachedResource = CachedResourceFactory.createResource(this, request, reply);
                if (cachedResource.uploading) {
                    this.precache.put(string, cachedResource);
                }
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            if (this.debug) {
                this.trace(request, "enters cache.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Request setRequestRevalidation(CachedResource cachedResource, Request request) {
        try {
            return this.store.getCachedResource(cachedResource).setRequestRevalidation(request);
        }
        catch (InvalidCacheException invalidCacheException) {
            return null;
        }
    }

    protected final void setWarnings(Request request, Reply reply) {
        Vector vector = (Vector)request.getState(STATE_WARNINGS);
        if (vector == null) {
            return;
        }
        Object[] objectArray = new HttpWarning[vector.size()];
        vector.copyInto(objectArray);
        reply.setWarning((HttpWarning[])objectArray);
    }

    public void sync() {
        if (this.debug) {
            System.out.println("*** Synching the CacheFilter");
        }
        try {
            this.store.sync();
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": Unable to save cache.");
        }
    }

    protected final void trace(Request request, String string) {
        System.out.println(String.valueOf(String.valueOf(request.getURL())) + ": " + string);
    }
}

