/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpCredential
extends BasicValue {
    ArrayDictionary params = null;
    String scheme = null;

    public HttpCredential() {
        this.isValid = false;
    }

    public HttpCredential(boolean bl, String string) {
        this.isValid = bl;
        this.scheme = string;
    }

    public String getAuthParameter(String string) {
        this.validate();
        return this.params == null ? null : (String)this.params.get(string);
    }

    public String getScheme() {
        this.validate();
        return this.scheme;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid credentials: no scheme.");
        }
        this.scheme = parseState.toString(this.raw);
        this.params = new ArrayDictionary(4, 4);
        parseState.prepare();
        if (this.scheme.equalsIgnoreCase("basic")) {
            if (HttpParser.nextItem(this.raw, parseState) < 0) {
                this.error("Invalid basic auth credentials, no basic-cookie.");
            }
            this.params.put("cookie", parseState.toString(this.raw));
        } else {
            ParseState parseState2 = new ParseState();
            parseState2.separator = (byte)61;
            parseState.separator = (byte)44;
            while (HttpParser.nextItem(this.raw, parseState) >= 0) {
                parseState2.prepare(parseState);
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid credentials: bad param name.");
                }
                String string = parseState2.toString(this.raw, true);
                parseState2.prepare();
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid credentials: no param value.");
                }
                parseState2.ioff = parseState2.start;
                HttpParser.unquote(this.raw, parseState2);
                this.params.put(string, parseState2.toString(this.raw));
                parseState.prepare();
            }
        }
    }

    public void setAuthParameter(String string, String string2) {
        this.invalidateByteValue();
        if (this.params == null) {
            this.params = new ArrayDictionary(4, 4);
        }
        this.params.put(string, string2);
    }

    public void setScheme(String string) {
        if (this.scheme != null && !this.scheme.equalsIgnoreCase(string)) {
            this.invalidateByteValue();
        }
        this.scheme = string;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.scheme);
        httpBuffer.append(' ');
        int n = this.params.size();
        int n2 = 0;
        while (n > 0) {
            String string = (String)this.params.keyAt(n2);
            if (string != null) {
                if (string.equals("cookie")) {
                    httpBuffer.append((String)this.params.elementAt(n2));
                } else {
                    httpBuffer.appendQuoted(string, (byte)61, (String)this.params.elementAt(n2));
                }
                if (--n > 0) {
                    httpBuffer.append((byte)44);
                }
            }
            ++n2;
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

