/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.w3c.tools.widgets.ImageButton;

public class FakeComboBox
extends Panel
implements ActionListener,
ItemListener {
    protected TextField text = null;
    protected ImageButton button = null;
    protected int listSize = 0;
    protected GoodList list = null;
    protected Panel plist = null;
    transient ActionListener actionListener;
    private String command = "";

    public FakeComboBox(int n, int n2, boolean bl, String string, String string2) {
        this.list = new GoodList(this, n2);
        this.list.addItemListener(this);
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        Image image2 = Toolkit.getDefaultToolkit().getImage(string2);
        this.setLayout(new BorderLayout());
        this.text = new TextField(n);
        this.text.setEditable(bl);
        this.text.addActionListener(this);
        this.button = new ImageButton(image, image2);
        this.button.addActionListener(this);
        this.button.setActionCommand("popup");
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.plist = new Panel();
        this.plist.add(this.list);
        this.add((Component)this.plist, "South");
        this.plist.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("popup")) {
            if (this.plist.isShowing()) {
                this.hidePopup();
            } else {
                this.showPopup();
            }
        } else if (actionEvent.getSource() == this.text) {
            this.fireActionEvent();
        }
    }

    public void add(String string) {
        this.list.add(string);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    protected void fireActionEvent() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.command);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public String getActionCommand() {
        return this.command;
    }

    public String getText() {
        return this.text.getText();
    }

    protected void hidePopup() {
        if (this.plist.isShowing()) {
            this.plist.setVisible(false);
            this.button.switchImage();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Integer n = (Integer)itemEvent.getItem();
            String string = this.list.getItem(n);
            if (string != null) {
                this.setText(string);
                this.fireActionEvent();
            }
            this.hidePopup();
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    protected void showPopup() {
        if (!this.plist.isShowing()) {
            this.plist.setVisible(true);
            this.button.switchImage();
            this.updateParent();
        }
    }

    void updateParent() {
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    class GoodList
    extends List {
        FakeComboBox parent = null;

        GoodList(FakeComboBox fakeComboBox2, int n) {
            super(n);
            this.parent = fakeComboBox2;
        }

        public void add(String string) {
            super.addItem(string);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.max(this.parent.text.getSize().width, super.getMinimumSize().width), super.getMinimumSize().height);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        int max(int n, int n2) {
            return n < n2 ? n2 : n;
        }
    }
}

