/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcBeanInterface;
import org.w3c.tools.jdbc.JdbcBeanUtil;
import org.w3c.tools.jdbc.JdbcServer;
import org.w3c.tools.jdbc.PropertyCache;
import org.w3c.tools.jdbc.SQL;

public class JdbcBeanSerializer
implements PropertyChangeListener {
    protected boolean modified = false;
    protected JdbcBeanInterface bean = null;
    protected JdbcBeanInterface[] beans = null;
    protected static final int NOTHING = -1;
    protected static final int INTERSECT = 10;
    protected static final int UNION = 20;
    protected static final int EXCEPT = 30;
    protected int[] priority = new int[]{-1, -1, -1};
    protected JdbcBeanSerializer intersect_serializer = null;
    protected JdbcBeanSerializer union_serializer = null;
    protected JdbcBeanSerializer except_serializer = null;
    protected ResultSet result = null;
    protected Vector beantables = null;
    protected static Hashtable foreignKeys = new Hashtable();

    public JdbcBeanSerializer(JdbcBeanInterface jdbcBeanInterface) {
        this.bean = jdbcBeanInterface;
        jdbcBeanInterface.addPropertyChangeListener(this);
    }

    protected String _computeSQLSelect(boolean bl, String string, String[] stringArray) {
        try {
            Object object;
            Object object2;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            Object object3 = new StringBuffer();
            String string2 = this.bean.getJdbcTable();
            this.beantables = new Vector();
            this.beantables.addElement(this.bean);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (bl) {
                this.appendForeignKeys(this.beantables, (StringBuffer)object3, propertyDescriptorArray, stringArray);
            }
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                object2 = propertyDescriptorArray[n];
                if (!((FeatureDescriptor)object2).isHidden()) {
                    String string3 = ((FeatureDescriptor)object2).getName();
                    if ((stringArray == null || JdbcBeanUtil.isIn(string3, stringArray)) && (object = this.getSQLOperatorNValue(this.bean, (PropertyDescriptor)object2)) != null) {
                        this.append(String.valueOf(string2) + "." + string3, (String)object[0], (String)object[1], "AND", (StringBuffer)object3);
                    }
                }
                ++n;
            }
            if (((StringBuffer)object3).length() > 0) {
                object2 = new StringBuffer();
                int n2 = 0;
                while (n2 < this.beantables.size()) {
                    object = (JdbcBeanInterface)this.beantables.elementAt(n2);
                    if (n2 != 0) {
                        ((StringBuffer)object2).append(", ");
                    }
                    ((StringBuffer)object2).append(object.getJdbcTable());
                    ++n2;
                }
                ((StringBuffer)object2).append(" WHERE ");
                ((StringBuffer)object2).insert(0, "SELECT " + string + " FROM ");
                ((StringBuffer)object2).append(((StringBuffer)object3).toString());
                object3 = object2;
            } else {
                object3 = new StringBuffer("SELECT " + string + " FROM ");
                ((StringBuffer)object3).append(string2);
            }
            int n3 = 0;
            while (n3 < this.priority.length) {
                int n4 = this.priority[n3];
                if (n4 == -1) break;
                switch (n4) {
                    case 10: {
                        object = this.intersect_serializer._computeSQLSelect(bl, string, stringArray);
                        ((StringBuffer)object3).append(" INTERSECT (").append((String)object);
                        ((StringBuffer)object3).append(")");
                        break;
                    }
                    case 20: {
                        String string4 = this.union_serializer._computeSQLSelect(bl, string, stringArray);
                        ((StringBuffer)object3).append(" UNION (").append(string4);
                        ((StringBuffer)object3).append(")");
                        break;
                    }
                    case 30: {
                        String string5 = this.except_serializer._computeSQLSelect(bl, string, stringArray);
                        ((StringBuffer)object3).append(" EXCEPT (").append(string5);
                        ((StringBuffer)object3).append(")");
                        break;
                    }
                }
                ++n3;
            }
            return ((StringBuffer)object3).toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    private void append(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4).append(" ");
        }
        stringBuffer.append(string).append(string2).append(string3).append(" ");
    }

    protected void appendForeignKeys(Vector vector, StringBuffer stringBuffer, PropertyDescriptor[] propertyDescriptorArray, String[] stringArray) throws IntrospectionException {
        JdbcBeanInterface[] jdbcBeanInterfaceArray = this.getJdbcBeans();
        if (jdbcBeanInterfaceArray != null) {
            int n = 0;
            while (n < jdbcBeanInterfaceArray.length) {
                Object object;
                JdbcBeanInterface jdbcBeanInterface = jdbcBeanInterfaceArray[n];
                String[] stringArray2 = JdbcBeanSerializer.getForeignKeys(jdbcBeanInterface.getClass(), this.bean.getClass());
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    object = stringArray2[n2];
                    if (stringArray == null || JdbcBeanUtil.isIn((String)object, stringArray)) {
                        this.append(String.valueOf(jdbcBeanInterface.getJdbcTable()) + "." + (String)object, " = ", String.valueOf(this.bean.getJdbcTable()) + "." + (String)object, "AND", stringBuffer);
                    }
                    ++n2;
                }
                object = null;
                PropertyDescriptor[] propertyDescriptorArray2 = null;
                object = Introspector.getBeanInfo(jdbcBeanInterface.getClass());
                propertyDescriptorArray2 = object.getPropertyDescriptors();
                int n3 = 0;
                while (n3 < propertyDescriptorArray2.length) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[n3];
                    if (!propertyDescriptor.isHidden()) {
                        String[] stringArray3;
                        String string = propertyDescriptor.getName();
                        if ((stringArray == null || JdbcBeanUtil.isIn(string, stringArray)) && (stringArray3 = this.getSQLOperatorNValue(jdbcBeanInterface, propertyDescriptor)) != null) {
                            this.append(String.valueOf(jdbcBeanInterface.getJdbcTable()) + "." + string, stringArray3[0], stringArray3[1], "AND", stringBuffer);
                        }
                    }
                    ++n3;
                }
                vector.addElement(jdbcBeanInterface);
                jdbcBeanInterface.getSerializer().appendForeignKeys(vector, stringBuffer, stringArray);
                ++n;
            }
        }
    }

    protected void appendForeignKeys(Vector vector, StringBuffer stringBuffer, String[] stringArray) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        this.appendForeignKeys(vector, stringBuffer, propertyDescriptorArray, stringArray);
    }

    private void appendInsert(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", ").append(string);
            stringBuffer2.append(", ").append(string2);
        } else {
            stringBuffer.append("(").append(string);
            stringBuffer2.append("(").append(string2);
        }
    }

    public void clean() {
        this.result = null;
        PropertyCache.removeProperties(this.bean);
        this.markModified(false);
    }

    protected static String[] computeForeignKeys(Class clazz, Class clazz2) {
        try {
            Object[] objectArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            BeanInfo beanInfo2 = Introspector.getBeanInfo(clazz2);
            PropertyDescriptor[] propertyDescriptorArray2 = beanInfo2.getPropertyDescriptors();
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                objectArray = propertyDescriptorArray[n];
                int n2 = 0;
                while (n2 < propertyDescriptorArray2.length) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[n2];
                    if (!propertyDescriptor.isHidden() && !objectArray.isHidden() && JdbcBeanSerializer.equalsForeignKeys(objectArray.getName(), propertyDescriptor.getName())) {
                        vector.addElement(objectArray.getName());
                    }
                    ++n2;
                }
                ++n;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (IntrospectionException introspectionException) {
            return new String[0];
        }
    }

    protected String computeSQLCount(boolean bl, boolean bl2, String[] stringArray) {
        String string = bl2 ? "DISTINCT count(*)" : "count(*)";
        return this._computeSQLSelect(bl, string, stringArray);
    }

    protected String computeSQLDelete() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer(this.bean.getJdbcTable());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String[] stringArray;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.isHidden() && (stringArray = this.getSQLOperatorNValue(this.bean, propertyDescriptor)) != null) {
                    this.append(propertyDescriptor.getName(), stringArray[0], stringArray[1], "AND", stringBuffer);
                }
                ++n;
            }
            if (stringBuffer.length() <= 0) {
                return null;
            }
            stringBuffer2.append(" WHERE ");
            stringBuffer2.insert(0, "DELETE FROM ");
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer = stringBuffer2;
            return stringBuffer.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String computeSQLInsert() {
        try {
            Object object;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string;
                object = propertyDescriptorArray[n];
                if (!((FeatureDescriptor)object).isHidden() && (string = this.getSQLValue(this.bean, (PropertyDescriptor)object)) != null) {
                    this.appendInsert(((FeatureDescriptor)object).getName(), string, stringBuffer, stringBuffer2);
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                object = new StringBuffer("INSERT INTO ");
                ((StringBuffer)object).append(this.bean.getJdbcTable()).append(" ");
                ((StringBuffer)object).append((Object)stringBuffer).append(") ");
                ((StringBuffer)object).append("VALUES ").append((Object)stringBuffer2).append(")");
                return ((StringBuffer)object).toString();
            }
            return null;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl) {
        return this.computeSQLSelect(stringArray, blArray, bl, "*", null);
    }

    protected String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl, String string) {
        return this.computeSQLSelect(stringArray, blArray, bl, string, null);
    }

    protected String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl, String string, String[] stringArray2) {
        String string2 = this._computeSQLSelect(bl, string, stringArray2);
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (stringArray != null) {
            stringBuffer.append(" ORDER BY ");
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[n]);
                if (!blArray[n]) {
                    stringBuffer.append(" DESC");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected String computeSQLUpdate(String[] stringArray) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer(this.bean.getJdbcTable());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.isHidden()) {
                    String string = propertyDescriptor.getName();
                    String[] stringArray2 = this.getSQLOperatorNValue(this.bean, propertyDescriptor);
                    if (stringArray2 != null) {
                        if (JdbcBeanUtil.isIn(string, stringArray)) {
                            this.append(string, stringArray2[0], stringArray2[1], "AND", stringBuffer2);
                        } else {
                            this.append(string, stringArray2[0], stringArray2[1], ",", stringBuffer);
                        }
                    }
                }
                ++n;
            }
            if (stringBuffer.length() <= 0) {
                return null;
            }
            stringBuffer3.append(" SET ");
            stringBuffer3.insert(0, "UPDATE ");
            stringBuffer3.append(stringBuffer.toString());
            stringBuffer3.append(" WHERE ");
            stringBuffer3.append(stringBuffer2.toString());
            stringBuffer = stringBuffer3;
            return stringBuffer.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    public int count() {
        return this.count(true, false, null);
    }

    public int count(boolean bl) {
        return this.count(bl, false, null);
    }

    public int count(boolean bl, boolean bl2) {
        return this.count(bl, bl2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int count(boolean bl, boolean bl2, String[] stringArray) {
        int n;
        String string = this.computeSQLCount(bl, bl2, stringArray);
        try {
            try {
                this.executeSQLQuery(string);
                if (this.result.first()) {
                    int n2 = this.result.getInt(1);
                    Object var7_8 = null;
                    this.result = null;
                    this.beantables = null;
                    return n2;
                }
                n = 0;
            }
            catch (SQLException sQLException) {
                System.out.println("SQL STATE: " + sQLException.getSQLState());
                sQLException.printStackTrace();
                int n3 = 0;
                Object var7_10 = null;
                this.result = null;
                this.beantables = null;
                return n3;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.result = null;
            this.beantables = null;
            throw throwable;
        }
        Object var7_9 = null;
        this.result = null;
        this.beantables = null;
        return n;
    }

    public int count(String[] stringArray) {
        return this.count(true, false, stringArray);
    }

    public boolean delete() {
        if (this.bean.getReadOnly()) {
            return false;
        }
        String string = this.computeSQLDelete();
        try {
            int n = this.executeSQLUpdate(string);
            return n > 0;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
            return false;
        }
    }

    protected static boolean equalsForeignKeys(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf("_");
        if (n2 != -1) {
            string = string.substring(n2);
        }
        if ((n = string2.lastIndexOf("_")) != -1) {
            string2 = string2.substring(n);
        }
        return string.equals(string2);
    }

    public JdbcBeanSerializer except(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(30);
        this.except_serializer = jdbcBeanInterface.getSerializer();
        return this.except_serializer;
    }

    protected void executeSQLQuery(String string) throws SQLException {
        this.result = this.getJdbcServer().runQuery(string, false);
    }

    protected int executeSQLUpdate(String string) throws SQLException {
        return this.getJdbcServer().runUpdate(string, false);
    }

    public boolean exists() {
        return this.count() == 1;
    }

    protected void finalize() throws Throwable {
        PropertyCache.removeProperties(this.bean);
    }

    protected int findColumn(Vector vector, ResultSet resultSet, String string) throws SQLException {
        String string2 = this.bean.getJdbcTable();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        boolean bl = false;
        if (resultSetMetaData.getTableName(0).length() > 0) {
            int n = 0;
            while (n < resultSetMetaData.getColumnCount()) {
                String string3 = resultSetMetaData.getTableName(n);
                if (resultSetMetaData.getTableName(n).equals(string2) && resultSetMetaData.getColumnName(n).equals(string)) {
                    return n;
                }
                ++n;
            }
        } else {
            Vector<Integer> vector2 = new Vector<Integer>();
            try {
                int n = 1;
                while (n <= resultSetMetaData.getColumnCount()) {
                    if (resultSetMetaData.getColumnName(n).equals(string)) {
                        vector2.addElement(new Integer(n));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (vector2.size() == 0) {
                return -1;
            }
            if (vector2.size() == 1) {
                return (Integer)vector2.elementAt(0);
            }
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)vector.elementAt(n2);
                if (jdbcBeanInterface == this.bean) {
                    return (Integer)vector2.elementAt(n);
                }
                if (jdbcBeanInterface.getSerializer().getPropertyDescriptor(string) != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return -1;
    }

    public boolean first() {
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.first()) {
                return this.updateProperties();
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    public static String[] getForeignKeys(Class clazz, Class clazz2) {
        Integer n = new Integer(clazz.hashCode() & clazz2.hashCode());
        String[] stringArray = (String[])foreignKeys.get(n);
        if (stringArray == null) {
            stringArray = JdbcBeanSerializer.computeForeignKeys(clazz, clazz2);
            foreignKeys.put(n, stringArray);
        }
        return stringArray;
    }

    protected JdbcBeanInterface[] getJdbcBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            Vector<Object> vector = new Vector<Object>();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                Object object;
                Method method;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.isHidden() && JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType()) && (method = propertyDescriptor.getReadMethod()) != null && (object = method.invoke((Object)this.bean, null)) != null) {
                    vector.addElement(object);
                }
                ++n;
            }
            this.beans = new JdbcBeanInterface[vector.size()];
            vector.copyInto(this.beans);
            return this.beans;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    protected JdbcServer getJdbcServer() {
        Properties properties = new Properties();
        Jdbc.setMaxConn(properties, this.bean.getMaxConn());
        return JdbcServer.getServer(this.bean.getJdbcURI(), this.bean.getJdbcUser(), this.bean.getJdbcPassword(), this.bean.getJdbcDriver(), properties);
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (propertyDescriptor.getName().equals(string)) {
                    return propertyDescriptor;
                }
                ++n;
            }
            return null;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String[] getSQLOperatorNValue(JdbcBeanInterface jdbcBeanInterface, PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            Object object = PropertyCache.getProperty(jdbcBeanInterface, propertyDescriptor);
            if (object == null) {
                return null;
            }
            return SQL.getSQLOperator(object);
        }
        return null;
    }

    protected String getSQLValue(JdbcBeanInterface jdbcBeanInterface, PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            Object object = PropertyCache.getProperty(jdbcBeanInterface, propertyDescriptor);
            if (object == null) {
                return null;
            }
            return SQL.getSQLValue(object);
        }
        return null;
    }

    public void initBean() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.isHidden() && !JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType())) {
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    Object object = null;
                    if (method != null && method2 != null) {
                        try {
                            object = method.invoke((Object)this.bean.getDefault(), null);
                            Object[] objectArray = new Object[]{object};
                            method2.invoke((Object)this.bean, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                    }
                }
                ++n;
            }
            this.clean();
        }
        catch (IntrospectionException introspectionException) {}
    }

    public boolean insert() {
        Object object;
        if (!this.isModified()) {
            return false;
        }
        JdbcBeanInterface[] jdbcBeanInterfaceArray = this.getJdbcBeans();
        int n = 0;
        while (n < jdbcBeanInterfaceArray.length) {
            object = jdbcBeanInterfaceArray[n];
            JdbcBeanSerializer jdbcBeanSerializer = object.getSerializer();
            if (jdbcBeanSerializer.isModified()) {
                jdbcBeanSerializer.insert();
                this.updateForeignKeys((JdbcBeanInterface)object);
            }
            ++n;
        }
        if (!this.bean.getReadOnly()) {
            object = this.computeSQLInsert();
            try {
                this.executeSQLUpdate((String)object);
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
            }
        }
        this.select(false);
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.first()) {
                return this.updateProperties(false);
            }
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public JdbcBeanSerializer intersect(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(10);
        this.intersect_serializer = jdbcBeanInterface.getSerializer();
        return this.intersect_serializer;
    }

    public boolean isLast() {
        try {
            if (this.result == null) {
                return true;
            }
            return this.result.isLast();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    protected boolean isModified() {
        return this.modified;
    }

    protected void markModified(boolean bl) {
        this.modified = bl;
    }

    public boolean next() {
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.next()) {
                return this.updateProperties();
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == this.bean) {
            if (object2 == null) {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                if (JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType())) {
                    this.beans = null;
                    JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)propertyChangeEvent.getOldValue();
                    if (jdbcBeanInterface != null) {
                        PropertyCache.removeProperties(jdbcBeanInterface);
                        jdbcBeanInterface.removePropertyChangeListener(this);
                    }
                }
            } else if (object2 instanceof JdbcBeanInterface) {
                JdbcBeanSerializer.registerForeignKeys(this.bean.getClass(), object2.getClass());
                this.beans = null;
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)propertyChangeEvent.getOldValue();
                JdbcBeanInterface jdbcBeanInterface2 = (JdbcBeanInterface)object2;
                if (jdbcBeanInterface != null) {
                    PropertyCache.removeProperties(jdbcBeanInterface);
                    jdbcBeanInterface.removePropertyChangeListener(this);
                }
                jdbcBeanInterface2.addPropertyChangeListener(this);
            } else {
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)object;
                PropertyCache.addProperty(jdbcBeanInterface, string, propertyChangeEvent.getNewValue());
                this.markModified(true);
            }
        } else {
            this.markModified(true);
        }
    }

    public static void registerForeignKeys(Class clazz, Class clazz2) {
        Integer n = new Integer(clazz.hashCode() & clazz2.hashCode());
        if (!foreignKeys.containsKey(n)) {
            foreignKeys.put(n, JdbcBeanSerializer.computeForeignKeys(clazz, clazz2));
        }
    }

    public void select() {
        boolean[] blArray = new boolean[]{true};
        this.select(null, blArray, true, false);
    }

    public void select(String string) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{true};
        this.select(stringArray, blArray, true, false);
    }

    public void select(String string, boolean bl, boolean bl2) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{bl};
        this.select(stringArray, blArray, bl2, false);
    }

    public void select(String string, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{bl};
        this.select(stringArray, blArray, bl2, bl3);
    }

    public void select(boolean bl) {
        boolean[] blArray = new boolean[]{true};
        this.select(null, blArray, bl, false);
    }

    public void select(String[] stringArray) {
        boolean[] blArray = new boolean[]{true};
        this.select(stringArray, blArray, true, false);
    }

    public void select(String[] stringArray, boolean[] blArray, boolean bl, boolean bl2) {
        String string = bl2 ? "DISTINCT *" : "*";
        String string2 = this.computeSQLSelect(stringArray, blArray, bl, string);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    public void select(String[] stringArray, boolean[] blArray, boolean bl, boolean bl2, String[] stringArray2) {
        CharSequence charSequence;
        String string = null;
        if (stringArray2 != null) {
            charSequence = new StringBuffer();
            int n = 0;
            while (n < stringArray2.length) {
                if (n != 0) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append(stringArray2[n]).append(" ");
                ++n;
            }
            string = ((StringBuffer)charSequence).toString();
        } else {
            string = "*";
        }
        charSequence = bl2 ? "DISTINCT " + string : string;
        String string2 = this.computeSQLSelect(stringArray, blArray, bl, (String)charSequence);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    public void selectDistinct(String string) {
        boolean[] blArray = new boolean[]{true};
        String[] stringArray = new String[]{string};
        String string2 = this.computeSQLSelect(stringArray, blArray, false, "DISTINCT " + string);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    protected void setPriority(int n) {
        int n2 = 0;
        while (n2 < this.priority.length && this.priority[n2] != -1) {
            if (this.priority[n2] == n) {
                return;
            }
            ++n2;
        }
        this.priority[n2] = n;
    }

    public JdbcBeanSerializer union(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(20);
        this.union_serializer = jdbcBeanInterface.getSerializer();
        return this.union_serializer;
    }

    public boolean update(String string) {
        String[] stringArray = new String[]{string};
        return this.update(stringArray);
    }

    public boolean update(String[] stringArray) {
        if (!this.isModified()) {
            return false;
        }
        String string = this.computeSQLUpdate(stringArray);
        try {
            int n = this.executeSQLUpdate(string);
            return n > 0;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    protected void updateForeignKeys(JdbcBeanInterface jdbcBeanInterface) {
        String[] stringArray = JdbcBeanSerializer.getForeignKeys(jdbcBeanInterface.getClass(), this.bean.getClass());
        JdbcBeanSerializer jdbcBeanSerializer = jdbcBeanInterface.getSerializer();
        int n = 0;
        while (n < stringArray.length) {
            try {
                String string = stringArray[n];
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                PropertyDescriptor propertyDescriptor2 = jdbcBeanSerializer.getPropertyDescriptor(string);
                Method method = propertyDescriptor2.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Object object = method.invoke((Object)jdbcBeanInterface, null);
                if (object != null) {
                    Object[] objectArray = new Object[]{object};
                    method2.invoke((Object)this.bean, objectArray);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            ++n;
        }
    }

    protected boolean updateProperties() {
        return this.updateProperties(this.beantables, this.result, true);
    }

    protected boolean updateProperties(Vector vector, ResultSet resultSet) {
        return this.updateProperties(vector, resultSet, true);
    }

    protected boolean updateProperties(Vector vector, ResultSet resultSet, boolean bl) {
        try {
            int n;
            JdbcBeanInterface[] jdbcBeanInterfaceArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n2 = 0;
            while (n2 < propertyDescriptorArray.length) {
                jdbcBeanInterfaceArray = propertyDescriptorArray[n2];
                if (!jdbcBeanInterfaceArray.isHidden()) {
                    try {
                        n = this.findColumn(vector, resultSet, jdbcBeanInterfaceArray.getName());
                        if (n != -1) {
                            Method method;
                            Object[] objectArray;
                            Object object = resultSet.getObject(n);
                            Class<?> clazz = jdbcBeanInterfaceArray.getPropertyType();
                            object = SQL.getMatchingValue(clazz, object);
                            if (object != null) {
                                objectArray = new Object[]{object};
                                method = jdbcBeanInterfaceArray.getWriteMethod();
                                if (method != null) {
                                    try {
                                        method.invoke((Object)this.bean, objectArray);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        illegalAccessException.printStackTrace();
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        invocationTargetException.printStackTrace();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        illegalArgumentException.printStackTrace();
                                    }
                                }
                            } else {
                                objectArray = jdbcBeanInterfaceArray.getReadMethod();
                                method = jdbcBeanInterfaceArray.getWriteMethod();
                                if (objectArray != null && method != null) {
                                    try {
                                        object = objectArray.invoke((Object)this.bean.getDefault(), null);
                                        Object[] objectArray2 = new Object[]{object};
                                        method.invoke((Object)this.bean, objectArray2);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        illegalAccessException.printStackTrace();
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        invocationTargetException.printStackTrace();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        illegalArgumentException.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                ++n2;
            }
            if (bl) {
                jdbcBeanInterfaceArray = this.getJdbcBeans();
                n = 0;
                while (n < jdbcBeanInterfaceArray.length) {
                    jdbcBeanInterfaceArray[n].getSerializer().updateProperties(vector, resultSet);
                    ++n;
                }
            }
            this.markModified(false);
            return true;
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
    }

    public void updateProperties(JdbcBeanInterface jdbcBeanInterface) {
        if (jdbcBeanInterface.getClass() != this.bean.getClass()) {
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.isHidden()) {
                    try {
                        Method method = propertyDescriptor.getReadMethod();
                        Method method2 = propertyDescriptor.getWriteMethod();
                        Object object = method.invoke((Object)jdbcBeanInterface, null);
                        if (object != null) {
                            Object[] objectArray = new Object[]{object};
                            method2.invoke((Object)this.bean, objectArray);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {}
    }

    protected boolean updateProperties(boolean bl) {
        return this.updateProperties(this.beantables, this.result, bl);
    }
}

