/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcServer;

public class JdbcBean {
    protected Properties props = new Properties();
    protected ResultSet sqlresult = null;
    protected boolean debug = false;
    protected String driver = null;
    protected String username = null;
    protected String password = null;
    protected String url = null;
    protected String sqlrequest = null;
    protected String result = null;

    public synchronized void executeSQL() {
        JdbcServer jdbcServer = JdbcServer.getServer(this.url, this.username, this.password, this.driver, this.props);
        try {
            this.sqlresult = jdbcServer.runQuery(this.sqlrequest, false);
            this.sqlresult.first();
        }
        catch (SQLException sQLException) {
            this.sqlresult = null;
        }
    }

    public synchronized void executeSQL(String string) {
        this.setSqlrequest(string);
        this.executeSQL();
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getDriver() {
        return this.driver;
    }

    public int getMaxconn() {
        return Jdbc.getMaxConn(this.props);
    }

    public String getPassword() {
        return this.password;
    }

    public ResultSet getResult() {
        return this.sqlresult;
    }

    public String getSqlrequest() {
        return this.sqlrequest;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public synchronized void setMaxconn(int n) {
        Jdbc.setMaxConn(this.props, n);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSqlrequest(String string) {
        this.sqlrequest = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }
}

