/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.util.Properties;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcConnection;
import org.w3c.tools.jdbc.JdbcServer;
import org.w3c.tools.jdbc.JdbcServerState;
import org.w3c.tools.jdbc.ManagerDescription;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.SyncLRUList;

public class ConnectionManager
implements PropertyMonitoring {
    public static final boolean debug = false;
    protected int conn_count = 0;
    protected int conn_max;
    Properties props = null;
    private static ManagerDescription[] managers = null;
    protected LRUList connectionsLru = null;

    private ConnectionManager(Properties properties) {
        this.props = properties;
        this.connectionsLru = new SyncLRUList();
        if (this.props instanceof ObservableProperties) {
            ((ObservableProperties)this.props).registerObserver(this);
        }
        this.conn_max = Jdbc.getMaxConn(this.props);
    }

    protected JdbcConnection allocateConnection(JdbcServer jdbcServer) {
        JdbcConnection jdbcConnection = new JdbcConnection(jdbcServer);
        this.notifyConnection(jdbcConnection);
        return jdbcConnection;
    }

    protected void deleteConnection(JdbcConnection jdbcConnection) {
        JdbcServerState jdbcServerState = jdbcConnection.getServer().getState();
        jdbcServerState.deleteConnection(jdbcConnection);
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            --this.conn_count;
            this.notify();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JdbcConnection getConnection(JdbcServer jdbcServer) {
        JdbcServerState jdbcServerState = jdbcServer.getState();
        JdbcConnection jdbcConnection = null;
        while (true) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                while ((jdbcConnection = jdbcServerState.getConnection()) != null) {
                    if (!jdbcConnection.markUsed()) continue;
                    return jdbcConnection;
                }
                if (this.negotiateConnection(jdbcServer)) {
                    jdbcConnection = this.allocateConnection(jdbcServer);
                    if (!jdbcConnection.markUsed()) return null;
                    return jdbcConnection;
                }
            }
            try {
                this.waitForConnection(jdbcServer);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static ConnectionManager getManager() {
        return ConnectionManager.getManager(System.getProperties());
    }

    public static synchronized ConnectionManager getManager(Properties properties) {
        if (managers != null) {
            int n = 0;
            while (n < managers.length) {
                if (managers[n] != null && managers[n].sameProperties(properties)) {
                    return managers[n].getManager();
                }
                ++n;
            }
        }
        ConnectionManager connectionManager = new ConnectionManager(properties);
        if (managers != null) {
            ManagerDescription[] managerDescriptionArray = new ManagerDescription[managers.length + 1];
            System.arraycopy(managers, 0, managerDescriptionArray, 0, managers.length);
            managerDescriptionArray[ConnectionManager.managers.length] = new ManagerDescription(connectionManager, properties);
        } else {
            managers = new ManagerDescription[1];
            ConnectionManager.managers[0] = new ManagerDescription(connectionManager, properties);
        }
        return connectionManager;
    }

    protected boolean negotiateConnection(JdbcServer jdbcServer) {
        if (this.conn_count >= this.conn_max) {
            JdbcConnection jdbcConnection = (JdbcConnection)this.connectionsLru.removeTail();
            if (jdbcConnection == null) {
                return false;
            }
            jdbcConnection.delete();
        }
        return true;
    }

    protected synchronized void notifyConnection(JdbcConnection jdbcConnection) {
        ++this.conn_count;
    }

    public synchronized void notifyIdle(JdbcConnection jdbcConnection) {
        this.connectionsLru.toHead(jdbcConnection);
        JdbcServerState jdbcServerState = jdbcConnection.getServer().getState();
        jdbcServerState.registerConnection(jdbcConnection);
        this.notify();
    }

    public void notifyUse(JdbcConnection jdbcConnection) {
        this.connectionsLru.remove(jdbcConnection);
    }

    public boolean propertyChanged(String string) {
        if (string.equals("org.w3c.tools.jdbc.maxconn")) {
            this.conn_max = Jdbc.getMaxConn(this.props);
            return true;
        }
        return false;
    }

    protected synchronized void waitForConnection(JdbcServer jdbcServer) throws InterruptedException {
        this.wait();
    }
}

