/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.servlet.ServletWrapper;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.www.mime.MimeType;

public class ServletWrapperFrame
extends HTTPFrame {
    protected ServletWrapper wrapper = null;

    public Reply createDefaultReply(Request request, int n) {
        Reply reply = super.createDefaultReply(request, n);
        reply.setLastModified(-1L);
        return reply;
    }

    protected boolean lookupOther(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Request request;
        String string = lookupState.getRemainingPath(true);
        if (string == null || string.equals("")) {
            string = "/";
        }
        if ((request = (Request)lookupState.getRequest()) != null && request.getState("javax.servlet.include.path_info") == null) {
            request.setState("javax.servlet.include.path_info", string);
        }
        lookupResult.setTarget(this.resource.getResourceReference());
        return super.lookupOther(lookupState, lookupResult);
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        ReplyInterface replyInterface = this.performFrames(requestInterface);
        if (replyInterface != null) {
            return replyInterface;
        }
        if (!this.checkRequest(requestInterface)) {
            return null;
        }
        Request request = (Request)requestInterface;
        if (this.wrapper == null) {
            Reply reply = request.makeReply(500);
            reply.setContent("Servlet Wrapper Frame not configured properly: must be attached to a ServletWrapper.");
            throw new HTTPException(reply);
        }
        try {
            this.wrapper.checkServlet();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Reply reply = request.makeReply(500);
            reply.setContent("The server was unable to find the servlet class : " + classNotFoundException.getMessage());
            throw new HTTPException(reply);
        }
        catch (ServletException servletException) {
            Reply reply = request.makeReply(500);
            reply.setContent("The server was unable to initialize the servlet : " + servletException.getMessage());
            throw new HTTPException(reply);
        }
        if (!this.wrapper.isInited()) {
            Reply reply = request.makeReply(500);
            reply.setContent("Servlet not configured properly");
            throw new HTTPException(reply);
        }
        Reply reply = this.createDefaultReply(request, 200);
        reply.setContentType(MimeType.TEXT_HTML);
        try {
            this.wrapper.service(request, reply);
        }
        catch (UnavailableException unavailableException) {
            reply = request.makeReply(503);
            if (unavailableException.isPermanent()) {
                reply.setContent("<h2>The servlet is permanently unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>");
            } else {
                int n = unavailableException.getUnavailableSeconds();
                if (n > 0) {
                    reply.setRetryAfter(n);
                    reply.setContent("<h2>The servlet is temporarily unavailable :</h2>Delay : " + n + " seconds<br><br>Details: <b>" + unavailableException.getMessage() + "</b>");
                } else {
                    reply.setContent("<h2>The servlet is temporarily unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>");
                }
            }
        }
        catch (Exception exception) {
            reply = request.makeReply(500);
            reply.setContent("Servlet has thrown exception:" + exception.toString());
        }
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
        if (framedResource instanceof ServletWrapper) {
            this.wrapper = (ServletWrapper)framedResource;
        }
    }
}

