/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeType;

public class Reply
extends HttpReplyMessage
implements ReplyInterface {
    protected static HttpMimeType DEFAULT_TYPE = null;
    protected static HttpTokenList CONNECTION = null;
    InputStream is = null;
    Client client = null;
    boolean keep = true;
    Request request = null;
    private boolean sendBody = true;
    protected boolean is_proxy = false;
    protected ResourceFilter[] filters = null;
    protected int infilters = -1;
    protected OutputStream output = null;
    protected Boolean chunkable = null;
    protected static String chunked;

    static {
        String[] stringArray = new String[]{"Keep-Alive"};
        CONNECTION = HttpFactory.makeStringList(stringArray);
        DEFAULT_TYPE = HttpFactory.makeMimeType(MimeType.TEXT_HTML);
        chunked = "chunked";
    }

    public Reply(Client client) {
        this.client = client;
    }

    public Reply(Client client, Request request, short s, short s2, int n) {
        this(client);
        this.request = request;
        this.major = s;
        this.minor = s2;
        this.keep = true;
        this.setServer(client != null ? client.getServer().getSoftware() : null);
        this.setStatus(n);
        if (request != null && request.getMethod().endsWith("HEAD")) {
            this.sendBody = false;
        }
    }

    public boolean canChunkTransfer() {
        if (this.chunkable == null) {
            if (this.hasContentLength() || this.is == null) {
                this.chunkable = Boolean.FALSE;
            } else if (this.major >= 1 && this.minor >= 1) {
                String[] stringArray = this.getConnection();
                this.chunkable = Boolean.TRUE;
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equalsIgnoreCase("close")) {
                            this.chunkable = Boolean.FALSE;
                        }
                        ++n;
                    }
                }
                if (this.chunkable == Boolean.TRUE) {
                    this.addTransferEncoding(chunked);
                }
            } else {
                this.chunkable = Boolean.FALSE;
            }
        }
        return this.chunkable == Boolean.TRUE;
    }

    public FileDescriptor getInputFileDescriptor() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(true);
    }

    public synchronized OutputStream getOutputStream(boolean bl) throws IOException {
        if (this.output != null) {
            return this.output;
        }
        this.output = this.client.getOutputStream();
        while (--this.infilters >= 0) {
            this.output = this.filters[this.infilters].outputFilter(this.request, this, this.output);
        }
        if (bl) {
            DataOutputStream dataOutputStream = new DataOutputStream(this.output);
            this.emit(dataOutputStream);
            dataOutputStream.flush();
            this.setStatus(1001);
        }
        this.keep = false;
        return this.output;
    }

    public boolean hasContentLength() {
        return this.hasHeader(HttpEntityMessage.H_CONTENT_LENGTH);
    }

    public boolean hasContentType() {
        return this.hasHeader(HttpEntityMessage.H_CONTENT_TYPE);
    }

    public boolean hasStream() {
        return this.is != null;
    }

    public boolean keepProxyConnection() {
        throw new RuntimeException("keepProxyConnection: not implemented!");
    }

    public InputStream openStream() {
        return this.is;
    }

    public void setContent(String string) {
        this.setContent(string, "ISO-8859-1");
    }

    public void setContent(String string, String string2) {
        byte[] byArray;
        if (!this.hasContentType()) {
            this.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)DEFAULT_TYPE);
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[setContent] Unable to convert" + "properly char to bytes");
        }
        this.setContentLength(byArray.length);
        if (this.sendBody) {
            this.is = new ByteArrayInputStream(byArray);
        }
    }

    protected void setFilters(ResourceFilter[] resourceFilterArray, int n) {
        this.filters = resourceFilterArray;
        this.infilters = n;
    }

    public void setKeepAlive(String string) {
        this.setValue("Keep-Alive", string);
    }

    public void setKeepConnection(boolean bl) {
        this.keep = bl;
    }

    public void setProxy(boolean bl) {
        this.is_proxy = bl;
    }

    public void setProxyConnection(String string) {
        this.setValue("Proxy-Connection", string);
    }

    public void setStatus(Integer n) {
        this.setStatus((int)n);
    }

    public void setStream(InputStream inputStream) {
        if (this.sendBody) {
            this.is = inputStream;
        }
    }

    public void setStream(HtmlGenerator htmlGenerator) {
        htmlGenerator.close();
        this.setContentLength(htmlGenerator.length());
        this.setContentType(htmlGenerator.getMimeType());
        if (this.sendBody) {
            this.setStream(htmlGenerator.getInputStream());
        }
    }

    public boolean tryKeepConnection() {
        if (!this.keep) {
            this.addConnection("close");
            return false;
        }
        if (this.major >= 1) {
            if (this.minor >= 1) {
                return true;
            }
            if (this.hasContentLength() || this.is == null) {
                if (this.is_proxy) {
                    this.addProxyConnection("Keep-Alive");
                } else {
                    this.addConnection("Keep-Alive");
                }
                return true;
            }
        }
        return false;
    }
}

