/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPRuntimeException;
import org.w3c.jigsaw.http.Logger;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;

public class CommonLogger
extends Logger
implements PropertyMonitoring {
    protected static final String[] monthnames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String LOGNAME_P = "org.w3c.jigsaw.logger.logname";
    public static final String ERRLOGNAME_P = "org.w3c.jigsaw.logger.errlogname";
    public static final String LOGDIRNAME_P = "org.w3c.jigsaw.logger.logdirname";
    public static final String TRACELOGNAME_P = "org.w3c.jigsaw.logger.tracelogname";
    public static final String BUFSIZE_P = "org.w3c.jigsaw.logger.bufferSize";
    public static final String ROTATE_LEVEL_P = "org.w3c.jigsaw.logger.rotateLevel";
    private byte[] msgbuf = new byte[128];
    protected RandomAccessFile log = null;
    protected RandomAccessFile errlog = null;
    protected RandomAccessFile trace = null;
    protected httpd server = null;
    protected ObservableProperties props = null;
    protected int bufsize = 8192;
    protected int bufptr = 0;
    protected int rotateLevel = 0;
    protected byte[] buffer = null;
    protected int year = -1;
    protected int month = -1;
    protected int day = -1;
    protected int tz = -1;

    CommonLogger() {
    }

    protected synchronized void appendLogBuffer(String string) throws IOException {
        int n = string.length();
        if (this.bufptr + n > this.buffer.length) {
            this.log.write(this.buffer, 0, this.bufptr);
            this.bufptr = 0;
            if (n > this.buffer.length) {
                byte[] byArray = new byte[n];
                string.getBytes(0, n, byArray, 0);
                this.log.write(byArray, 0, n);
                return;
            }
        }
        string.getBytes(0, n, this.buffer, this.bufptr);
        this.bufptr += n;
    }

    protected void checkLogFile(Date date) {
        int n = date.getYear() + 1900;
        if (this.rotateLevel == 1) {
            if (n != this.year) {
                CommonLogger commonLogger = this;
                synchronized (commonLogger) {
                    if (this.log != null) {
                        this.sync();
                    }
                    this.year = n;
                    this.openLogFile(this.year);
                }
            }
        } else {
            int n2 = date.getMonth();
            if (this.rotateLevel == 2) {
                if (n != this.year || n2 != this.month) {
                    CommonLogger commonLogger = this;
                    synchronized (commonLogger) {
                        if (this.log != null) {
                            this.sync();
                        }
                        this.year = n;
                        this.month = n2;
                        this.openLogFile(this.year, this.month);
                    }
                }
            } else {
                int n3 = date.getDate();
                if (this.rotateLevel == 3 && (n != this.year || n2 != this.month || n3 != this.day)) {
                    CommonLogger commonLogger = this;
                    synchronized (commonLogger) {
                        if (this.log != null) {
                            this.sync();
                        }
                        this.year = n;
                        this.month = n2;
                        this.day = n3;
                        this.openLogFile(this.year, this.month, this.day);
                    }
                }
            }
        }
    }

    public void errlog(String string) {
        this.errlogmsg(String.valueOf(string) + "\n");
    }

    public void errlog(Client client, String string) {
        this.errlogmsg(String.valueOf(String.valueOf(client)) + ": " + string + "\n");
    }

    protected void errlogmsg(String string) {
        if (this.errlog != null) {
            try {
                this.output(this.errlog, string);
            }
            catch (IOException iOException) {
                throw new HTTPRuntimeException(this, "errlogmsg", iOException.getMessage());
            }
        }
    }

    protected String getFilename(String string, String string2) {
        String string3 = this.props.getString(string, null);
        File file = null;
        if (string3 == null) {
            String string4 = this.props.getString(LOGDIRNAME_P, null);
            if (string4 == null) {
                File file2 = this.server.getRootDirectory();
                if (file2 == null) {
                    String string5 = "unable to build a default value for the \"" + string + "\" value.";
                    throw new HTTPRuntimeException(this.getClass().getName(), "getFilename", string5);
                }
                file = new File(file2, "logs");
            } else {
                try {
                    file = new File(string4);
                }
                catch (RuntimeException runtimeException) {
                    String string6 = "unable to access log directory " + string4;
                    throw new HTTPRuntimeException(this.getClass().getName(), "getFilename", string6);
                }
            }
            return new File(file, string2).getAbsolutePath();
        }
        String string7 = this.props.getString(LOGDIRNAME_P, null);
        if (string7 == null) {
            return string3;
        }
        try {
            file = new File(string7);
        }
        catch (RuntimeException runtimeException) {
            String string8 = "unable to access log directory " + string7;
            throw new HTTPRuntimeException(this.getClass().getName(), "getFilename", string8);
        }
        return new File(file, string3).getAbsolutePath();
    }

    public void initialize(httpd httpd2) {
        this.server = httpd2;
        this.props = httpd2.getProperties();
        this.props.registerObserver(this);
        this.rotateLevel = this.props.getInteger(ROTATE_LEVEL_P, 0);
        this.openLogFile();
        this.openErrorLogFile();
        this.openTraceFile();
        this.bufsize = this.props.getInteger(BUFSIZE_P, this.bufsize);
        if (this.bufsize > 0) {
            this.buffer = new byte[this.bufsize];
        }
    }

    public void log(String string) {
        this.logmsg(string);
    }

    public void log(Request request, Reply reply, int n, long l) {
        Client client = request.getClient();
        String string = null;
        long l2 = reply.getDate();
        if (this.tz == -1) {
            this.tz = new Date().getTimezoneOffset();
        }
        Date date = l2 < 0L ? new Date(new Date().getTime() + (long)(this.tz * 60 * 1000)) : new Date(l2 + (long)(this.tz * 60 * 1000));
        if (this.rotateLevel > 0) {
            this.checkLogFile(date);
        }
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        string = String.valueOf(client.getInetAddress().getHostAddress()) + " " + "-" + " " + (string2 == null ? "-" : string2) + (date.getDate() < 10 ? " [0" : " [") + date.getDate() + "/" + monthnames[date.getMonth()] + "/" + (date.getYear() + 1900) + (date.getHours() < 10 ? ":0" + date.getHours() : ":" + date.getHours()) + (date.getMinutes() < 10 ? ":0" + date.getMinutes() : ":" + date.getMinutes()) + (date.getSeconds() < 10 ? ":0" + date.getSeconds() : ":" + date.getSeconds()) + " +0000]" + " \"" + request.getMethod() + " " + request.getURL() + " " + request.getVersion() + "\" " + reply.getStatus() + " " + (n < 0 ? "-" : Integer.toString(n)) + "\n";
        this.logmsg(string);
    }

    protected void logmsg(String string) {
        if (this.log != null) {
            try {
                if (this.buffer == null) {
                    this.output(this.log, string);
                } else {
                    this.appendLogBuffer(string);
                }
            }
            catch (IOException iOException) {
                throw new HTTPRuntimeException(this, "logmsg", iOException.getMessage());
            }
        }
    }

    protected void openErrorLogFile() {
        String string = this.getFilename(ERRLOGNAME_P, "errlog");
        try {
            RandomAccessFile randomAccessFile = this.errlog;
            this.errlog = new RandomAccessFile(string, "rw");
            this.errlog.seek(this.errlog.length());
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            throw new HTTPRuntimeException(this.getClass().getName(), "openErrorLogFile", "unable to open " + string);
        }
    }

    protected void openLogFile() {
        if (this.rotateLevel > 0) {
            if (this.tz == -1) {
                this.tz = new Date().getTimezoneOffset();
            }
            Date date = new Date();
            this.year = -1;
            this.checkLogFile(date);
        } else {
            String string = this.getFilename(LOGNAME_P, "log");
            try {
                RandomAccessFile randomAccessFile = this.log;
                this.log = new RandomAccessFile(string, "rw");
                this.log.seek(this.log.length());
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                throw new HTTPRuntimeException(this.getClass().getName(), "openLogFile", "unable to open " + string);
            }
        }
    }

    protected void openLogFile(int n) {
        this.year = n;
        String string = String.valueOf(this.getFilename(LOGNAME_P, "log")) + "_" + n;
        try {
            RandomAccessFile randomAccessFile = this.log;
            this.log = new RandomAccessFile(string, "rw");
            this.log.seek(this.log.length());
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            throw new HTTPRuntimeException(this.getClass().getName(), "openLogFile", "unable to open " + string);
        }
    }

    protected void openLogFile(int n, int n2) {
        this.year = n;
        this.month = n2;
        String string = null;
        string = n2 < 10 ? "_" + n + "_0" + (n2 + 1) : "_" + n + "_" + (n2 + 1);
        String string2 = String.valueOf(this.getFilename(LOGNAME_P, "log")) + string;
        try {
            RandomAccessFile randomAccessFile = this.log;
            this.log = new RandomAccessFile(string2, "rw");
            this.log.seek(this.log.length());
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            throw new HTTPRuntimeException(this.getClass().getName(), "openLogFile", "unable to open " + string2);
        }
    }

    protected void openLogFile(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        String string = null;
        string = n2 < 10 ? (n3 < 10 ? "_" + n + "_0" + (n2 + 1) + "_0" + n3 : "_" + n + "_0" + (n2 + 1) + "_" + n3) : (n3 < 10 ? "_" + n + "_" + (n2 + 1) + "_0" + n3 : "_" + n + "_" + (n2 + 1) + "_" + n3);
        String string2 = String.valueOf(this.getFilename(LOGNAME_P, "log")) + string;
        try {
            RandomAccessFile randomAccessFile = this.log;
            this.log = new RandomAccessFile(string2, "rw");
            this.log.seek(this.log.length());
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            throw new HTTPRuntimeException(this.getClass().getName(), "openLogFile", "unable to open " + string2);
        }
    }

    protected void openTraceFile() {
        String string = this.getFilename(TRACELOGNAME_P, "traces");
        try {
            RandomAccessFile randomAccessFile = this.trace;
            this.trace = new RandomAccessFile(string, "rw");
            this.trace.seek(this.trace.length());
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            throw new HTTPRuntimeException(this.getClass().getName(), "openTraceFile", "unable to open " + string);
        }
    }

    protected synchronized void output(RandomAccessFile randomAccessFile, String string) throws IOException {
        int n = string.length();
        if (n > this.msgbuf.length) {
            this.msgbuf = new byte[n];
        }
        string.getBytes(0, n, this.msgbuf, 0);
        randomAccessFile.write(this.msgbuf, 0, n);
    }

    public boolean propertyChanged(String string) {
        if (string.equals(LOGNAME_P)) {
            try {
                this.openLogFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals(ERRLOGNAME_P)) {
            try {
                this.openErrorLogFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals(TRACELOGNAME_P)) {
            try {
                this.openTraceFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals(LOGDIRNAME_P)) {
            try {
                this.openLogFile();
                this.openErrorLogFile();
                this.openTraceFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals(BUFSIZE_P)) {
            CommonLogger commonLogger = this;
            synchronized (commonLogger) {
                this.bufsize = this.props.getInteger(string, this.bufsize);
                if (this.bufptr > 0) {
                    try {
                        this.log.write(this.buffer, 0, this.bufptr);
                        this.bufptr = 0;
                    }
                    catch (IOException iOException) {}
                }
                this.buffer = this.bufsize > 0 ? new byte[this.bufsize] : null;
                boolean bl = true;
                Object var4_10 = null;
                return bl;
            }
        }
        if (string.equals(ROTATE_LEVEL_P)) {
            int n = this.props.getInteger(string, this.rotateLevel);
            if (n != this.rotateLevel) {
                CommonLogger commonLogger = this;
                synchronized (commonLogger) {
                    this.sync();
                    this.rotateLevel = n;
                    this.openLogFile();
                }
            }
            return true;
        }
        return true;
    }

    public synchronized void shutdown() {
        this.server.getProperties().unregisterObserver(this);
        try {
            if (this.buffer != null && this.bufptr > 0) {
                this.log.write(this.buffer, 0, this.bufptr);
                this.bufptr = 0;
            }
            this.log.close();
            this.log = null;
            this.errlog.close();
            this.errlog = null;
            this.trace.close();
            this.trace = null;
        }
        catch (IOException iOException) {
            this.server.errlog(String.valueOf(this.getClass().getName()) + ": IO exception in method shutdown \"" + iOException.getMessage() + "\".");
        }
    }

    public synchronized void sync() {
        try {
            if (this.buffer != null && this.bufptr > 0) {
                this.log.write(this.buffer, 0, this.bufptr);
                this.bufptr = 0;
            }
        }
        catch (IOException iOException) {
            this.server.errlog(String.valueOf(this.getClass().getName()) + ": IO exception in method sync \"" + iOException.getMessage() + "\".");
        }
    }

    public void trace(String string) {
        this.tracemsg(String.valueOf(string) + "\n");
    }

    public void trace(Client client, String string) {
        this.tracemsg(String.valueOf(String.valueOf(client)) + ": " + string + "\n");
    }

    protected void tracemsg(String string) {
        if (this.trace != null) {
            try {
                this.output(this.trace, string);
            }
            catch (IOException iOException) {
                throw new HTTPRuntimeException(this, "tracemsg", iOException.getMessage());
            }
        }
    }
}

