/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminWriter;
import org.w3c.jigsaw.admin.ResourceBroker;
import org.w3c.jigsaw.admin.ServerHandlerManagerResource;
import org.w3c.jigsaw.auth.GenericAuthFilter;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.daemon.ServerHandlerInitException;
import org.w3c.jigsaw.daemon.ServerHandlerManager;
import org.w3c.jigsaw.filters.TEFilter;
import org.w3c.jigsaw.http.ControlResource;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;
import org.w3c.util.ObservableProperties;

public class AdminServer
extends httpd {
    protected ResourceBroker broker = null;
    protected ServerHandlerManager shm = null;
    protected AdminWriter writer = null;
    protected AbstractContainer root = null;
    protected ResourceReference rr_root = null;
    protected ControlResource controlConfig = null;
    protected ResourceReference rr_controlConfig = null;
    protected GenericAuthFilter auth = null;
    protected Serializer serializer = null;
    protected ResourceFilter[] filters = null;
    protected RealmsCatalog realms = null;
    protected ResourceReference rr_realms = null;

    protected void addFilter(ResourceFilter resourceFilter, Hashtable hashtable) {
        resourceFilter.initialize(hashtable);
        if (this.filters == null) {
            this.filters = new ResourceFilter[1];
            this.filters[0] = resourceFilter;
        } else {
            int n = this.filters.length;
            ResourceFilter[] resourceFilterArray = new ResourceFilter[n + 1];
            System.arraycopy(this.filters, 0, resourceFilterArray, 0, n);
            resourceFilterArray[n] = resourceFilter;
            this.filters = resourceFilterArray;
        }
    }

    protected String getBanner() {
        return "JigAdmin[2.1.2]";
    }

    public ResourceReference getConfigResource() {
        return this.getRootReference();
    }

    public ResourceReference getControlResource() {
        if (this.rr_controlConfig == null) {
            this.controlConfig = new ControlResource(this);
            this.rr_controlConfig = new DummyResourceReference(this.controlConfig);
        }
        return this.rr_controlConfig;
    }

    public ResourceReference getRealmCatalogResource() {
        if (this.rr_realms == null) {
            this.rr_realms = new DummyResourceReference(this.getRealmsCatalog());
        }
        return this.rr_realms;
    }

    public RealmsCatalog getRealmsCatalog() {
        if (this.realms == null) {
            this.initializeRealmsCatalog();
        }
        return this.realms;
    }

    public FramedResource getRoot() {
        return this.root;
    }

    public ResourceReference getRootReference() {
        if (this.rr_root == null) {
            this.rr_root = new DummyResourceReference(this.root);
        }
        return this.rr_root;
    }

    public void initialize(ServerHandlerManager serverHandlerManager, String string, ObservableProperties observableProperties) throws ServerHandlerInitException {
        super.initialize(serverHandlerManager, string, observableProperties);
        this.shm = serverHandlerManager;
        this.writer = new AdminWriter();
        this.broker = new ResourceBroker(serverHandlerManager, this, this.writer);
        this.root = new ServerHandlerManagerResource(this, serverHandlerManager);
        this.auth = new GenericAuthFilter();
        this.serializer = new XMLSerializer();
        this.initializeAuth();
        TEFilter tEFilter = new TEFilter();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        hashtable.put("identifier", "tefilter");
        String[] stringArray = new String[]{AdminContext.conftype.toString()};
        hashtable.put("mime-types", stringArray);
        this.addFilter(tEFilter, hashtable);
    }

    protected void initializeAuth() {
        Hashtable<String, String> hashtable = null;
        hashtable = new Hashtable<String, String>(3);
        hashtable.put("identifier", "auth-frame");
        this.root.registerFrame(this.auth, hashtable);
        this.auth.setValue("realm", (Object)"JigAdmin");
    }

    private void initializeRealmsCatalog() {
        this.realms = new RealmsCatalog(new ResourceContext(this.getDefaultContext()), "adminRealms.db");
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        Request request = (Request)requestInterface;
        Reply reply = null;
        this.auth.authenticate(request);
        int n = 0;
        while (n < this.filters.length) {
            reply = (Reply)this.filters[n].ingoingFilter(requestInterface);
            if (reply != null) {
                return reply;
            }
            ++n;
        }
        String string = request.getMethod();
        if (string.equals("LOAD-ROOT")) {
            reply = this.remoteLoadRoot(request);
        } else {
            try {
                reply = (Reply)this.broker.perform(request);
            }
            catch (ProtocolException protocolException) {
                throw new HTTPException(protocolException);
            }
        }
        int n2 = this.filters.length - 1;
        while (n2 > -1) {
            Reply reply2 = (Reply)this.filters[n2].outgoingFilter(requestInterface, reply);
            if (reply2 != null) {
                return reply2;
            }
            --n2;
        }
        return reply;
    }

    public Reply remoteLoadRoot(Request request) throws ProtocolException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writer.writeResource(this.root, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            throw new HTTPException("unable to dump root");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            throw new HTTPException("unable to dump root: " + exception.getMessage());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Reply reply = request.makeReply(200);
        reply.setStream(new ByteArrayInputStream(byArray));
        reply.setContentLength(byArray.length);
        reply.setContentType(AdminContext.conftype);
        return reply;
    }
}

