/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.w3c.jigsaw.frames.MimeTypeAttribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.ByteRangeOutputStream;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpContentRange;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.ActiveStream;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CachedResource;

public class EntityCachedResource
extends CachedResource {
    public static final int COND_FAILED = 1;
    public static final int COND_OK = 2;
    protected static int ATTR_CONTENT_TYPE = -1;
    protected static int ATTR_FRESHNESS_LIFETIME = -1;
    protected static int ATTR_INITIAL_AGE = -1;
    protected static int ATTR_RESPONSE_TIME = -1;
    protected static int ATTR_REVALIDATE = -1;
    protected static int ATTR_LOAD_STATE = -1;
    protected boolean uploading = false;
    protected boolean revalidating = false;
    protected boolean regetting = false;
    protected boolean hasEntity = false;
    protected int oldsize = -1;
    protected int wantedsize = -1;
    protected CacheFilter filter;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.www.protocol.http.cache.EntityCachedResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new MimeTypeAttribute("content-type", null, 1);
        ATTR_CONTENT_TYPE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("freshness-lifetime", null, 1);
        ATTR_FRESHNESS_LIFETIME = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("initial-age", null, 1);
        ATTR_INITIAL_AGE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new LongAttribute("response-time", null, 1);
        ATTR_RESPONSE_TIME = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("revalidate", Boolean.FALSE, 1);
        ATTR_REVALIDATE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public EntityCachedResource() {
    }

    public EntityCachedResource(CacheFilter cacheFilter, Request request, Reply reply) {
        this.invalidated = false;
        this.setValue(CachedResource.ATTR_IDENTIFIER, (Object)request.getURL().toExternalForm());
        this.filter = cacheFilter;
        this.updateInfo(request, reply);
        cacheFilter.getValidator().updateExpirationInfo(this, request, reply);
        this.setFile(cacheFilter.getStore().getNewEntryFile());
        this.wantedsize = reply.getContentLength();
        try {
            InputStream inputStream = this.tryActiveCacheContent(reply.getInputStream());
            reply.setStream(inputStream);
        }
        catch (IOException iOException) {}
    }

    public int checkIfMatch(Request request) {
        HttpEntityTag[] httpEntityTagArray = request.getIfMatch();
        if (httpEntityTagArray != null) {
            HttpEntityTag httpEntityTag = this.getHETag();
            if (httpEntityTag != null) {
                int n = 0;
                while (n < httpEntityTagArray.length) {
                    HttpEntityTag httpEntityTag2 = httpEntityTagArray[n];
                    if (!httpEntityTag2.isWeak() && httpEntityTag2.getTag().equals(httpEntityTag.getTag())) {
                        return 2;
                    }
                    ++n;
                }
            }
            return 1;
        }
        return 0;
    }

    public int checkIfModifiedSince(Request request) {
        long l = request.getIfModifiedSince();
        long l2 = this.getLastModified();
        if (l >= 0L) {
            return l2 > 0L && l2 - 1000L <= l ? 1 : 2;
        }
        return 0;
    }

    public int checkIfNoneMatch(Request request) {
        HttpEntityTag[] httpEntityTagArray = request.getIfNoneMatch();
        if (httpEntityTagArray != null) {
            HttpEntityTag httpEntityTag = this.getHETag();
            if (httpEntityTag == null) {
                return 2;
            }
            int n = 0;
            while (n < httpEntityTagArray.length) {
                HttpEntityTag httpEntityTag2 = httpEntityTagArray[n];
                if (!httpEntityTag2.isWeak() && httpEntityTag2.getTag().equals(httpEntityTag.getTag())) {
                    return 1;
                }
                ++n;
            }
            return 2;
        }
        return 0;
    }

    public int checkIfUnmodifiedSince(Request request) {
        long l = request.getIfUnmodifiedSince();
        long l2 = this.getLastModified();
        if (l >= 0L) {
            return l2 > 0L && l2 - 1000L >= l ? 1 : 2;
        }
        return 0;
    }

    protected synchronized void cleanUpload() {
        this.uploading = false;
        this.filter.cleanUpload(this);
        this.notifyAll();
    }

    public MimeType getContentType() {
        return (MimeType)this.getValue(ATTR_CONTENT_TYPE, null);
    }

    public int getCurrentAge() {
        long l = System.currentTimeMillis();
        return (int)((long)this.getInitialAge() + (l - this.getResponseTime()) / 1000L);
    }

    public int getFreshnessLifetime() {
        return this.getInt(ATTR_FRESHNESS_LIFETIME, -1);
    }

    public HttpEntityTag getHETag() {
        if (this.definesAttribute(CachedResource.ATTR_ETAG)) {
            if (this.etags == null) {
                this.etags = new HttpEntityTag[1];
                this.etags[0] = HttpFactory.parseETag(this.getETag());
            }
            return this.etags[0];
        }
        return null;
    }

    public int getInitialAge() {
        return this.getInt(ATTR_INITIAL_AGE, -1);
    }

    public synchronized InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getFile()));
    }

    public long getResponseTime() {
        return this.getLong(ATTR_RESPONSE_TIME, -1L);
    }

    public boolean getRevalidate() {
        return this.getBoolean(ATTR_REVALIDATE, false);
    }

    protected Reply handleRangeRequest(Request request, HttpRange httpRange) {
        int n;
        HttpEntityTag httpEntityTag = request.getIfRange();
        if (httpEntityTag != null && (httpEntityTag.isWeak() || !httpEntityTag.getTag().equals(this.getHETag().getTag()))) {
            return null;
        }
        int n2 = this.getContentLength();
        int n3 = httpRange.getFirstPosition();
        int n4 = httpRange.getLastPosition();
        if (n3 > n2 - 1) {
            HttpContentRange httpContentRange = HttpFactory.makeContentRange("bytes", 0, n2 - 1, n2);
            Reply reply = request.makeReply(416);
            reply.setContentLength(-1);
            reply.setHeaderValue(HttpEntityMessage.H_CONTENT_RANGE, (HeaderValue)httpContentRange);
            reply.setContentMD5(null);
            return reply;
        }
        if (n3 < 0 && n4 >= 0) {
            if (n4 >= n2) {
                n4 = n2;
            }
            n = n4;
            n3 = n2 - n4;
            n4 = n2 - 1;
        } else if (n4 < 0) {
            n4 = n2 - 1;
            n = n4 - n3 + 1;
        } else {
            if (n4 >= n2) {
                n4 = n2 - 1;
            }
            n = n4 - n3 + 1;
        }
        if (n3 < 0 || n4 < 0 || n3 <= n4) {
            HttpContentRange httpContentRange = null;
            n3 = n3 < 0 ? 0 : n3;
            n4 = n4 > n2 || n4 < 0 ? n2 : n4;
            httpContentRange = HttpFactory.makeContentRange("bytes", n3, n4, n2);
            Reply reply = request.makeReply(206);
            try {
                reply.setContentMD5(null);
                reply.setContentLength(n);
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_RANGE, (HeaderValue)httpContentRange);
                reply.setStream(new ByteRangeOutputStream(this.getFile(), n3, n4 + 1));
                return reply;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
    }

    public void notifyTeeFailure(int n) {
        System.out.println(String.valueOf(this.getIdentifier()) + ": tee streaming failed !");
        int n2 = this.getLoadState();
        this.setCurrentLength(n);
        this.setLoadState(4);
        System.out.println(String.valueOf(this.getIdentifier()) + ": tee stream mismatch, " + "bytes(adv/got)=" + this.wantedsize + "/" + n);
        this.cleanUpload();
    }

    public synchronized void notifyTeeSuccess(int n) {
        block11: {
            int n2 = this.getLoadState();
            try {
                if (this.wantedsize > 0) {
                    if (!this.regetting) {
                        if (n2 == 0) {
                            if (n == this.wantedsize) {
                                this.setCurrentLength(n);
                                this.setLoadState(1);
                            } else {
                                this.setCurrentLength(n);
                                this.setLoadState(4);
                                System.out.println(String.valueOf(this.getIdentifier()) + ": tee stream mismatch, " + "bytes(adv/got)=" + this.wantedsize + "/" + n);
                            }
                        } else {
                            this.setCurrentLength(n);
                            this.setLoadState(4);
                            System.out.println(String.valueOf(this.getIdentifier()) + ": UNKNOWN STATE for " + "tee stream!, bytes(adv/got)=" + this.wantedsize + "/" + n);
                        }
                    } else if (n == this.wantedsize) {
                        this.setCurrentLength(this.oldsize + this.wantedsize);
                        this.setLoadState(1);
                    } else {
                        this.setCurrentLength(n);
                        this.setLoadState(4);
                        System.out.println(String.valueOf(this.getIdentifier()) + ": tee stream mismatch in reget, " + "bytes(adv/got)=" + this.wantedsize + "/" + n);
                    }
                    break block11;
                }
                this.setCurrentLength(n);
                this.setLoadState(1);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.cleanUpload();
                throw throwable;
            }
        }
        Object var4_3 = null;
        this.cleanUpload();
    }

    public Reply perform(Request request) throws HttpException {
        this.waitUpload();
        try {
            Reply reply = null;
            boolean bl = true;
            HttpRange[] httpRangeArray = request.getRange();
            if (httpRangeArray != null && httpRangeArray.length == 1) {
                reply = this.handleRangeRequest(request, httpRangeArray[0]);
            }
            if (reply == null) {
                int n = this.getStatus();
                if (this.checkIfMatch(request) == 1) {
                    n = 412;
                    bl = false;
                } else if (this.checkIfNoneMatch(request) == 1) {
                    n = 304;
                    bl = false;
                } else if (this.checkIfModifiedSince(request) == 1) {
                    n = 304;
                    bl = false;
                } else if (this.checkIfUnmodifiedSince(request) == 1) {
                    n = 412;
                    bl = false;
                }
                reply = request.makeReply(n);
                if (bl) {
                    reply.setStream(this.getInputStream());
                }
            }
            this.setReplyHeaders(reply);
            String string = request.getMethod();
            if (string.equals("HEAD") || string.equals("OPTIONS")) {
                reply.setStream(null);
            }
            return reply;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setContentType(MimeType mimeType) {
        this.setValue(ATTR_CONTENT_TYPE, (Object)mimeType);
    }

    public void setFreshnessLifetime(int n) {
        this.setInt(ATTR_FRESHNESS_LIFETIME, n);
    }

    public void setInitialAge(int n) {
        this.setInt(ATTR_INITIAL_AGE, n);
    }

    protected Reply setReplyHeaders(Reply reply) {
        reply.setContentLength(this.getContentLength());
        reply.setContentMD5(this.getContentMD5());
        reply.setContentLanguage(this.getContentLanguage());
        reply.setContentEncoding(this.getContentEncoding());
        reply.setContentType(this.getContentType());
        reply.setETag(this.getHETag());
        reply.setLastModified(this.getLastModified());
        long l = this.getDate();
        if (l > 0L) {
            reply.setDate(this.getDate());
        }
        reply.setAge(this.getCurrentAge());
        if (this.a != null) {
            Enumeration enumeration = this.a.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.a.get(string);
                reply.setValue(string, string2);
            }
        }
        return reply;
    }

    public Request setRequestRevalidation(Request request) {
        Request request2 = (Request)request.getClone();
        request.setState("org.w3c.www.protocol.http.cache.resource", this);
        request.setState("org.w3c.www.protocol.http.cache.CacheFilter.origreq", request2);
        request.setIfModifiedSince(this.getLastModified());
        if (this.etags == null && this.getETag() != null) {
            this.etags = new HttpEntityTag[1];
            this.etags[0] = HttpFactory.parseETag(this.getETag());
        }
        request.setIfNoneMatch(this.etags);
        request.setIfRange(null);
        request.setRange(null);
        request.setIfUnmodifiedSince(-1L);
        request.setIfMatch(null);
        return request;
    }

    public void setResponseTime(long l) {
        this.setLong(ATTR_RESPONSE_TIME, l);
    }

    public void setRevalidate(boolean bl) {
        this.setBoolean(ATTR_REVALIDATE, bl);
    }

    public synchronized InputStream tryActiveCacheContent(InputStream inputStream) throws IOException {
        InputStream inputStream2 = null;
        FileOutputStream fileOutputStream = null;
        this.uploading = true;
        try {
            fileOutputStream = new FileOutputStream(this.getFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        inputStream2 = ActiveStream.createTee(this, inputStream, fileOutputStream);
        if (inputStream2 != null) {
            return inputStream2;
        }
        try {
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {}
        return null;
    }

    protected void updateInfo(Request request, Reply reply) {
        String string = request.getMethod();
        boolean bl = (string.equals("HEAD") || string.equals("OPTIONS")) ^ true;
        if (!request.hasState("org.w3c.www.protocol.http.cache.revalidation")) {
            this.setStatus(reply.getStatus());
            this.setContentType(reply.getContentType());
            this.setContentLength(reply.getContentLength());
            this.setLastModified(reply.getLastModified());
            if (reply.hasHeader(HttpEntityMessage.H_ETAG)) {
                this.setETag(reply.getETag().toString());
            } else {
                this.setETag(null);
            }
            ArrayDictionary arrayDictionary = new ArrayDictionary(5, 5);
            Enumeration enumeration = reply.enumerateHeaderDescriptions();
            while (enumeration.hasMoreElements()) {
                HeaderDescription headerDescription = (HeaderDescription)enumeration.nextElement();
                if (headerDescription.isHeader(HttpEntityMessage.H_CONTENT_TYPE) || headerDescription.isHeader(HttpEntityMessage.H_CONTENT_LENGTH) || headerDescription.isHeader(HttpEntityMessage.H_LAST_MODIFIED) || headerDescription.isHeader(HttpEntityMessage.H_ETAG) || headerDescription.isHeader(HttpReplyMessage.H_AGE) || headerDescription.isHeader(HttpMessage.H_DATE) || headerDescription.isHeader(HttpMessage.H_CONNECTION)) continue;
                arrayDictionary.put(headerDescription.getName(), reply.getValue(headerDescription));
            }
        }
    }

    protected final synchronized void waitUpload() {
        while (this.uploading) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

