/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.www.http.HttpStreamObserver;

public class ContentLengthInputStream
extends InputStream {
    protected InputStream in = null;
    protected HttpStreamObserver observer = null;
    protected int length = 0;
    protected int marklength = 0;

    public ContentLengthInputStream(InputStream inputStream, int n) {
        this(null, inputStream, n);
    }

    public ContentLengthInputStream(HttpStreamObserver httpStreamObserver, InputStream inputStream, int n) {
        this.observer = httpStreamObserver;
        this.in = inputStream;
        this.length = n;
    }

    public int available() throws IOException {
        return this.length;
    }

    public synchronized void close() throws IOException {
        if (this.observer != null) {
            this.observer.notifyClose(this);
            this.observer = null;
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public void mark(int n) {
        this.in.mark(n);
        this.marklength = this.length;
    }

    public int read() throws IOException {
        if (this.length > 0) {
            --this.length;
            if (this.length <= 0) {
                if (this.observer != null) {
                    this.observer.notifyEOF(this);
                }
                this.observer = null;
            }
            return this.in.read();
        }
        if (this.observer != null) {
            this.observer.notifyEOF(this);
            this.observer = null;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.length <= 0) {
            if (this.observer != null) {
                this.observer.notifyEOF(this);
            }
            this.observer = null;
            return -1;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if ((n2 = this.in.read(byArray, n, n2)) == -1) {
            this.length = -1;
            if (this.observer != null) {
                this.observer.notifyFailure(this);
            }
            this.observer = null;
            throw new IOException("Size not matching");
        }
        this.length -= n2;
        if (this.length <= 0) {
            if (this.observer != null) {
                this.observer.notifyEOF(this);
            }
            this.observer = null;
        }
        return n2;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.length = this.marklength;
    }

    public long skip(long l) throws IOException {
        int n = (int)l;
        if (n > this.length) {
            n = this.length;
        }
        n = (int)this.in.skip(n);
        this.length -= n;
        return n;
    }
}

