/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.EmptyDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDescrReader
extends HandlerBase
implements JigXML {
    Parser parser = null;
    ResourceDescription[] resources = null;
    Reader reader = null;
    Stack resourceSetStack = null;
    Stack resourceStack = null;
    Stack defsStack = null;
    Stack classes = null;
    Stack interfaces = null;
    Stack FAStack = null;
    Vector children = null;
    SimpleAttribute currentS = null;
    ArrayAttribute currentA = null;
    int length = -1;
    boolean isavalue = false;
    String[] array = null;
    int arrayidx = -1;

    public XMLDescrReader(Reader reader, Parser parser) {
        this.reader = reader;
        this.parser = parser;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.currentS != null) {
            AttributeDescription attributeDescription = null;
            attributeDescription = string.equals("@@NULL@@") ? new AttributeDescription(this.currentS, null) : new AttributeDescription(this.currentS, this.currentS.unpickle(string));
            Vector vector = (Vector)this.defsStack.peek();
            vector.addElement(attributeDescription);
        } else if (this.isavalue) {
            this.array[this.arrayidx++] = string;
        }
    }

    public void endDocument() throws SAXException {
        Vector vector = (Vector)this.resourceSetStack.pop();
        this.resources = new ResourceDescription[vector.size()];
        vector.copyInto(this.resources);
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("resource")) {
            ResourceDescription resourceDescription = (ResourceDescription)this.resourceStack.pop();
            resourceDescription.setAttributeDescriptions((Vector)this.defsStack.pop());
            Vector vector = (Vector)this.resourceSetStack.peek();
            vector.addElement(resourceDescription);
            Vector vector2 = (Vector)this.classes.pop();
            resourceDescription.setClassHierarchy(vector2);
            Vector vector3 = (Vector)this.interfaces.pop();
            resourceDescription.setInterfaces(vector3);
        } else if (string.equals("children")) {
            ResourceDescription resourceDescription = (ResourceDescription)this.resourceStack.peek();
            resourceDescription.setChildren(this.array);
        } else if (string.equals("description")) {
            ResourceDescription resourceDescription = (ResourceDescription)this.resourceStack.pop();
            Vector vector = (Vector)this.resourceSetStack.peek();
            vector.addElement(resourceDescription);
        } else if (string.equals("attribute")) {
            this.currentS = null;
        } else if (string.equals("array")) {
            AttributeDescription attributeDescription = new AttributeDescription(this.currentA, this.currentA.unpickle(this.array));
            Vector vector = (Vector)this.defsStack.peek();
            vector.addElement(attributeDescription);
            this.currentA = null;
        } else if (string.equals("resourcearray")) {
            Vector vector = (Vector)this.resourceSetStack.pop();
            Object[] objectArray = new ResourceDescription[vector.size()];
            vector.copyInto(objectArray);
            AttributeDescription attributeDescription = new AttributeDescription((Attribute)this.FAStack.pop(), objectArray);
            Vector vector4 = (Vector)this.defsStack.peek();
            vector4.addElement(attributeDescription);
        } else if (string.equals("child") || string.equals("value")) {
            this.isavalue = false;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("FATAL ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    public ResourceDescription[] readResourceDescriptions() throws IOException, SerializationException {
        this.parser.setDocumentHandler(this);
        this.parser.setErrorHandler(this);
        try {
            this.parser.parse(new InputSource(this.reader));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return new ResourceDescription[0];
        }
        return this.resources;
    }

    public void startDocument() throws SAXException {
        this.defsStack = new Stack();
        this.classes = new Stack();
        this.interfaces = new Stack();
        this.FAStack = new Stack();
        this.resourceStack = new Stack();
        this.resourceSetStack = new Stack();
        this.resourceSetStack.push(new Vector(10));
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("inherit")) {
            Vector vector = (Vector)this.classes.peek();
            vector.addElement(attributeList.getValue("class"));
        } else if (string.equals("implements")) {
            Vector vector = (Vector)this.interfaces.peek();
            vector.addElement(attributeList.getValue("class"));
        } else if (string.equals("children")) {
            this.length = Integer.parseInt(attributeList.getValue("length"));
            this.array = new String[this.length];
            this.arrayidx = 0;
        } else if (string.equals("description")) {
            String string2 = attributeList.getValue("class");
            String string3 = attributeList.getValue("name");
            if (string3.equals("@@NULL@@")) {
                string3 = null;
            }
            this.resourceStack.push(new EmptyDescription(string2, string3));
        } else if (string.equals("resource")) {
            String string4 = attributeList.getValue("class");
            this.resourceStack.push(new ResourceDescription(string4));
            this.defsStack.push(new Vector(10));
            Vector<String> vector = new Vector<String>(8);
            vector.addElement(string4);
            this.classes.push(vector);
            this.interfaces.push(new Vector(8));
        } else if (string.equals("attribute")) {
            String string5 = attributeList.getValue("class");
            try {
                Class<?> clazz = Class.forName(string5);
                this.currentS = (SimpleAttribute)clazz.newInstance();
                this.currentS.setName(attributeList.getValue("name"));
                this.currentS.setFlag(attributeList.getValue("flag"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentS = null;
            }
        } else if (string.equals("array")) {
            String string6 = attributeList.getValue("class");
            try {
                Class<?> clazz = Class.forName(string6);
                this.currentA = (ArrayAttribute)clazz.newInstance();
                this.currentA.setName(attributeList.getValue("name"));
                this.currentA.setFlag(attributeList.getValue("flag"));
                this.length = Integer.parseInt(attributeList.getValue("length"));
                this.array = new String[this.length];
                this.arrayidx = 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentA = null;
            }
        } else if (string.equals("resourcearray")) {
            this.resourceSetStack.push(new Vector(10));
            String string7 = attributeList.getValue("class");
            try {
                Class<?> clazz = Class.forName(string7);
                Attribute attribute = (Attribute)clazz.newInstance();
                attribute.setName(attributeList.getValue("name"));
                this.FAStack.push(attribute);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SAXException("Unable to create an instance of " + string7);
            }
        } else if (string.equals("child") || string.equals("value")) {
            this.isavalue = true;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("WARNING in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }
}

