/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.w3c.jigsaw.http.ClientFactory;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.socket.SocketClient;
import org.w3c.jigsaw.http.socket.SocketClientState;
import org.w3c.jigsaw.http.socket.SocketConnectionProp;
import org.w3c.util.AsyncLRUList;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.ThreadCache;

public class SocketClientFactory
implements ClientFactory,
PropertyMonitoring {
    private static final boolean debug = false;
    private static final boolean debugthread = false;
    public static final int MINSPARE_FREE = 5;
    public static final int MAXSPARE_FREE = 10;
    public static final int MAXSPARE_IDLE = 20;
    public static final int MAXTHREADS = 40;
    public static final int MAXCLIENTS = 32;
    public static final int IDLETO = 10000;
    public static final int AVG_LIGHT = 1;
    public static final int AVG_NORMAL = 2;
    public static final int AVG_HIGH = 3;
    public static final int AVG_DEAD = 4;
    public static final String MINSPARE_FREE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.minFree";
    public static final String MAXSPARE_FREE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxFree";
    public static final String MAXSPARE_IDLE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxIdle";
    public static final String MAXTHREADS_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxThreads";
    public static final String MAXCLIENTS_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxClients";
    public static final String IDLETO_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.idleTimeout";
    public static final String BINDADDR_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.bindAddress";
    int minFree = 0;
    int maxFree = 0;
    int maxIdle = 0;
    int maxClients = 0;
    InetAddress bindAddr = null;
    int count = 0;
    httpd server = null;
    ObservableProperties props = null;
    int busyCount = 0;
    LRUList idleList = null;
    LRUList freeList = null;
    SocketClientState csList = null;
    int idleCount = 0;
    int freeCount = 0;
    int clientCount = 0;
    int clientEstim = 0;
    ThreadCache threadcache = null;
    int loadavg = 1;
    boolean alive = true;

    protected synchronized SocketClientState addClient(boolean bl) {
        SocketClient socketClient;
        SocketClientState socketClientState = this.csList = new SocketClientState(this.csList);
        socketClientState.client = socketClient = new SocketClient(this.server, this, socketClientState);
        ++this.clientCount;
        ++this.clientEstim;
        if (bl) {
            socketClientState.status = 2;
            this.freeList.toHead(socketClientState);
            ++this.freeCount;
        }
        return socketClientState;
    }

    protected boolean clientConnectionFinished(SocketClient socketClient) {
        if (!this.alive) {
            return false;
        }
        SocketClientState socketClientState = socketClient.state;
        switch (socketClientState.status) {
            case 0: {
                this.decrIdleCount();
                this.idleList.remove(socketClientState);
                break;
            }
        }
        if (this.incrFreeCount()) {
            this.freeList.toTail(socketClientState);
            return true;
        }
        return false;
    }

    protected void clientFinished(SocketClient socketClient) {
        SocketClientState socketClientState = socketClient.state;
        if (!this.alive) {
            return;
        }
        switch (socketClientState.status) {
            case 0: {
                this.decrIdleCount();
                this.idleList.remove(socketClientState);
                break;
            }
            default: {
                String string = String.valueOf(String.valueOf(socketClient)) + ": finished with unknown status " + socketClientState.status;
                this.server.errlog(string);
            }
            case 1: 
            case 2: 
        }
        socketClientState.status = 4;
        this.decrClientCount();
    }

    public ServerSocket createServerSocket() throws IOException {
        if (this.bindAddr == null) {
            return new ServerSocket(this.server.getPort(), Math.max(128, this.maxClients));
        }
        return new ServerSocket(this.server.getPort(), Math.max(128, this.maxClients), this.bindAddr);
    }

    private final synchronized void decrClientCount() {
        --this.clientCount;
        this.updateLoadAverage();
    }

    private final synchronized boolean decrFreeCount() {
        if (this.freeCount > 0) {
            --this.freeCount;
            this.updateLoadAverage();
            return true;
        }
        return false;
    }

    private final synchronized boolean decrIdleCount() {
        if (this.idleCount > 0) {
            --this.idleCount;
            this.updateLoadAverage();
            return true;
        }
        return false;
    }

    protected synchronized void deleteClient(SocketClientState socketClientState) {
        if (socketClientState.csprev == null) {
            this.csList = socketClientState.csnext;
        } else if (socketClientState.csnext == null) {
            socketClientState.csprev.csnext = null;
        } else {
            socketClientState.csprev.csnext = socketClientState.csnext;
            socketClientState.csnext.csprev = socketClientState.csprev;
        }
    }

    public void handleConnection(Socket socket) {
        SocketClientState socketClientState = null;
        switch (this.loadavg) {
            case 1: {
                if (!this.decrFreeCount()) break;
                socketClientState = (SocketClientState)this.freeList.removeTail();
                break;
            }
            case 2: 
            case 3: {
                this.killSomeClients();
                if (!this.decrFreeCount()) break;
                socketClientState = (SocketClientState)this.freeList.removeTail();
                break;
            }
        }
        if (socketClientState != null) {
            socketClientState.status = 1;
            socketClientState.client.bind(socket);
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            this.server.errlog(String.valueOf(String.valueOf(socket.getInetAddress())) + " refused (overloaded).");
        }
    }

    private final synchronized void incrClientCount() {
        ++this.clientCount;
        ++this.clientEstim;
        this.updateLoadAverage();
    }

    private final synchronized boolean incrFreeCount() {
        if (this.clientEstim > this.maxClients) {
            --this.clientEstim;
            return false;
        }
        ++this.freeCount;
        this.updateLoadAverage();
        return true;
    }

    private final synchronized boolean incrIdleCount() {
        if (this.loadavg > 3 || this.idleCount + 1 >= this.maxIdle) {
            return false;
        }
        ++this.idleCount;
        this.updateLoadAverage();
        return true;
    }

    public void initialize(httpd httpd2) {
        this.server = httpd2;
        this.props = httpd2.getProperties();
        this.props.registerObserver(this);
        SocketConnectionProp socketConnectionProp = new SocketConnectionProp("SocketConnectionProp", httpd2);
        httpd2.registerPropertySet(socketConnectionProp);
        this.minFree = this.props.getInteger(MINSPARE_FREE_P, 5);
        this.maxFree = this.props.getInteger(MAXSPARE_FREE_P, 10);
        this.maxIdle = this.props.getInteger(MAXSPARE_IDLE_P, 20);
        this.maxClients = this.props.getInteger(MAXCLIENTS_P, 32);
        String string = this.props.getString(BINDADDR_P, null);
        if (string != null) {
            try {
                this.bindAddr = InetAddress.getByName(string);
            }
            catch (Exception exception) {}
        }
        this.idleList = new AsyncLRUList();
        this.freeList = new AsyncLRUList();
        this.csList = new SocketClientState();
        int n = 0;
        while (n < this.maxClients) {
            if (this.addClient(true) == null) {
                throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[construstructor]" + ": unable to create clients.");
            }
            ++n;
        }
        this.threadcache = new ThreadCache("socket-clients");
        this.threadcache.setCachesize(this.props.getInteger(MAXTHREADS_P, 40));
        this.threadcache.setThreadPriority(httpd2.getClientThreadPriority());
        this.threadcache.setIdleTimeout(this.props.getInteger(IDLETO_P, 10000));
        this.threadcache.setGrowAsNeeded(true);
        this.threadcache.initialize();
    }

    protected synchronized void killClients(boolean bl) {
        this.alive = false;
        SocketClientState socketClientState = this.csList;
        while (socketClientState != null && socketClientState.client != null) {
            socketClientState.client.kill(socketClientState.status == 0);
            socketClientState = socketClientState.csnext;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {}
        socketClientState = this.csList;
        while (socketClientState != null && socketClientState.client != null) {
            socketClientState.client.kill(true);
            socketClientState = socketClientState.csnext;
        }
    }

    protected final void killSomeClients() {
        this.killSomeClients(-1);
    }

    protected void killSomeClients(int n) {
        int n2 = n > 0 ? n : this.maxFree - this.freeCount;
        while (--n2 >= 0) {
            SocketClientState socketClientState = (SocketClientState)this.idleList.removeTail();
            if (socketClientState == null) break;
            this.decrIdleCount();
            socketClientState.status = 3;
            socketClientState.client.unbind();
        }
    }

    protected boolean notifyIdle(SocketClient socketClient) {
        SocketClientState socketClientState = socketClient.state;
        if (this.alive) {
            if (this.incrIdleCount()) {
                this.idleList.toHead(socketClientState);
                socketClientState.status = 0;
                return true;
            }
            int n = this.maxFree - this.minFree >> 1;
            this.killSomeClients(n > 0 ? n : 1);
            if (this.incrIdleCount()) {
                this.idleList.toHead(socketClientState);
                socketClientState.status = 0;
                return true;
            }
            return false;
        }
        int n = this.maxFree - this.minFree >> 1;
        this.killSomeClients(n > 0 ? n : 1);
        return false;
    }

    protected void notifyUse(SocketClient socketClient) {
        SocketClientState socketClientState = socketClient.state;
        this.decrIdleCount();
        this.idleList.remove(socketClientState);
        socketClientState.status = 1;
    }

    public boolean propertyChanged(String string) {
        block4: {
            block9: {
                int n;
                block10: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        httpd httpd2 = this.server;
                                        if (!string.equals(MINSPARE_FREE_P)) break block3;
                                        this.minFree = this.props.getInteger(MINSPARE_FREE_P, this.minFree);
                                        break block4;
                                    }
                                    if (!string.equals(MAXSPARE_FREE_P)) break block5;
                                    this.maxFree = this.props.getInteger(MAXSPARE_FREE_P, this.maxFree);
                                    break block4;
                                }
                                if (!string.equals(MAXSPARE_IDLE_P)) break block6;
                                this.maxIdle = this.props.getInteger(MAXSPARE_IDLE_P, this.maxIdle);
                                break block4;
                            }
                            if (!string.equals(MAXTHREADS_P)) break block7;
                            int n2 = this.props.getInteger(MAXTHREADS_P, -1);
                            if (n2 <= 0) break block4;
                            this.threadcache.setCachesize(n2);
                            break block4;
                        }
                        if (!string.equals(IDLETO_P)) break block8;
                        int n3 = this.props.getInteger(IDLETO_P, -1);
                        if (n3 <= 0) break block4;
                        this.threadcache.setIdleTimeout(n3);
                        break block4;
                    }
                    if (!string.equals(MAXCLIENTS_P)) break block9;
                    n = this.props.getInteger(MAXCLIENTS_P, -1);
                    if (n <= this.maxClients) break block10;
                    int n4 = this.maxClients - n;
                    while (--n4 >= 0) {
                        this.addClient(true);
                    }
                    break block4;
                }
                if (n <= 0) break block4;
                this.maxClients = n;
                break block4;
            }
            if (!string.equals(BINDADDR_P)) break block4;
            try {
                this.bindAddr = InetAddress.getByName(this.props.getString(BINDADDR_P, null));
            }
            catch (Exception exception) {}
        }
        return true;
    }

    protected void run(SocketClient socketClient) {
        boolean bl = this.threadcache.getThread(socketClient, true);
    }

    public void shutdown(boolean bl) {
        this.killClients(bl);
        SocketClientState socketClientState = this.csList;
        while (socketClientState != null && socketClientState.client != null) {
            socketClientState.client.join();
            socketClientState = socketClientState.csnext;
        }
        this.props.unregisterObserver(this);
        this.props = null;
        this.csList = null;
        this.freeList = null;
        this.idleList = null;
        this.server = null;
    }

    private final void updateLoadAverage() {
        int n = this.loadavg;
        if (this.freeCount >= this.maxFree) {
            this.loadavg = 1;
        } else if (this.freeCount >= this.minFree || this.idleCount >= this.maxIdle) {
            this.loadavg = 2;
            if (2 < n) {
                this.server.thread.setPriority(10);
            }
        } else if (this.freeCount > 0) {
            this.loadavg = 3;
            if (3 > n) {
                this.server.thread.setPriority(this.server.getClientThreadPriority() - 2);
            }
        } else {
            this.loadavg = 4;
        }
    }
}

