/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.util.Vector;
import org.w3c.jigsaw.http.ShuffleHandler;
import org.w3c.jigsaw.http.ShuffleMessage;
import org.w3c.jigsaw.http.Shuffler;

class ShufflerThread
extends Thread {
    private static final boolean debug = true;
    Shuffler s;
    Vector q;

    ShufflerThread(Shuffler shuffler) {
        this.s = shuffler;
        this.q = new Vector();
        this.setPriority(9);
        this.setName("ShufflerThread");
        this.setDaemon(true);
    }

    synchronized void processMessage(ShuffleMessage shuffleMessage) {
        int n = shuffleMessage.id;
        int n2 = 0;
        while (n2 < this.q.size()) {
            ShuffleHandler shuffleHandler = (ShuffleHandler)this.q.elementAt(n2);
            if (shuffleHandler.id == n) {
                this.q.removeElementAt(n2);
                shuffleHandler.done(shuffleMessage.length);
                return;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.q.size()) {
            System.out.println("waiting for : " + this.q.elementAt(n3));
            ++n3;
        }
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + ": received unexpected id " + n);
    }

    synchronized void registerHandler(ShuffleHandler shuffleHandler) {
        this.q.addElement(shuffleHandler);
        this.notifyAll();
    }

    public void run() {
        while (true) {
            this.waitForHandlers();
            ShuffleMessage shuffleMessage = this.s.getNextMessage();
            this.processMessage(shuffleMessage);
        }
    }

    synchronized void waitForHandlers() {
        while (this.q.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

