/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.ShuffleHandler;
import org.w3c.jigsaw.http.ShuffleMessage;
import org.w3c.jigsaw.http.ShufflerThread;

public class Shuffler {
    public static final String SHUFFLER_P = "org.w3c.jigsaw.shuffler";
    private static Process shuffler = null;
    private static boolean inited = false;
    private ShufflerThread waiter = null;
    private int fd = -1;

    public Shuffler(String string) {
        if (!inited && !this.classInitialize(string) || this.initialize(string) < 0) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + ": unable to connect to shuffler " + string);
        }
        this.waiter = new ShufflerThread(this);
        this.waiter.start();
    }

    private synchronized boolean classInitialize(String string) {
        File file = new File(String.valueOf(string) + "/shuffler");
        file.delete();
        Runtime.getRuntime().loadLibrary("Shuffle");
        inited = true;
        String string2 = System.getProperty(SHUFFLER_P);
        if (string2 == null) {
            return false;
        }
        try {
            String[] stringArray = new String[]{string2, String.valueOf(string) + "/shuffler"};
            shuffler = Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[classInitialize]: " + "unable to launch shuffler.");
        }
        int n = 10000;
        while (n > 0 && !file.exists()) {
            n -= 500;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!file.exists()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[classInitialize]: " + " didn't create its socket.");
        }
        return true;
    }

    ShuffleMessage getNextMessage() {
        int n;
        ShuffleMessage shuffleMessage = new ShuffleMessage();
        int n2 = 2;
        while (true) {
            n = this.getNextMessage(shuffleMessage);
            if (n2 < 250) {
                n2 <<= 1;
            }
            if (n > 0) {
                return shuffleMessage;
            }
            if (n == 0) {
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {}
                Thread.yield();
                continue;
            }
            if (n < 0) break;
        }
        String string = String.valueOf(this.getClass().getName()) + "[getNextMessage]: failed (e=" + n + ")";
        throw new RuntimeException(string);
    }

    private native int getNextMessage(ShuffleMessage var1);

    private native int initialize(String var1);

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        Shuffler shuffler = new Shuffler(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream("from");
        FileOutputStream fileOutputStream = new FileOutputStream("to");
        shuffler.shuffle(fileInputStream.getFD(), fileOutputStream.getFD());
        fileInputStream.close();
        fileOutputStream.close();
    }

    private int shuffle(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) throws IOException {
        ShuffleHandler shuffleHandler = new ShuffleHandler(fileDescriptor, fileDescriptor2);
        ShufflerThread shufflerThread = this.waiter;
        synchronized (shufflerThread) {
            shuffleHandler.id = this.shuffle(shuffleHandler);
            if (shuffleHandler.id < 0) {
                throw new IOException(String.valueOf(this.getClass().getName()) + " unable to shuffle !");
            }
            this.waiter.registerHandler(shuffleHandler);
        }
        return shuffleHandler.waitForCompletion();
    }

    public int shuffle(Client client, Reply reply) throws IOException {
        FileDescriptor fileDescriptor = reply.getInputFileDescriptor();
        if (fileDescriptor == null) {
            return -1;
        }
        return -1;
    }

    private synchronized native int shuffle(ShuffleHandler var1);

    public synchronized void shutdown() {
        if (shuffler != null) {
            shuffler.destroy();
            while (true) {
                try {
                    shuffler.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            shuffler = null;
        }
        inited = false;
        this.waiter.stop();
        this.waiter = null;
    }
}

