/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.MimeClientFactory;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.RequestTimeout;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.timers.EventHandler;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeParserFactory;

public abstract class Client
implements EventHandler {
    private static final boolean debuglog = false;
    private static final byte[] hexaTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private Reply contreply = null;
    private MimeParserFactory factory = null;
    protected int identifier = -1;
    protected httpd server = null;
    protected boolean debug = false;
    protected byte[] buffer = null;
    private boolean running = false;
    private short major = (short)-1;
    private short minor = (short)-1;
    private InputStream input = null;
    private DataOutputStream output = null;
    private Object timer = null;
    private MimeParser parser = null;
    private boolean interrupted = false;
    protected int reqcount = 0;
    protected boolean cont = false;
    protected long prev_body_count = 0L;

    protected int chunkTransfer(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[]{48, 13, 10};
        byte[] byArray2 = new byte[]{13, 10};
        byte[] byArray3 = new byte[32];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object var9_8 = null;
        try {
            while ((n3 = inputStream.read(this.buffer)) > 0) {
                int n4 = n3;
                n = 3;
                byArray3[30] = 13;
                byArray3[31] = 10;
                while (n4 > 15) {
                    byArray3[32 - n] = hexaTable[n4 % 16];
                    n4 >>= 4;
                    ++n;
                }
                byArray3[32 - n] = hexaTable[n4];
                this.output.write(byArray3, 32 - n, n);
                this.output.write(this.buffer, 0, n3);
                this.output.write(byArray2, 0, 2);
                this.output.flush();
                n2 += n + n3;
            }
        }
        catch (IOException iOException) {}
        this.output.write(byArray, 0, 3);
        this.output.write(byArray2, 0, 2);
        this.output.flush();
        return n2 + n;
    }

    protected int emitReply(Reply reply) throws IOException {
        boolean bl = false;
        if (reply.getStatus() == 1001) {
            return -1;
        }
        InputStream inputStream = reply.openStream();
        if (inputStream == null) {
            if (this.debug) {
                reply.dump(System.out);
            }
            reply.emit(this.output);
            return -1;
        }
        bl = reply.canChunkTransfer();
        if (this.debug) {
            reply.dump(System.out);
        }
        if (reply.getStatus() != 1000) {
            reply.emit(this.output);
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.getServer().getClientBufferSize()];
        }
        int n = 0;
        if (bl) {
            n = this.chunkTransfer(inputStream);
        } else {
            int n2 = 0;
            while ((n2 = inputStream.read(this.buffer, 0, this.buffer.length)) > 0) {
                this.output.write(this.buffer, 0, n2);
                n += n2;
            }
        }
        inputStream.close();
        return n;
    }

    public final void error(String string) {
        this.server.errlog(this, string);
    }

    public final int getIdentifier() {
        return this.identifier;
    }

    public abstract InetAddress getInetAddress();

    public InputStream getInputStream() {
        return this.input;
    }

    public final short getMajorVersion() {
        return this.major;
    }

    public final short getMinorVersion() {
        return this.minor;
    }

    protected Request getNextRequest() throws ClientException {
        Request request = null;
        this.cont = false;
        try {
            request = (Request)this.parser.parse();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HttpParserException httpParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                httpParserException.printStackTrace();
            }
            throw new ClientException(this, httpParserException);
        }
        catch (MimeParserException mimeParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                mimeParserException.printStackTrace();
            }
            throw new ClientException(this, mimeParserException);
        }
        if (this.debug) {
            request.dump(System.out);
        }
        return request;
    }

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public final int getRequestCount() {
        return this.reqcount;
    }

    public final httpd getServer() {
        return this.server;
    }

    protected abstract Thread getThread();

    public synchronized void handleTimerEvent(Object object, long l) {
        this.timer = null;
        Reply reply = new Reply(this);
        reply.setStatus(408);
        this.interruptConnection(true);
    }

    protected abstract boolean idleConnection();

    protected void initialize(httpd httpd2, int n) {
        this.server = httpd2;
        this.identifier = n;
        this.debug = httpd2.getClientDebug();
        this.factory = new MimeClientFactory(this);
    }

    protected synchronized void interruptConnection(boolean bl) {
        if (this.running) {
            this.interrupted = true;
            if (bl) {
                this.terminate();
            }
        }
    }

    public final boolean isInterrupted() {
        return this.interrupted;
    }

    public final synchronized boolean isRunning() {
        return this.running;
    }

    public void log(Request request, Reply reply, int n, long l) {
        this.server.log(this, request, reply, n, l);
    }

    protected Reply processRequest(Request request) throws ClientException {
        Reply reply = null;
        this.setTimeout(this.server.getRequestTimeOut(), new RequestTimeout(this));
        try {
            reply = (Reply)this.server.perform(request);
        }
        catch (ProtocolException protocolException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                protocolException.printStackTrace();
            }
            if (protocolException.hasReply()) {
                return (Reply)protocolException.getReply();
            }
            throw new ClientException(this, protocolException);
        }
        catch (ResourceException resourceException) {
            throw new ClientException(this, resourceException);
        }
        if (reply == null) {
            String string = "target resource emited a null Reply.";
            throw new ClientException(this, string);
        }
        ++this.reqcount;
        return reply;
    }

    private synchronized void removeTimeout() {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
        }
    }

    public int sendContinue() throws IOException {
        if (this.cont) {
            return -1;
        }
        if (this.major > 1 || this.major == 1 && this.minor >= 1) {
            if (this.contreply == null) {
                this.contreply = new Reply(this, null, this.major, this.minor, 100);
            }
            int n = this.emitReply(this.contreply);
            this.output.flush();
            this.cont = true;
            return n;
        }
        return -1;
    }

    private synchronized void setTimeout(int n, Object object) {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
            this.timer = null;
        }
        this.timer = this.server.timer.registerTimer(n, this, object);
    }

    protected boolean startConnection(InputStream inputStream, DataOutputStream dataOutputStream) throws ClientException {
        block52: {
            Throwable throwable2;
            ClientException clientException;
            Reply reply;
            block51: {
                boolean bl = true;
                long l = 0L;
                long l2 = 0L;
                HttpEntityMessage httpEntityMessage = null;
                reply = null;
                int n = 0;
                int n2 = 0;
                clientException = null;
                this.input = inputStream;
                this.output = dataOutputStream;
                this.parser = new MimeParser(this.input, this.factory);
                try {
                    block48: {
                        Object object;
                        try {
                            this.running = true;
                            while (!this.interrupted && bl) {
                                block49: {
                                    try {
                                        if (this.prev_body_count > 0L) {
                                            this.input.mark(2048);
                                        }
                                        if (n2 == 0) {
                                            httpEntityMessage = this.getNextRequest();
                                            if (httpEntityMessage == null) break block48;
                                            this.major = httpEntityMessage.getMajorVersion();
                                            this.minor = httpEntityMessage.getMinorVersion();
                                            break block49;
                                        }
                                        this.interrupted = this.idleConnection();
                                        if (this.interrupted || (httpEntityMessage = this.getNextRequest()) == null) break block48;
                                        this.usedConnection();
                                    }
                                    catch (ClientException clientException2) {
                                        if (clientException2.ex != null && clientException2.ex instanceof HttpParserException && ((HttpParserException)(object = (HttpParserException)clientException2.ex)).hasRequest()) {
                                            httpEntityMessage = (Request)((HttpParserException)object).getRequest();
                                            if (n2 == 0) {
                                                this.major = httpEntityMessage.getMajorVersion();
                                                this.minor = httpEntityMessage.getMinorVersion();
                                            } else {
                                                this.usedConnection();
                                            }
                                            reply = (Reply)((Request)httpEntityMessage).makeBadRequestReply();
                                            reply.setContentLength(0);
                                            reply.addConnection("close");
                                            if (bl) {
                                                bl = this.tryKeepConnection((Request)httpEntityMessage, reply);
                                            }
                                            n = this.emitReply(reply);
                                            this.log((Request)httpEntityMessage, reply, 0, 0L);
                                            ++n2;
                                            if (bl) {
                                                this.output.flush();
                                            }
                                        }
                                        break;
                                    }
                                    catch (Exception exception) {
                                        if (this.debug) {
                                            exception.printStackTrace();
                                        }
                                        if (exception.getMessage().startsWith("Bad request") && this.prev_body_count > 0L) {
                                            if (this.debug) {
                                                System.out.println("Error after a body request! (Skipping: " + this.prev_body_count + " bytes)");
                                            }
                                            this.input.reset();
                                            object = new byte[(int)this.prev_body_count];
                                            this.prev_body_count -= (long)this.input.read((byte[])object);
                                            this.prev_body_count -= this.input.skip(this.prev_body_count);
                                            continue;
                                        }
                                        throw exception;
                                    }
                                }
                                l = System.currentTimeMillis();
                                reply = this.processRequest((Request)httpEntityMessage);
                                l2 = System.currentTimeMillis();
                                if (bl) {
                                    bl = this.tryKeepConnection((Request)httpEntityMessage, reply);
                                }
                                n = this.emitReply(reply);
                                if (reply.hasContentLength() && n >= 0 && reply.getContentLength() != n) {
                                    bl = false;
                                }
                                this.prev_body_count = httpEntityMessage.getContentLength();
                                this.log((Request)httpEntityMessage, reply, n, l2 - l);
                                ++n2;
                                if (bl) {
                                    this.output.flush();
                                }
                                if (reply.getStatus() != 101) continue;
                                this.input = null;
                                this.output = null;
                                throw new Exception("Switching");
                            }
                        }
                        catch (IOException iOException) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got IOException:");
                                iOException.printStackTrace();
                            }
                            try {
                                object = null;
                                if (reply != null && (object = reply.openStream()) != null) {
                                    ((InputStream)object).close();
                                }
                            }
                            catch (IOException iOException2) {}
                            clientException = new ClientException(this, iOException);
                        }
                        catch (ClientException clientException3) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got ClientException:");
                                clientException3.printStackTrace();
                            }
                            try {
                                object = null;
                                if (reply != null && (object = reply.openStream()) != null) {
                                    ((InputStream)object).close();
                                }
                            }
                            catch (IOException iOException) {}
                            clientException = clientException3;
                        }
                        catch (Exception exception) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got exception:");
                                exception.printStackTrace();
                            }
                            clientException = new ClientException(this, exception);
                        }
                    }
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    if (clientException != null || httpEntityMessage == null || httpEntityMessage.getContentLength() <= 0 || reply == null || reply.getStatus() == 101 || reply.getStatus() / 100 == 2) break block51;
                    try {
                        InputStream inputStream2 = ((Request)httpEntityMessage).getInputStream();
                        if (inputStream2 != null) {
                            while (inputStream2.available() > 0) {
                                inputStream2.read(this.buffer, 0, this.buffer.length);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                    try {
                        InputStream inputStream3 = ((Request)httpEntityMessage).getInputStream();
                        if (inputStream3 != null) {
                            while (inputStream3.available() > 0) {
                                inputStream3.read(this.buffer, 0, this.buffer.length);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                this.terminate();
                if (reply != null) {
                    if (reply.getStatus() != 101) {
                        this.stopConnection();
                    }
                } else {
                    this.stopConnection();
                }
                if (clientException != null) {
                    throw clientException;
                }
                break block52;
            }
            this.terminate();
            if (reply != null) {
                if (reply.getStatus() != 101) {
                    this.stopConnection();
                }
            } else {
                this.stopConnection();
            }
            if (clientException != null) {
                throw clientException;
            }
            throw throwable2;
        }
        return this.interrupted;
    }

    protected abstract void stopConnection();

    private synchronized void terminate() {
        if (!this.running) {
            return;
        }
        this.removeTimeout();
        try {
            if (this.output != null) {
                this.output.flush();
                this.output.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {}
        this.input = null;
        this.output = null;
        this.parser = null;
        this.major = (short)-1;
        this.minor = (short)-1;
        this.interrupted = false;
        this.running = false;
    }

    public final void trace(String string) {
        this.server.trace(this, string);
    }

    protected boolean tryKeepConnection(Request request, Reply reply) {
        if (!this.server.getClientKeepConnection()) {
            return false;
        }
        return request.canKeepConnection() && reply.tryKeepConnection();
    }

    protected abstract void usedConnection();
}

