/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.jigsaw.frames.EncodingAttribute;
import org.w3c.jigsaw.frames.LanguageAttribute;
import org.w3c.jigsaw.frames.MimeTypeAttribute;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.html.HtmlLink;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.crypt.Md5;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.DoubleAttribute;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ProtocolFrame;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.tools.sorter.Sorter;
import org.w3c.www.http.ByteRangeOutputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpContentRange;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeType;

public class HTTPFrame
extends ProtocolFrame {
    public static final String STATE_CONTENT_LOCATION = "org.w3c.jigsaw.frames.HTTPFrame.cl";
    private static final boolean debug = true;
    public static final int COND_FAILED = 1;
    public static final int COND_OK = 2;
    protected static HttpTokenList _allowed = null;
    private static HttpTokenList _put_allowed = null;
    private static HttpTokenList _browse_allowed = null;
    private static HttpTokenList _accept_ranges = null;
    protected HttpTokenList allowed = _allowed;
    protected static int ATTR_QUALITY;
    protected static int ATTR_TITLE;
    protected static int ATTR_CONTENT_LANGUAGE;
    protected static int ATTR_CONTENT_ENCODING;
    protected static int ATTR_CONTENT_TYPE;
    protected static int ATTR_CHARSET;
    protected static int ATTR_CONTENT_LENGTH;
    protected static int ATTR_ICON;
    protected static int ATTR_MAXAGE;
    protected static int ATTR_MD5;
    protected static int ATTR_ALLOW_DEL;
    protected static int ATTR_PUTABLE;
    protected static int ATTR_RELOCATE;
    protected static int ATTR_INDEX;
    protected static int ATTR_INDEXES;
    protected static int ATTR_ICONDIR;
    protected static int ATTR_BROWSABLE;
    protected static int ATTR_STYLE_LINK;
    protected DirectoryResource dresource = null;
    protected FileResource fresource = null;
    HttpMimeType contenttype = null;
    HttpInteger contentlength = null;
    HttpDate lastmodified = null;
    HttpTokenList contentencoding = null;
    HttpTokenList contentlanguage = null;
    HttpEntityTag etag = null;
    HttpString md5Digest = null;
    protected boolean acceptRanges = false;
    protected HtmlGenerator listing = null;
    protected long listing_stamp = -1L;
    protected static MimeType browsetype;

    static {
        Object object = new String[]{"GET", "HEAD", "OPTIONS", "TRACE"};
        _allowed = HttpFactory.makeStringList(object);
        Object object2 = new String[]{"HEAD", "GET", "PUT", "OPTIONS", "TRACE"};
        _put_allowed = HttpFactory.makeStringList(object2);
        String[] stringArray = new String[]{"HEAD", "GET", "BROWSE", "OPTIONS", "TRACE"};
        _browse_allowed = HttpFactory.makeStringList(object2);
        String[] stringArray2 = new String[]{"bytes"};
        _accept_ranges = HttpFactory.makeStringList(stringArray2);
        ATTR_QUALITY = -1;
        ATTR_TITLE = -1;
        ATTR_CONTENT_LANGUAGE = -1;
        ATTR_CONTENT_ENCODING = -1;
        ATTR_CONTENT_TYPE = -1;
        ATTR_CHARSET = -1;
        ATTR_CONTENT_LENGTH = -1;
        ATTR_ICON = -1;
        ATTR_MAXAGE = -1;
        ATTR_MD5 = -1;
        ATTR_ALLOW_DEL = -1;
        ATTR_PUTABLE = -1;
        ATTR_RELOCATE = -1;
        ATTR_INDEX = -1;
        ATTR_INDEXES = -1;
        ATTR_ICONDIR = -1;
        ATTR_BROWSABLE = -1;
        ATTR_STYLE_LINK = -1;
        object = null;
        object2 = null;
        try {
            object2 = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        object = new DoubleAttribute("quality", new Double(1.0), 2);
        ATTR_QUALITY = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("title", null, 2);
        ATTR_TITLE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new LanguageAttribute("content-language", null, 2);
        ATTR_CONTENT_LANGUAGE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new EncodingAttribute("content-encoding", null, 2);
        ATTR_CONTENT_ENCODING = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new MimeTypeAttribute("content-type", null, 2);
        ATTR_CONTENT_TYPE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("charset", null, 2);
        ATTR_CHARSET = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new IntegerAttribute("content-length", null, 1);
        ATTR_CONTENT_LENGTH = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("icon", null, 2);
        ATTR_ICON = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new LongAttribute("maxage", null, 2);
        ATTR_MAXAGE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("send-md5", Boolean.FALSE, 2);
        ATTR_MD5 = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("allow-delete", Boolean.FALSE, 2);
        ATTR_ALLOW_DEL = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("putable", Boolean.FALSE, 2);
        ATTR_PUTABLE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("relocate", Boolean.TRUE, 2);
        ATTR_RELOCATE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("index", null, 2);
        ATTR_INDEX = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringArrayAttribute("indexes", null, 2);
        ATTR_INDEXES = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("icondir", null, 2);
        ATTR_ICONDIR = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("browsable", Boolean.FALSE, 2);
        ATTR_BROWSABLE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new StringAttribute("style-sheet-link", null, 2);
        ATTR_STYLE_LINK = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        browsetype = null;
    }

    public void addStyleSheet(HtmlGenerator htmlGenerator) {
        String string = this.getStyleSheetURL();
        if (string != null) {
            htmlGenerator.addLink(new HtmlLink("STYLESHEET", string));
        }
    }

    public void attributeChanged(AttributeChangedEvent attributeChangedEvent) {
        super.attributeChanged(attributeChangedEvent);
        String string = attributeChangedEvent.getAttribute().getName();
        if (string.equals("file-stamp")) {
            this.etag = null;
            this.lastmodified = null;
            this.md5Digest = null;
        } else if (string.equals("file-length")) {
            this.setValue(ATTR_CONTENT_LENGTH, attributeChangedEvent.getNewValue());
        } else if (string.equals("last-modified")) {
            this.setValue(Resource.ATTR_LAST_MODIFIED, attributeChangedEvent.getNewValue());
        } else {
            this.lastmodified = null;
        }
    }

    public Reply browse(Request request) throws ProtocolException {
        Object object;
        if (this.dresource == null) {
            Reply reply = request.makeReply(501);
            reply.setContent("Method " + request.getMethod() + " not implemented.");
            throw new HTTPException(reply);
        }
        Enumeration enumeration = this.dresource.enumerateResourceIdentifiers();
        Vector vector = Sorter.sortStringEnumeration(enumeration);
        int n = vector == null ? 0 : vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Object var11_11;
                object = (String)vector.elementAt(n2);
                ResourceReference resourceReference = null;
                Resource resource = null;
                try {
                    block7: {
                        try {
                            resourceReference = this.dresource.lookup((String)object);
                            resource = resourceReference.lock();
                            if (resource instanceof DirectoryResource) {
                                stringBuffer.append("application/x-navidir " + (String)object + "\r\n");
                                break block7;
                            }
                            HTTPFrame hTTPFrame = (HTTPFrame)this.resource.getFrame(this.getClass());
                            if (hTTPFrame == null) break block7;
                            stringBuffer.append(String.valueOf(hTTPFrame.getContentType().toString()) + " " + (String)object + "\r\n");
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            var11_11 = null;
                            resourceReference.unlock();
                            break block8;
                        }
                    }
                    var11_11 = null;
                    resourceReference.unlock();
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
            }
            ++n2;
        }
        object = request.makeReply(200);
        ((HttpMessage)object).addPragma("no-cache");
        ((HttpMessage)object).setNoCache();
        ((Reply)object).setContent(stringBuffer.toString());
        ((HttpEntityMessage)object).setContentType(this.getBrowseType());
        return object;
    }

    public int checkIfMatch(Request request) {
        HttpEntityTag[] httpEntityTagArray;
        if (this.fresource != null && (httpEntityTagArray = request.getIfMatch()) != null) {
            if (this.etag != null) {
                int n = 0;
                while (n < httpEntityTagArray.length) {
                    HttpEntityTag httpEntityTag = httpEntityTagArray[n];
                    if (!httpEntityTag.isWeak() && httpEntityTag.getTag().equals(this.etag.getTag())) {
                        return 2;
                    }
                    ++n;
                }
            }
            return 1;
        }
        return 0;
    }

    public int checkIfModifiedSince(Request request) {
        long l = request.getIfModifiedSince();
        if (this.dresource != null) {
            if (l >= 0L) {
                return this.listing_stamp > 0L && this.listing_stamp - 1000L <= l ? 1 : 2;
            }
        } else if (this.fresource != null) {
            long l2 = this.getLastModified();
            if (l >= 0L) {
                return l2 > 0L && l2 - 1000L <= l ? 1 : 2;
            }
        }
        return 0;
    }

    public int checkIfNoneMatch(Request request) {
        HttpEntityTag[] httpEntityTagArray;
        if (this.fresource != null && (httpEntityTagArray = request.getIfNoneMatch()) != null) {
            if (this.etag == null) {
                return 2;
            }
            int n = 0;
            while (n < httpEntityTagArray.length) {
                HttpEntityTag httpEntityTag = httpEntityTagArray[n];
                if (!httpEntityTag.isWeak() && httpEntityTag.getTag().equals(this.etag.getTag())) {
                    return 1;
                }
                ++n;
            }
            return 2;
        }
        return 0;
    }

    public int checkIfUnmodifiedSince(Request request) {
        if (this.fresource != null) {
            long l = request.getIfUnmodifiedSince();
            long l2 = this.getLastModified();
            if (l >= 0L) {
                return l2 > 0L && l2 - 1000L >= l ? 1 : 2;
            }
        }
        return 0;
    }

    public boolean checkRequest(RequestInterface requestInterface) {
        return requestInterface == null ? true : requestInterface instanceof Request;
    }

    public synchronized boolean computeContainerListing(boolean bl) {
        block22: {
            ContainerResource containerResource = (ContainerResource)this.resource;
            if (!bl && this.listing != null && containerResource.getLastModified() <= this.listing_stamp && this.getLastModified() <= this.listing_stamp) break block22;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            Enumeration enumeration = containerResource.enumerateResourceIdentifiers();
            Vector vector = Sorter.sortStringEnumeration(enumeration);
            HtmlGenerator htmlGenerator = new HtmlGenerator("Index of " + containerResource.getIdentifier());
            this.addStyleSheet(htmlGenerator);
            htmlGenerator.append("<h1>" + containerResource.getIdentifier() + "</h1>");
            if (containerResource.getParent() != null) {
                htmlGenerator.append("<p><a href=\"..\">Parent</a><br>");
            }
            int n = 0;
            while (n < vector.size()) {
                block21: {
                    String string = (String)vector.elementAt(n);
                    ResourceReference resourceReference = null;
                    long l = -1L;
                    resourceReference = containerResource.lookup(string);
                    FramedResource framedResource = null;
                    if (resourceReference != null) {
                        Object var14_12;
                        try {
                            try {
                                FramedResource framedResource2;
                                framedResource = (FramedResource)resourceReference.lock();
                                if (framedResource instanceof FileResource) {
                                    framedResource2 = (FileResource)framedResource;
                                    if (!((FileResource)framedResource2).getFile().exists()) {
                                        try {
                                            framedResource2.delete();
                                        }
                                        catch (MultipleLockException multipleLockException) {
                                        }
                                        var14_12 = null;
                                        resourceReference.unlock();
                                        break block21;
                                    }
                                    l = ((FileResource)framedResource2).getFile().length();
                                }
                                framedResource2 = null;
                                if (clazz != null) {
                                    framedResource2 = (HTTPFrame)framedResource.getFrame(clazz);
                                }
                                if (framedResource2 != null) {
                                    String string2 = ((HTTPFrame)framedResource2).getIcon();
                                    if (string2 != null) {
                                        htmlGenerator.append("<img src=\"" + this.getIconDirectory() + "/" + string2 + "\" alt=\"" + string2 + "\">");
                                    }
                                    if (framedResource instanceof ContainerInterface) {
                                        htmlGenerator.append("<a href=\"", URLEncoder.encode(string), "/\">" + string + "</a>");
                                    } else {
                                        htmlGenerator.append("<a href=\"", URLEncoder.encode(string), "\">" + string + "</a>");
                                    }
                                    String string3 = ((HTTPFrame)framedResource2).getTitle();
                                    if (string3 != null) {
                                        htmlGenerator.append(" " + string3);
                                    }
                                    if (l != -1L) {
                                        String string4 = null;
                                        string4 = l > 1023L ? " [" + l / 1024L + " Kb]" : " [" + l + " bytes]";
                                        htmlGenerator.append(string4);
                                    }
                                    htmlGenerator.append("<br>\n");
                                } else {
                                    htmlGenerator.append(String.valueOf(string) + " (<i>Not available via HTTP.</i>)");
                                    htmlGenerator.append("<br>\n");
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                htmlGenerator.append(String.valueOf(string) + " cannot be loaded (server misconfigured)");
                                htmlGenerator.append("<br>\n");
                                var14_12 = null;
                                resourceReference.unlock();
                            }
                        }
                        catch (Throwable throwable) {
                            var14_12 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                        var14_12 = null;
                        resourceReference.unlock();
                    }
                }
                ++n;
            }
            htmlGenerator.close();
            this.listing_stamp = this.getLastModified();
            this.listing = htmlGenerator;
            return true;
        }
        return false;
    }

    protected File computeTrashDir(File file) {
        return this.computeTrashFile(file);
    }

    protected File computeTrashFile(File file) {
        String string = this.getServer().getTrashDirectory();
        String string2 = file.getName();
        File file2 = new File(string, string2);
        int n = 1;
        while (file2.exists()) {
            file2 = new File(string, String.valueOf(string2) + "." + n);
            ++n;
        }
        return file2;
    }

    public Reply createDefaultReply(Request request, int n) {
        long l;
        Reply reply = request.makeReply(n);
        this.updateCachedHeaders();
        if (n != 304) {
            if (this.contentlength != null) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_LENGTH, (HeaderValue)this.contentlength);
            }
            if (this.contenttype != null) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)this.contenttype);
            }
            if (this.lastmodified != null) {
                reply.setHeaderValue(HttpEntityMessage.H_LAST_MODIFIED, (HeaderValue)this.lastmodified);
            }
            if (this.contentencoding != null) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_ENCODING, (HeaderValue)this.contentencoding);
            }
            if (this.contentlanguage != null) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_LANGUAGE, (HeaderValue)this.contentlanguage);
            }
        }
        if ((l = this.getMaxAge()) >= 0L && reply.getMajorVersion() >= 1) {
            if (reply.getMinorVersion() >= 1) {
                reply.setMaxAge((int)(l / 1000L));
            }
            long l2 = System.currentTimeMillis() + (l == 0L ? -1000L : l);
            reply.setExpires(l2);
        }
        reply.setDate(System.currentTimeMillis() / 1000L * 1000L);
        if (this.fresource != null) {
            if (this.getETag() != null) {
                reply.setETag(this.etag);
            }
            if (this.acceptRanges) {
                reply.setHeaderValue(HttpReplyMessage.H_ACCEPT_RANGES, (HeaderValue)_accept_ranges);
            }
            if (this.getMD5Flag()) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_MD5, (HeaderValue)this.getMd5Digest());
            }
        }
        return reply;
    }

    protected Reply createFileReply(Request request) throws ProtocolException, ResourceException {
        Reply reply;
        File file = this.fresource.getFile();
        Reply reply2 = null;
        HttpRange[] httpRangeArray = request.getRange();
        if (httpRangeArray != null && httpRangeArray.length == 1 && (reply = this.handleRangeRequest(request, httpRangeArray[0])) != null) {
            return reply;
        }
        reply2 = this.createDefaultReply(request, 200);
        try {
            reply2.setStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            Reply reply3 = request.makeReply(503);
            reply3.setContent(iOException.getMessage());
            return reply3;
        }
        return reply2;
    }

    public Reply delete(Request request) throws ProtocolException, ResourceException {
        if (this.getAllowDeleteFlag()) {
            if (this.dresource != null) {
                return this.deleteDirectoryResource(request);
            }
            if (this.fresource != null) {
                return this.deleteFileResource(request);
            }
            return this.deleteOtherResource(request);
        }
        Reply reply = request.makeReply(405);
        reply.setContent("Method DELETE not allowed.");
        throw new HTTPException(reply);
    }

    protected Reply deleteDirectoryResource(Request request) throws ProtocolException, ResourceException {
        File file = this.dresource.getDirectory();
        try {
            this.dresource.delete();
        }
        catch (MultipleLockException multipleLockException) {
            Reply reply = request.makeReply(403);
            reply.setContent("Can't delete resource: " + this.resource.getIdentifier() + " is locked. Try again later.");
            throw new HTTPException(reply);
        }
        File file2 = this.computeTrashDir(file);
        file.renameTo(file2);
        return request.makeReply(204);
    }

    protected Reply deleteFileResource(Request request) throws ProtocolException, ResourceException {
        File file = this.fresource.getFile();
        try {
            this.fresource.delete();
        }
        catch (MultipleLockException multipleLockException) {
            Reply reply = request.makeReply(403);
            reply.setContent("Can't delete resource: " + this.resource.getIdentifier() + " is locked. Try again later.");
            throw new HTTPException(reply);
        }
        File file2 = this.computeTrashFile(file);
        file.renameTo(file2);
        return request.makeReply(204);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Reply deleteMe(Request request) throws HTTPException {
        Object object;
        boolean bl = false;
        ResourceReference resourceReference = this.fresource.getParent();
        ResourceReference resourceReference2 = null;
        Resource resource = null;
        while (true) {
            Object var7_6;
            block13: {
                block12: {
                    try {
                        try {
                            if (resourceReference == null) {
                                var7_6 = null;
                                if (resourceReference == null) break;
                                resourceReference.unlock();
                                break;
                            }
                            resource = resourceReference.lock();
                            if (resource instanceof DirectoryResource) {
                                bl = ((DirectoryResource)resource).getExtensibleFlag();
                                break block12;
                            }
                            resourceReference2 = resource.getParent();
                            break block13;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            var7_6 = null;
                            if (resourceReference == null) break;
                            resourceReference.unlock();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        if (resourceReference != null) {
                            resourceReference.unlock();
                        }
                        throw throwable;
                    }
                }
                var7_6 = null;
                if (resourceReference == null) break;
                resourceReference.unlock();
                break;
            }
            var7_6 = null;
            if (resourceReference != null) {
                resourceReference.unlock();
            }
            resourceReference = resourceReference2;
        }
        if (bl) {
            object = String.valueOf(String.valueOf(this.fresource.getFile())) + ": deleted, removing the FileResource.";
            this.getServer().errlog(this.fresource, (String)object);
            try {
                this.fresource.delete();
            }
            catch (MultipleLockException multipleLockException) {
                Reply reply = request.makeReply(404);
                reply.setContentMD5(null);
                reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " is indexed but not available." + "<p>" + multipleLockException.getMessage() + "<p>The server is misconfigured.");
                throw new HTTPException(reply);
            }
        }
        object = request.makeReply(404);
        ((HttpEntityMessage)object).setContentMD5(null);
        ((Reply)object).setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " is indexed but not available." + "<p>The server is misconfigured.");
        return object;
    }

    protected Reply deleteOtherResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method DELETE not implemented.");
        throw new HTTPException(reply);
    }

    public Reply extended(Request request) throws ProtocolException, ResourceException {
        String string = request.getMethod();
        Reply reply = request.makeReply(501);
        reply.setContent("Method " + string + " not implemented.");
        throw new HTTPException(reply);
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        if (this.dresource != null) {
            return this.getDirectoryResource(request);
        }
        if (this.fresource != null) {
            return this.getFileResource(request);
        }
        return this.getOtherResource(request);
    }

    public boolean getAllowDeleteFlag() {
        return this.getBoolean(ATTR_ALLOW_DEL, false);
    }

    public boolean getBrowsableFlag() {
        return this.getBoolean(ATTR_BROWSABLE, false);
    }

    protected synchronized MimeType getBrowseType() {
        block2: {
            if (browsetype != null) break block2;
            try {
                browsetype = new MimeType("application/x-navibrowse");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return browsetype;
    }

    public String getCharset() {
        return (String)this.getValue(ATTR_CHARSET, null);
    }

    public String getContentEncoding() {
        String string = (String)this.attributes[ATTR_CONTENT_ENCODING].getDefault();
        String string2 = this.getString(ATTR_CONTENT_ENCODING, string);
        return this.getString(ATTR_CONTENT_ENCODING, string);
    }

    public String getContentLanguage() {
        return (String)this.getValue(ATTR_CONTENT_LANGUAGE, null);
    }

    public int getContentLength() {
        return this.getInt(ATTR_CONTENT_LENGTH, -1);
    }

    public MimeType getContentType() {
        return (MimeType)this.getValue(ATTR_CONTENT_TYPE, null);
    }

    public synchronized Reply getDirectoryListing(Request request) throws ProtocolException, ResourceException {
        if (!(this.resource instanceof ContainerResource)) {
            throw new ResourceException("this frame is not attached to a ContainerResource. (" + this.resource.getIdentifier() + ")");
        }
        boolean bl = false;
        if (this.dresource != null) {
            if (!this.dresource.getDirectory().exists()) {
                String string = String.valueOf(this.dresource.getIdentifier()) + ": deleted, removing the DirectoryResource";
                this.getServer().errlog(this.dresource, string);
                try {
                    this.dresource.delete();
                }
                catch (MultipleLockException multipleLockException) {}
                Reply reply = request.makeReply(404);
                reply.setContent("<h1>Document not found</h1><p>The document " + request.getURL() + " is indexed but not available." + "<p>The server is misconfigured.");
                throw new HTTPException(reply);
            }
            boolean bl2 = bl = this.dresource.getDirectory().lastModified() > this.listing_stamp;
        }
        if (!this.computeContainerListing(bl) && this.checkIfModifiedSince(request) == 1) {
            Reply reply = this.createDefaultReply(request, 304);
            reply.setContentMD5(null);
            return reply;
        }
        Reply reply = this.createDefaultReply(request, 200);
        reply.setLastModified(this.listing_stamp);
        reply.setStream(this.listing);
        return reply;
    }

    public DirectoryResource getDirectoryResource() {
        return this.dresource;
    }

    protected Reply getDirectoryResource(Request request) throws ProtocolException, ResourceException {
        String string = this.getIndex();
        if (string != null && string.length() > 0 && string.equals("*forbid*")) {
            Reply reply = request.makeReply(403);
            reply.setContent("<h1>Forbidden</h1>The directory resource " + request.getURL() + " cannot be browsed");
            return reply;
        }
        return this.getDirectoryListing(request);
    }

    public HttpEntityTag getETag() {
        if (this.etag == null) {
            long l;
            String string = null;
            if (this.fresource != null && (l = this.fresource.getFileStamp()) >= 0L) {
                String string2 = Integer.toString(this.getOid(), 32);
                String string3 = Long.toString(l, 32);
                string = String.valueOf(Integer.toString(this.getOid(), 32)) + ":" + Long.toString(l, 32);
            }
            this.etag = HttpFactory.makeETag(false, string);
        }
        return this.etag;
    }

    public FileResource getFileResource() {
        return this.fresource;
    }

    protected Reply getFileResource(Request request) throws ProtocolException, ResourceException {
        if (this.fresource == null) {
            throw new ResourceException("this frame is not attached to a FileResource. (" + this.resource.getIdentifier() + ")");
        }
        Reply reply = null;
        File file = this.fresource.getFile();
        this.fresource.checkContent();
        this.updateCachedHeaders();
        if (this.checkIfMatch(request) == 1) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfNoneMatch(request) == 1) {
            reply = this.createDefaultReply(request, 304);
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfModifiedSince(request) == 1) {
            reply = this.createDefaultReply(request, 304);
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfUnmodifiedSince(request) == 1) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (file.exists()) {
            reply = this.createFileReply(request);
            if (request.hasState(STATE_CONTENT_LOCATION)) {
                reply.setContentLocation(this.getURL(request).toExternalForm());
            }
            return reply;
        }
        return this.deleteMe(request);
    }

    public String getHelpURL() {
        httpd httpd2 = (httpd)this.getServer();
        if (httpd2 == null) {
            return null;
        }
        String string = httpd2.getDocumentationURL();
        if (string == null) {
            return null;
        }
        return String.valueOf(string) + "/" + this.getClass().getName() + ".html";
    }

    public String getHelpURL(String string) {
        httpd httpd2 = (httpd)this.getServer();
        if (httpd2 == null) {
            return null;
        }
        String string2 = httpd2.getDocumentationURL();
        if (string2 == null) {
            return null;
        }
        Class clazz = AttributeRegistry.getAttributeClass(this.getClass(), string);
        if (clazz != null) {
            return String.valueOf(string2) + "/" + clazz.getName() + ".html";
        }
        return null;
    }

    public String getIcon() {
        return this.getString(ATTR_ICON, null);
    }

    public String getIconDirectory() {
        return this.getString(ATTR_ICONDIR, "/icons");
    }

    public String getIndex() {
        return (String)this.getValue(ATTR_INDEX, null);
    }

    public String[] getIndexes() {
        String string = this.getIndex();
        if (string != null) {
            String[] stringArray = (String[])this.getValue(ATTR_INDEXES, null);
            if (stringArray != null) {
                int n = stringArray.length + 1;
                String[] stringArray2 = new String[n];
                stringArray2[0] = string;
                System.arraycopy(stringArray, 0, stringArray2, 1, n - 1);
                return stringArray2;
            }
            stringArray = new String[]{string};
            return stringArray;
        }
        return (String[])this.getValue(ATTR_INDEXES, null);
    }

    public boolean getMD5Flag() {
        return this.getBoolean(ATTR_MD5, false);
    }

    public long getMaxAge() {
        return this.getLong(ATTR_MAXAGE, -1L);
    }

    private HttpString getMd5Digest() {
        if (this.md5Digest != null) {
            return this.md5Digest;
        }
        FramedResource framedResource = this.getResource();
        if (framedResource instanceof FileResource) {
            try {
                Md5 md5 = new Md5(new FileInputStream(((FileResource)framedResource).getFile()));
                String string = null;
                try {
                    byte[] byArray = md5.getDigest();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Base64Encoder base64Encoder = new Base64Encoder(new ByteArrayInputStream(byArray), byteArrayOutputStream);
                    base64Encoder.process();
                    string = byteArrayOutputStream.toString();
                    this.md5Digest = HttpFactory.makeString(string);
                }
                catch (Exception exception) {
                    this.md5Digest = null;
                }
                return this.md5Digest;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.md5Digest = null;
            }
        }
        return null;
    }

    protected Reply getOtherResource(Request request) throws ProtocolException, ResourceException {
        if (this.resource instanceof ContainerResource) {
            return this.getDirectoryResource(request);
        }
        Reply reply = request.makeReply(501);
        reply.setContent("Method GET not implemented.");
        throw new HTTPException(reply);
    }

    public boolean getPutableFlag() {
        return this.getBoolean(ATTR_PUTABLE, false);
    }

    public double getQuality() {
        return this.getDouble(ATTR_QUALITY, -1.0);
    }

    public boolean getRelocateFlag() {
        return this.getBoolean(ATTR_RELOCATE, true);
    }

    public String getStyleSheetURL() {
        return this.getString(ATTR_STYLE_LINK, null);
    }

    public String getTitle() {
        return this.getString(ATTR_TITLE, null);
    }

    public URL getURL(Request request) {
        try {
            return new URL(request.getURL(), this.resource.getURLPath());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("unable to build " + this.getURLPath() + " full URL, from server " + this.getServer().getURL());
        }
    }

    private String getUnextendedName(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '.') {
                if (n2 == 0) {
                    return null;
                }
                return string.substring(0, n2);
            }
            ++n2;
        }
        return null;
    }

    public Reply handleRangeRequest(Request request, HttpRange httpRange) throws ProtocolException {
        int n;
        HttpEntityTag httpEntityTag = request.getIfRange();
        if (httpEntityTag != null && (httpEntityTag.isWeak() || !httpEntityTag.getTag().equals(this.etag.getTag()))) {
            return null;
        }
        int n2 = this.getContentLength();
        int n3 = httpRange.getFirstPosition();
        int n4 = httpRange.getLastPosition();
        if (n3 > n2 - 1) {
            HttpContentRange httpContentRange = HttpFactory.makeContentRange("bytes", 0, n2 - 1, n2);
            Reply reply = this.createDefaultReply(request, 416);
            reply.setContentLength(-1);
            reply.setHeaderValue(HttpEntityMessage.H_CONTENT_RANGE, (HeaderValue)httpContentRange);
            if (this.getMD5Flag()) {
                reply.setContentMD5(null);
            }
            return reply;
        }
        if (n3 < 0 && n4 >= 0) {
            if (n4 >= n2) {
                n4 = n2;
            }
            n = n4;
            n3 = n2 - n4;
            n4 = n2 - 1;
        } else if (n4 < 0) {
            n4 = n2 - 1;
            n = n4 - n3 + 1;
        } else {
            if (n4 >= n2) {
                n4 = n2 - 1;
            }
            n = n4 - n3 + 1;
        }
        if (n3 < 0 || n4 < 0 || n3 <= n4) {
            HttpContentRange httpContentRange = null;
            n3 = n3 < 0 ? 0 : n3;
            n4 = n4 > n2 || n4 < 0 ? n2 : n4;
            httpContentRange = HttpFactory.makeContentRange("bytes", n3, n4, n2);
            Reply reply = this.createDefaultReply(request, 206);
            try {
                if (this.getMD5Flag()) {
                    String string = null;
                    try {
                        ByteRangeOutputStream byteRangeOutputStream = new ByteRangeOutputStream(this.fresource.getFile(), n3, n4 + 1);
                        Md5 md5 = new Md5(byteRangeOutputStream);
                        byte[] byArray = md5.getDigest();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        Base64Encoder base64Encoder = new Base64Encoder(new ByteArrayInputStream(byArray), byteArrayOutputStream);
                        base64Encoder.process();
                        string = byteArrayOutputStream.toString();
                    }
                    catch (Exception exception) {}
                    if (string == null) {
                        reply.setContentMD5(null);
                    } else {
                        reply.setContentMD5(string);
                    }
                }
                reply.setContentLength(n);
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_RANGE, (HeaderValue)httpContentRange);
                reply.setStream(new ByteRangeOutputStream(this.fresource.getFile(), n3, n4 + 1));
                return reply;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public Reply head(Request request) throws ProtocolException, ResourceException {
        if (this.dresource != null) {
            return this.headDirectoryResource(request);
        }
        if (this.fresource != null) {
            return this.headFileResource(request);
        }
        return this.headOtherResource(request);
    }

    protected Reply headDirectoryResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = null;
        reply = this.getDirectoryResource(request);
        reply.setStream((InputStream)null);
        return reply;
    }

    protected Reply headFileResource(Request request) throws ProtocolException, ResourceException {
        if (this.fresource == null) {
            throw new ResourceException("this frame is not attached to a FileResource. (" + this.resource.getIdentifier() + ")");
        }
        Reply reply = null;
        this.fresource.checkContent();
        this.updateCachedHeaders();
        if (this.checkIfMatch(request) == 1) {
            Reply reply2 = request.makeReply(412);
            reply2.setContent("Pre-conditions failed.");
            return reply2;
        }
        if (this.checkIfNoneMatch(request) == 1) {
            return this.createDefaultReply(request, 304);
        }
        if (this.checkIfModifiedSince(request) == 1) {
            return this.createDefaultReply(request, 304);
        }
        if (this.checkIfUnmodifiedSince(request) == 1) {
            Reply reply3 = request.makeReply(412);
            reply3.setContent("Pre-conditions failed.");
            return reply3;
        }
        if (!this.fresource.getFile().exists()) {
            return this.deleteMe(request);
        }
        reply = this.createDefaultReply(request, 200);
        if (request.hasState(STATE_CONTENT_LOCATION)) {
            reply.setContentLocation(this.getURL(request).toExternalForm());
        }
        return reply;
    }

    protected Reply headOtherResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = null;
        reply = this.getOtherResource(request);
        reply.setStream((InputStream)null);
        return reply;
    }

    public Reply link(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method LINK not implemented.");
        throw new HTTPException(reply);
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        RequestInterface requestInterface = lookupState.getRequest();
        if (!this.checkRequest(requestInterface)) {
            return false;
        }
        if (this.lookupFilters(lookupState, lookupResult)) {
            return true;
        }
        return this.lookupResource(lookupState, lookupResult);
    }

    protected boolean lookupDirectory(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Object object;
        Object object2;
        Request request;
        if (lookupState.hasMoreComponents() && this.getPutableFlag() && ((request = (Request)lookupState.getRequest()) == null || request.getMethod().equals("PUT"))) {
            object2 = lookupState.peekNextComponent();
            object = this.dresource.lookup((String)object2);
            if (object == null && this.dresource.getExtensibleFlag()) {
                object = lookupState.countRemainingComponents() == 1 ? this.dresource.createResource((String)object2, request) : this.dresource.createDirectoryResource((String)object2);
                if (object == null) {
                    Reply reply = request.makeReply(415);
                    reply.setContent("Failed to create resource " + (String)object2 + " : " + "Unable to create the appropriate file:" + request.getURLPath() + " this media type is not supported");
                    throw new HTTPException(reply);
                }
            } else if (object == null) {
                Reply reply = request.makeReply(403);
                reply.setContent("You are not allowed to create resource " + (String)object2 + " : " + this.dresource.getIdentifier() + " is not extensible.");
                throw new HTTPException(reply);
            }
        }
        if (super.lookup(lookupState, lookupResult)) {
            if (!lookupState.isDirectory() && !lookupState.isInternal()) {
                request = (Request)lookupState.getRequest();
                if (request == null) {
                    lookupResult.setTarget(null);
                    return true;
                }
                object2 = null;
                try {
                    if (request != null && request.hasState("org.w3c.jigsaw.http.Request.origurl")) {
                        object = (URL)request.getState("org.w3c.jigsaw.http.Request.origurl");
                        object2 = new URL((URL)object, String.valueOf(((URL)object).getFile()) + "/");
                    } else {
                        object2 = lookupState.hasRequest() ? this.getURL(request) : new URL(this.getServer().getURL(), this.resource.getURLPath());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.getServer().errlog(this, "unable to build full URL.");
                    throw new HTTPException("Internal server error");
                }
                object = "Invalid requested URL: the directory resource  you are trying to reach is available only through  its full URL: <a href=\"" + object2 + "\">" + object2 + "</a>.";
                if (this.getRelocateFlag()) {
                    Reply reply = request.makeReply(302);
                    reply.setContent((String)object);
                    reply.setLocation((URL)object2);
                    lookupResult.setTarget(null);
                    lookupResult.setReply(reply);
                    return true;
                }
                Reply reply = request.makeReply(404);
                reply.setContent((String)object);
                lookupResult.setTarget(null);
                lookupResult.setReply(reply);
                return true;
            }
            if (!lookupState.isInternal()) {
                request = (Request)lookupState.getRequest();
                request.setState(STATE_CONTENT_LOCATION, "true");
                object2 = this.getIndexes();
                if (object2 != null) {
                    int n = 0;
                    while (n < ((String[])object2).length) {
                        DirectoryResource directoryResource;
                        ResourceReference resourceReference;
                        String string = object2[n];
                        if (string != null && string.length() > 0 && (resourceReference = (directoryResource = (DirectoryResource)this.resource).lookup(string)) != null) {
                            Object var11_14;
                            try {
                                try {
                                    FramedResource framedResource = (FramedResource)resourceReference.lock();
                                    boolean bl = framedResource.lookup(lookupState, lookupResult);
                                    var11_14 = null;
                                    resourceReference.unlock();
                                    return bl;
                                }
                                catch (InvalidResourceException invalidResourceException) {
                                    var11_14 = null;
                                    resourceReference.unlock();
                                }
                            }
                            catch (Throwable throwable) {
                                var11_14 = null;
                                resourceReference.unlock();
                                throw throwable;
                            }
                        }
                        ++n;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean lookupFile(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        return super.lookup(lookupState, lookupResult);
    }

    protected boolean lookupOther(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        return super.lookup(lookupState, lookupResult);
    }

    protected boolean lookupResource(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        if (this.fresource != null) {
            return this.lookupFile(lookupState, lookupResult);
        }
        if (this.dresource != null) {
            return this.lookupDirectory(lookupState, lookupResult);
        }
        return this.lookupOther(lookupState, lookupResult);
    }

    public Reply options(Request request) throws ProtocolException, ResourceException {
        Reply reply = this.createDefaultReply(request, 200);
        reply.setContentLength(-1);
        reply.setContentType(null);
        if (this.allowed != null) {
            reply.setHeaderValue(HttpEntityMessage.H_ALLOW, (HeaderValue)this.allowed);
        }
        return reply;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        ReplyInterface replyInterface = super.perform(requestInterface);
        if (replyInterface != null) {
            return replyInterface;
        }
        if (!this.checkRequest(requestInterface)) {
            return null;
        }
        Reply reply = null;
        Request request = (Request)requestInterface;
        String string = request.getMethod();
        reply = string.equals("GET") ? this.get(request) : (string.equals("HEAD") ? this.head(request) : (string.equals("POST") ? this.post(request) : (string.equals("PUT") ? this.put(request) : (string.equals("OPTIONS") ? this.options(request) : (string.equals("DELETE") ? this.delete(request) : (string.equals("LINK") ? this.link(request) : (string.equals("UNLINK") ? this.unlink(request) : (string.equals("TRACE") ? this.trace(request) : this.extended(request)))))))));
        return reply;
    }

    protected ReplyInterface performFrames(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        return super.performFrames(requestInterface);
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(405);
        if (this.allowed != null) {
            reply.setHeaderValue(HttpEntityMessage.H_ALLOW, (HeaderValue)this.allowed);
        }
        reply.setContent("Method POST not allowed on this resource.");
        throw new HTTPException(reply);
    }

    public Reply put(Request request) throws ProtocolException, ResourceException {
        if (this.fresource != null) {
            return this.putFileResource(request);
        }
        return this.putOtherResource(request);
    }

    protected Reply putFileResource(Request request) throws ProtocolException, ResourceException {
        Object object;
        Reply reply = null;
        int n = 200;
        this.fresource.checkContent();
        this.updateCachedHeaders();
        if (!this.getPutableFlag()) {
            Reply reply2 = request.makeReply(405);
            reply2.setContent("Method PUT not allowed.");
            throw new HTTPException(reply2);
        }
        if (this.checkIfMatch(request) == 1 || this.checkIfNoneMatch(request) == 1 || this.checkIfModifiedSince(request) == 1 || this.checkIfUnmodifiedSince(request) == 1) {
            Reply reply3 = request.makeReply(412);
            reply3.setContent("Pre-condition failed.");
            return reply3;
        }
        InputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            if (inputStream == null) {
                Reply reply4 = request.makeReply(400);
                reply4.setContent("<p>Request doesn't have a valid content.");
                throw new HTTPException(reply4);
            }
        }
        catch (IOException iOException) {
            throw new ClientException(request.getClient(), iOException);
        }
        if (request.hasContentRange()) {
            Reply reply5 = request.makeReply(400);
            reply5.setContent("partial PUT not supported.");
            throw new HTTPException(reply5);
        }
        if (request.hasContentType()) {
            object = request.getContentType();
            MimeType mimeType = this.getContentType();
            if (mimeType == null) {
                this.setValue(ATTR_CONTENT_TYPE, object);
            } else if (((MimeType)object).match(mimeType) < 0) {
                System.out.println("No match between: [" + ((MimeType)object).toString() + "] and [" + mimeType.toString() + "]");
                Reply reply6 = request.makeReply(415);
                reply6.setContent("<p>Invalid content type: " + mimeType.toString());
                throw new HTTPException(reply6);
            }
        }
        try {
            object = request.getClient();
            if (object != null && request.getExpect() != null) {
                ((Client)object).sendContinue();
            }
            n = this.fresource.newContent(request.getInputStream()) ? 201 : 204;
        }
        catch (IOException iOException) {
            throw new ClientException(request.getClient(), iOException);
        }
        if (n == 201) {
            reply = request.makeReply(n);
            reply.setContent("<P>Resource succesfully created");
            if (request.hasState(STATE_CONTENT_LOCATION)) {
                reply.setContentLocation(this.getURL(request).toExternalForm());
            }
            if (this.fresource != null && this.etag == null) {
                reply.setETag(this.getETag());
            }
            reply.setLocation(this.getURL(request));
            reply.setContent("<p>Entity body saved succesfully !");
        } else {
            reply = this.createDefaultReply(request, n);
        }
        return reply;
    }

    protected Reply putOtherResource(Request request) throws ProtocolException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method PUT not implemented.");
        throw new HTTPException(reply);
    }

    public void registerOtherResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        this.dresource = null;
        this.fresource = null;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        if (framedResource instanceof FileResource) {
            this.fresource = (FileResource)framedResource;
        } else if (framedResource instanceof DirectoryResource) {
            this.dresource = (DirectoryResource)framedResource;
        }
    }

    public synchronized void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_CONTENT_TYPE) {
            this.contenttype = null;
        }
        if (n == ATTR_CHARSET) {
            this.contenttype = null;
        }
        if (n == ATTR_CONTENT_LENGTH) {
            this.contentlength = null;
        }
        if (n == ATTR_CONTENT_ENCODING) {
            this.contentencoding = null;
        }
        if (n == ATTR_CONTENT_LANGUAGE) {
            this.contentlanguage = null;
        }
        if (n == ATTR_PUTABLE && this.fresource != null) {
            this.allowed = object == Boolean.TRUE ? _put_allowed : _allowed;
        }
        if (n == ATTR_MD5) {
            this.md5Digest = null;
        }
        this.lastmodified = null;
    }

    public Reply trace(Request request) throws HTTPException, ClientException {
        Reply reply = this.createDefaultReply(request, 200);
        reply.setNoCache();
        reply.setMaxAge(-1);
        reply.setContentMD5(null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            reply.setContentType(new MimeType("message/http"));
            request.dump(byteArrayOutputStream);
            reply.setContentLength(byteArrayOutputStream.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        reply.setStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return reply;
    }

    public Reply unlink(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method UNLINK not implemented.");
        throw new HTTPException(reply);
    }

    protected void updateCachedHeaders() {
        long l;
        if (this.contenttype == null) {
            String string = this.getCharset();
            if (string == null) {
                this.contenttype = HttpFactory.makeMimeType(this.getContentType());
            } else {
                MimeType mimeType = this.getContentType().getClone();
                mimeType.addParameter("charset", string);
                this.contenttype = HttpFactory.makeMimeType(mimeType);
            }
        }
        if (this.contentlength == null) {
            int n = -1;
            if (this.fresource != null) {
                n = this.fresource.getFileLength();
            }
            if (n >= 0) {
                this.setValue(ATTR_CONTENT_LENGTH, (Object)new Integer(n));
                this.contentlength = HttpFactory.makeInteger(n);
            }
        }
        if (this.lastmodified == null && (l = this.getLastModified()) > 0L) {
            this.lastmodified = HttpFactory.makeDate(this.getLastModified());
        }
        if (this.definesAttribute(ATTR_CONTENT_ENCODING) && this.contentencoding == null) {
            this.contentencoding = HttpFactory.makeStringList(this.getContentEncoding());
        }
        if (this.definesAttribute(ATTR_CONTENT_LANGUAGE) && this.contentlanguage == null) {
            this.contentlanguage = HttpFactory.makeStringList(this.getContentLanguage());
        }
        if (this.fresource != null) {
            if (this.etag == null) {
                this.getETag();
            }
            if (this.getMD5Flag() && this.md5Digest == null) {
                this.getMd5Digest();
            }
        }
    }
}

