/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.auth;

import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;

public class AuthFilter
extends ResourceFilter {
    public static final String STATE_AUTHUSER = "org.w3c.jigsaw.auth.AuthFilter.user";
    public static final String STATE_AUTHTYPE = "org.w3c.jigsaw.auth.AuthFilter.type";
    public static final String STATE_AUTHCONTEXT = "org.w3c.jigsaw.auth.AuthFilter.context";
    protected static int ATTR_METHODS = -1;
    protected static int ATTR_REALM = -1;
    protected static int ATTR_SHARED_CACHABILITY = -1;
    protected static int ATTR_PRIVATE_CACHABILITY = -1;
    protected static int ATTR_PUBLIC_CACHABILITY = -1;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.auth.AuthFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringArrayAttribute("methods", null, 2);
        ATTR_METHODS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("realm", null, 6);
        ATTR_REALM = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("shared-cachability", Boolean.FALSE, 2);
        ATTR_SHARED_CACHABILITY = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("private-cachability", Boolean.FALSE, 2);
        ATTR_PRIVATE_CACHABILITY = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("public-cachability", Boolean.FALSE, 2);
        ATTR_PUBLIC_CACHABILITY = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public void authenticate(Request request) throws ProtocolException {
        Reply reply = request.makeReply(401);
        reply.setContent("<p>Invalid server configuration</p><p>The server defines an authentication filter  with no <strong>authenticate</strong> method.");
        throw new HTTPException(reply);
    }

    public String[] getMethods() {
        return (String[])this.getValue(ATTR_METHODS, null);
    }

    public boolean getPrivateCachability() {
        return this.getBoolean(ATTR_PRIVATE_CACHABILITY, false);
    }

    public boolean getPublicCachability() {
        return this.getBoolean(ATTR_PUBLIC_CACHABILITY, false);
    }

    public String getRealm() {
        return (String)this.getValue(ATTR_REALM, null);
    }

    public boolean getSharedCachability() {
        return this.getBoolean(ATTR_SHARED_CACHABILITY, false);
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Request request = (Request)(lookupState.hasRequest() ? lookupState.getRequest() : null);
        if (request == null || lookupState.isInternal()) {
            return false;
        }
        String string = request.getMethod();
        String[] stringArray = this.getMethods();
        if (stringArray == null) {
            this.authenticate(request);
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                this.authenticate(request);
                return false;
            }
            ++n;
        }
        return false;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) {
        Reply reply = (Reply)replyInterface;
        if (this.getPrivateCachability()) {
            reply.setMustRevalidate(true);
        } else if (this.getSharedCachability()) {
            reply.setProxyRevalidate(true);
        } else if (this.getPublicCachability()) {
            reply.setPublic(true);
        }
        return null;
    }
}

