/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.jigsaw.acl.AuthUserPrincipal;
import org.w3c.jigsaw.acl.JAcl;
import org.w3c.jigsaw.auth.AuthRealm;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.IPMatcher;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;

public class AclRealm
extends JAcl {
    protected static int ATTR_REALM = -1;
    protected static int ATTR_ALLOWED_USERS = -1;
    protected static int ATTR_METHODS = -1;
    protected IPMatcher ipmatcher = null;
    protected RealmsCatalog catalog = null;
    protected ResourceReference rr_realm = null;
    protected String loaded_realm = null;
    protected Vector entries = null;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.acl.AclRealm");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringAttribute("realm", null, 6);
        ATTR_REALM = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("users", null, 2);
        ATTR_ALLOWED_USERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("methods", null, 2);
        ATTR_METHODS = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    protected synchronized void acquireRealm() {
        Object object;
        this.entries = new Vector(10);
        if (this.catalog == null) {
            object = (httpd)((FramedResource)this.getTargetResource()).getServer();
            this.catalog = ((httpd)object).getRealmsCatalog();
        }
        if ((object = this.getRealm()) == null) {
            return;
        }
        if (this.rr_realm != null && ((String)object).equals(this.loaded_realm)) {
            return;
        }
        this.rr_realm = this.catalog.loadRealm((String)object);
        if (this.rr_realm != null) {
            try {
                try {
                    AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
                    Enumeration enumeration = authRealm.enumerateUserNames();
                    while (enumeration.hasMoreElements()) {
                        Object var9_6;
                        String string = (String)enumeration.nextElement();
                        ResourceReference resourceReference = authRealm.loadUser(string);
                        try {
                            try {
                                AuthUser authUser = (AuthUser)resourceReference.lock();
                                this.createEntry(authUser);
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                System.out.println("Invalid user reference : " + string);
                            }
                            var9_6 = null;
                            resourceReference.unlock();
                        }
                        catch (Throwable throwable) {
                            var9_6 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var3_9 = null;
                this.rr_realm.unlock();
            }
            catch (Throwable throwable) {
                Object var3_10 = null;
                this.rr_realm.unlock();
                throw throwable;
            }
        }
    }

    public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public boolean addOwner(Principal principal, Principal principal2) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        this.acquireRealm();
        String[] stringArray = this.getMethods();
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (permission.equals((Object)stringArray[n])) {
                    bl = true;
                }
                ++n;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return true;
        }
        return this.hasPrincipal(principal);
    }

    protected boolean checkUser(AuthUser authUser) {
        String[] stringArray = this.getAllowedUsers();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(authUser.getName())) {
                    return true;
                }
                ++n;
            }
        } else {
            return true;
        }
        return false;
    }

    protected void createEntry(AuthUser authUser) {
        if (this.checkUser(authUser)) {
            this.entries.addElement(new AuthUserPrincipal(authUser, this.getName()));
        }
    }

    public boolean deleteOwner(Principal principal, Principal principal2) throws NotOwnerException, LastOwnerException {
        throw new NotOwnerException();
    }

    public Enumeration entries() {
        return null;
    }

    public String[] getAllowedUsers() {
        return (String[])this.getValue(ATTR_ALLOWED_USERS, null);
    }

    public String[] getMethods() {
        return (String[])this.getValue(ATTR_METHODS, null);
    }

    public String getName() {
        return this.getRealm();
    }

    public Enumeration getPermissions(Principal principal) {
        return null;
    }

    public String getRealm() {
        return (String)this.getValue(ATTR_REALM, null);
    }

    protected boolean hasPrincipal(Principal principal) {
        int n = this.entries.indexOf(principal);
        return n != -1;
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
    }

    public boolean isOwner(Principal principal) {
        return false;
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public String toString() {
        return this.getName();
    }
}

