// DateAttribute.java
// $Id: DateAttribute.java,v 1.2 1999/09/07 13:28:53 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.resources ;

import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class DateAttribute extends LongAttribute {

    SimpleDateFormat formatter = null;

    public DateAttribute(String name, Object def, int flags) {
	super(name, (Long) def, flags) ;
	this.type = "java.util.Date";
	this.formatter = getDateFormatter();
    }

    public DateAttribute() {
	super();
	this.formatter = getDateFormatter();
    }

    /**
     * Get a DateFormat compliant with RFC 822 updated by RFC 1123.
     * @return a SimpleDateFormat instance.
     */
    private SimpleDateFormat getDateFormatter() {
	SimpleDateFormat formatter = 
	    new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
	formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
	return formatter;
    }


    /**
     * Pickle an integer to the given output stream.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public String pickle(Object obj) {
	return formatter.format(new Date(((Long)obj).longValue()));
    }

    /**
     * Unpickle an integer from the given input stream.
     * @param value the string representation of this integer
     * @return An instance of Integer.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (String value) {
	try {
	    return new Long((formatter.parse(value)).getTime());
	} catch (ParseException ex) {
	    return new Long(-1);
	}
    }


}
