/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.proxy;

import org.w3c.tools.codec.Base64Encoder;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.proxy.Rule;
import org.w3c.www.protocol.http.proxy.RuleParserException;

class AuthorizationRule
extends Rule {
    HttpCredential credential = null;
    String user = null;
    String password = null;

    public AuthorizationRule() {
        this.name = "authorization";
    }

    public Reply apply(Request request) {
        if (!request.hasHeader(HttpRequestMessage.H_AUTHORIZATION)) {
            request.setHeaderValue(HttpRequestMessage.H_AUTHORIZATION, (HeaderValue)this.credential);
        }
        return null;
    }

    public void initialize(String[] stringArray, int n, int n2) throws RuleParserException {
        if (n + 2 != n2) {
            throw new RuleParserException("Invalid authorization rule:  should be authorization  <user> <password>.");
        }
        this.credential = HttpFactory.makeCredential("Basic");
        this.user = stringArray[n];
        this.password = stringArray[n + 1];
        this.args = String.valueOf(this.user) + " " + this.password;
        Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(this.user) + ":" + this.password);
        this.credential.setAuthParameter("cookie", base64Encoder.processString());
        this.host = stringArray[0];
    }

    public String toString() {
        return String.valueOf(this.host) + " " + this.name + " " + this.user + " " + this.password;
    }
}

