/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.File;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.LRUAble;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.TeeMonitor;

public abstract class CachedResource
extends AttributeHolder
implements TeeMonitor,
LRUAble {
    public static final int COND_FAILED = 1;
    public static final int COND_OK = 2;
    public static final int STATE_NOT_LOADED = 0;
    public static final int STATE_LOAD_COMPLETE = 1;
    public static final int STATE_LOAD_PARTIAL = 2;
    public static final int STATE_LOAD_UNKNOWN = 3;
    public static final int STATE_LOAD_ERROR = 4;
    protected static int ATTR_IDENTIFIER = -1;
    protected static int ATTR_CONTENT_LENGTH = -1;
    protected static int ATTR_CURRENT_LENGTH = -1;
    protected static int ATTR_FILE = -1;
    protected static final String NAME_CONTENT_LENGTH = "content-length";
    protected static final String NAME_CURRENT_LENGTH = "current-length";
    protected static final String NAME_IDENTIFIER = "id";
    protected static final String NAME_FILE = "file";
    protected static int ATTR_LOAD_STATE = -1;
    protected static int ATTR_ETAG = -1;
    protected static int ATTR_STATUS = -1;
    protected static int ATTR_REPLY_LAST_MODIFIED = -1;
    protected static int ATTR_DATE = -1;
    protected static int ATTR_CONTENT_MD5 = -1;
    protected static int ATTR_CONTENT_ENCODING = -1;
    protected static int ATTR_CONTENT_LANGUAGE = -1;
    protected static int ATTR_EXTRA_HEADERS = -1;
    protected static String[] ATTR_DESCR;
    protected boolean invalidated = false;
    protected CacheGeneration generation = null;
    HttpEntityTag[] etags = null;
    protected ArrayDictionary a = null;
    protected CacheFilter filter;
    protected LRUAble prev = null;
    protected LRUAble next = null;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.www.protocol.http.cache.CachedResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringAttribute(NAME_IDENTIFIER, null, 1);
        ATTR_IDENTIFIER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute(NAME_CONTENT_LENGTH, null, 1);
        ATTR_CONTENT_LENGTH = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute(NAME_CURRENT_LENGTH, null, 1);
        ATTR_CURRENT_LENGTH = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new FileAttribute(NAME_FILE, null, 1);
        ATTR_FILE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("load-state", null, 1);
        ATTR_LOAD_STATE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("etag", null, 1);
        ATTR_ETAG = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("status", null, 1);
        ATTR_STATUS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new DateAttribute("reply-last-modified", (Object)null, 3);
        ATTR_REPLY_LAST_MODIFIED = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new DateAttribute("reply-date", (Object)null, 3);
        ATTR_DATE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("content-md5", null, 1);
        ATTR_CONTENT_MD5 = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("content-encoding", null, 1);
        ATTR_CONTENT_ENCODING = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("content-language", null, 1);
        ATTR_CONTENT_LANGUAGE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("headers", null, 1);
        ATTR_EXTRA_HEADERS = AttributeRegistry.registerAttribute(clazz, attribute);
        ATTR_DESCR = new String[]{NAME_IDENTIFIER, NAME_CURRENT_LENGTH, NAME_FILE};
    }

    public long delete() {
        File file = this.getFile();
        if (file != null) {
            file.delete();
        }
        return this.getCurrentLength();
    }

    public String[] getContentEncoding() {
        return (String[])this.getValue(ATTR_CONTENT_ENCODING, null);
    }

    public String[] getContentLanguage() {
        return (String[])this.getValue(ATTR_CONTENT_LANGUAGE, null);
    }

    public int getContentLength() {
        return this.getInt(ATTR_CONTENT_LENGTH, -1);
    }

    public String getContentMD5() {
        return this.getString(ATTR_CONTENT_MD5, null);
    }

    public abstract MimeType getContentType();

    public abstract int getCurrentAge();

    public int getCurrentLength() {
        return this.getInt(ATTR_CURRENT_LENGTH, -1);
    }

    public long getDate() {
        return this.getLong(ATTR_DATE, -1L);
    }

    public String getETag() {
        return this.getString(ATTR_ETAG, null);
    }

    public ArrayDictionary getExtraHeaders() {
        return (ArrayDictionary)this.getValue(ATTR_EXTRA_HEADERS, null);
    }

    public File getFile() {
        return (File)this.getValue(ATTR_FILE, null);
    }

    public abstract int getFreshnessLifetime();

    public String getIdentifier() {
        return (String)this.getValue(ATTR_IDENTIFIER, null);
    }

    public long getLastModified() {
        return this.getLong(ATTR_REPLY_LAST_MODIFIED, -1L);
    }

    public int getLoadState() {
        return this.getInt(ATTR_LOAD_STATE, 0);
    }

    public LRUAble getNext() {
        return this.next;
    }

    public LRUAble getPrev() {
        return this.prev;
    }

    public int getStatus() {
        return this.getInt(ATTR_STATUS, -1);
    }

    public boolean getWillRevalidate() {
        return this.invalidated;
    }

    public CachedResource lookupResource(Request request) {
        return this;
    }

    public void notifyTeeFailure(int n) {
    }

    public void notifyTeeSuccess(int n) {
    }

    public abstract Reply perform(Request var1) throws HttpException;

    public void setContentEncoding(String[] stringArray) {
        this.setValue(ATTR_CONTENT_ENCODING, (Object)stringArray);
    }

    public void setContentLanguage(String[] stringArray) {
        this.setValue(ATTR_CONTENT_LANGUAGE, (Object)stringArray);
    }

    public void setContentLength(int n) {
        this.setInt(ATTR_CONTENT_LENGTH, n);
    }

    public void setContentMD5(String string) {
        this.setValue(ATTR_CONTENT_MD5, (Object)string);
    }

    public abstract void setContentType(MimeType var1);

    public void setCurrentLength(int n) {
        this.setInt(ATTR_CURRENT_LENGTH, n);
    }

    public void setDate(long l) {
        this.setLong(ATTR_DATE, l);
    }

    public void setETag(String string) {
        this.setValue(ATTR_ETAG, (Object)string);
    }

    public void setExtraHeaders(ArrayDictionary arrayDictionary) {
        this.setValue(ATTR_EXTRA_HEADERS, (Object)arrayDictionary);
    }

    public void setFile(File file) {
        this.setValue(ATTR_FILE, (Object)file);
    }

    public void setLastModified(long l) {
        this.setLong(ATTR_REPLY_LAST_MODIFIED, l);
    }

    public void setLoadState(int n) {
        this.setInt(ATTR_LOAD_STATE, n);
    }

    public synchronized void setNext(LRUAble lRUAble) {
        this.next = lRUAble;
    }

    public synchronized void setPrev(LRUAble lRUAble) {
        this.prev = lRUAble;
    }

    public abstract Request setRequestRevalidation(Request var1);

    public void setStatus(int n) {
        this.setInt(ATTR_STATUS, n);
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_ETAG) {
            this.etags = null;
        }
    }

    public void setWillRevalidate(boolean bl) {
        this.invalidated = bl;
    }
}

