/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.auth;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.auth.CachedRealm;
import org.w3c.www.protocol.http.auth.LocalAuthFilter;
import org.w3c.www.protocol.http.auth.PasswordPrompter;

public class AuthFilter
implements PropRequestFilter {
    protected static Hashtable realms = new Hashtable(13);
    protected HttpManager manager = null;

    public boolean exceptionFilter(Request request, HttpException httpException) {
        return false;
    }

    public Reply ingoingFilter(Request request) {
        return null;
    }

    public void initialize(HttpManager httpManager) {
        this.manager = httpManager;
        httpManager.setFilter(this);
        httpManager.setAllowUserInteraction(true);
    }

    protected static HttpCredential lookupRealm(Request request, Reply reply) {
        String string = request.getManager().getServerKey(request);
        CachedRealm[] cachedRealmArray = (CachedRealm[])realms.get(string);
        if (cachedRealmArray == null) {
            return null;
        }
        HttpChallenge httpChallenge = request.hasProxy() ? reply.getProxyAuthenticate() : reply.getWWWAuthenticate();
        String string2 = httpChallenge.getAuthParameter("realm");
        int n = 0;
        while (n < cachedRealmArray.length) {
            if (cachedRealmArray[n].realm.equalsIgnoreCase(string2)) {
                return cachedRealmArray[n].credentials;
            }
            ++n;
        }
        return null;
    }

    public Reply outgoingFilter(Request request, Reply reply) throws HttpException {
        Object object;
        Object object2;
        if (reply.getStatus() != 401 && reply.getStatus() != 407) {
            return null;
        }
        HttpCredential httpCredential = null;
        httpCredential = AuthFilter.lookupRealm(request, reply);
        if (httpCredential == null) {
            if (!request.getAllowUserInteraction()) {
                return null;
            }
            object2 = new PasswordPrompter(request, reply);
            if (!((PasswordPrompter)object2).prompt()) {
                return null;
            }
            object = ((PasswordPrompter)object2).getUser();
            String string = ((PasswordPrompter)object2).getPassword();
            httpCredential = HttpFactory.makeCredential("Basic");
            Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(object) + ":" + string);
            httpCredential.setAuthParameter("cookie", base64Encoder.processString());
        }
        if (request.hasProxy()) {
            request.setProxyAuthorization(httpCredential);
        } else {
            request.setAuthorization(httpCredential);
        }
        object2 = request.getManager().runRequest(request);
        if (((HttpReplyMessage)object2).getStatus() / 100 != 4) {
            AuthFilter.registerRealm(request, reply, httpCredential);
            if (request.hasProxy()) {
                LocalAuthFilter.installProxyAuth(this.manager, httpCredential);
            } else {
                LocalAuthFilter.installLocalAuth(this.manager, request.getURL(), httpCredential);
            }
            try {
                object = reply.getInputStream();
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {}
            return object2;
        }
        return null;
    }

    protected static void registerRealm(Request request, Reply reply, HttpCredential httpCredential) {
        if (AuthFilter.lookupRealm(request, reply) != null) {
            return;
        }
        String string = request.getManager().getServerKey(request);
        String string2 = (request.hasProxy() ? reply.getProxyAuthenticate() : reply.getWWWAuthenticate()).getAuthParameter("realm");
        CachedRealm[] cachedRealmArray = (CachedRealm[])realms.get(string);
        if (cachedRealmArray == null) {
            cachedRealmArray = new CachedRealm[]{new CachedRealm(string2, httpCredential)};
        } else {
            CachedRealm[] cachedRealmArray2 = new CachedRealm[cachedRealmArray.length + 1];
            System.arraycopy(cachedRealmArray, 0, cachedRealmArray2, 0, cachedRealmArray.length);
            cachedRealmArray2[cachedRealmArray.length] = new CachedRealm(string2, httpCredential);
            cachedRealmArray = cachedRealmArray2;
        }
        realms.put(string, cachedRealmArray);
    }

    public void sync() {
    }
}

