/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.ParseState;

public class HttpTokenList
extends BasicValue {
    protected static final int CASE_LOWER = 0;
    protected static final int CASE_ASIS = 1;
    protected static final int CASE_UPPER = 2;
    protected String[] tokens = null;
    protected int casemode = 0;

    protected HttpTokenList() {
        this.isValid = false;
    }

    protected HttpTokenList(String string) {
        this.isValid = false;
        this.raw = new byte[string.length()];
        string.getBytes(0, this.raw.length, this.raw, 0);
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    protected HttpTokenList(String[] stringArray) {
        this.isValid = true;
        this.tokens = stringArray;
    }

    public void addToken(String string, boolean bl) {
        this.validate();
        if (!bl && this.tokens != null) {
            int n = 0;
            while (n < this.tokens.length) {
                if (this.tokens[n].equals(string)) {
                    return;
                }
                ++n;
            }
        }
        this.invalidateByteValue();
        if (this.tokens == null) {
            this.tokens = new String[1];
            this.tokens[0] = string;
        } else {
            String[] stringArray = new String[this.tokens.length + 1];
            System.arraycopy(this.tokens, 0, stringArray, 0, this.tokens.length);
            stringArray[this.tokens.length] = string;
            this.tokens = stringArray;
        }
    }

    public Object getValue() {
        this.validate();
        return this.tokens;
    }

    public boolean hasToken(String string, boolean bl) {
        this.validate();
        if (this.tokens == null) {
            return false;
        }
        if (bl) {
            int n = 0;
            while (n < this.tokens.length) {
                if (this.tokens[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.tokens.length) {
                if (this.tokens[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void parse() {
        Vector<String> vector = new Vector<String>(8);
        ParseState parseState = new ParseState();
        ParseState parseState2 = new ParseState();
        parseState.ioff = this.roff;
        parseState.bufend = this.rlen;
        parseState.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.ioff = parseState.start;
            parseState2.bufend = parseState.end;
            HttpParser.unquote(this.raw, parseState2);
            switch (this.casemode) {
                case 0: {
                    vector.addElement(parseState2.toString(this.raw, true));
                    break;
                }
                case 1: {
                    vector.addElement(parseState2.toString(this.raw));
                    break;
                }
                case 2: {
                    vector.addElement(parseState2.toString(this.raw, false));
                    break;
                }
            }
            parseState.prepare();
        }
        this.tokens = new String[vector.size()];
        vector.copyInto(this.tokens);
    }

    public void setValue(String[] stringArray) {
        this.invalidateByteValue();
        this.tokens = stringArray;
        this.isValid = true;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        if (this.tokens != null) {
            int n = 0;
            while (n < this.tokens.length) {
                if (n > 0) {
                    httpBuffer.append(',');
                }
                httpBuffer.append(this.tokens[n]);
                ++n;
            }
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

