/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.CookieDate;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.ParseState;

public class HttpSetCookieList
extends BasicValue {
    Vector setcookies = null;
    Vector raws = null;

    HttpSetCookieList() {
        this.isValid = false;
        this.setcookies = new Vector(2);
    }

    public HttpSetCookieList(HttpSetCookie[] httpSetCookieArray) {
        this.isValid = true;
        this.setcookies = new Vector(2);
        if (httpSetCookieArray != null) {
            int n = 0;
            while (n < httpSetCookieArray.length) {
                this.setcookies.addElement(httpSetCookieArray[n]);
                ++n;
            }
        }
    }

    public HttpSetCookie addSetCookie(String string, String string2) {
        this.validate();
        HttpSetCookie httpSetCookie = new HttpSetCookie(true, string, string2);
        this.setcookies.addElement(httpSetCookie);
        return httpSetCookie;
    }

    public void addSetCookie(HttpSetCookie httpSetCookie) {
        this.validate();
        this.setcookies.addElement(httpSetCookie);
    }

    protected final void checkByteValues() {
        if (this.raws == null) {
            this.updateByteValue();
        }
    }

    protected void emitCookie(OutputStream outputStream, int n) throws IOException {
        this.checkByteValues();
        outputStream.write(((HttpBuffer)this.raws.elementAt(n)).getByteCopy());
    }

    public HttpSetCookie getSetCookie(String string) {
        this.validate();
        int n = 0;
        while (n < this.setcookies.size()) {
            HttpSetCookie httpSetCookie = (HttpSetCookie)this.setcookies.elementAt(n);
            if (httpSetCookie.getName().equals(string)) {
                return httpSetCookie;
            }
            ++n;
        }
        return null;
    }

    public HttpSetCookie[] getSetCookies() {
        this.validate();
        Object[] objectArray = new HttpSetCookie[this.setcookies.size()];
        this.setcookies.copyInto(objectArray);
        return objectArray;
    }

    public Object getValue() {
        return this;
    }

    protected int length() {
        if (this.setcookies == null) {
            return 0;
        }
        return this.setcookies.size();
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        ParseState parseState2 = new ParseState(0, 0);
        ParseState parseState3 = new ParseState(0, 0);
        ParseState parseState4 = new ParseState(0, 0);
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        parseState2.separator = (byte)59;
        parseState2.spaceIsSep = false;
        parseState3.separator = (byte)61;
        parseState3.spaceIsSep = false;
        parseState4.separator = (byte)59;
        parseState4.spaceIsSep = false;
        boolean bl = false;
        String string = null;
        HttpSetCookie httpSetCookie = null;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.ioff = parseState.start;
            parseState2.bufend = parseState.end;
            if (!bl) {
                httpSetCookie = new HttpSetCookie();
            }
            while (HttpParser.nextItem(this.raw, parseState2) >= 0) {
                Object object;
                String string2;
                if (bl) {
                    try {
                        string2 = String.valueOf(string) + ", " + parseState2.toString(this.raw);
                        object = new Date(string2);
                        httpSetCookie.setMaxAge((int)((Date)object).getTime() / 1000);
                    }
                    catch (Exception exception) {}
                    bl = false;
                } else {
                    parseState3.ioff = parseState2.start;
                    parseState3.bufend = parseState2.end;
                    if (HttpParser.nextItem(this.raw, parseState3) < 0) {
                        this.error("Invalid cookie item [" + parseState2.toString(this.raw) + "]");
                    }
                    string2 = parseState3.toString(this.raw);
                    object = parseState3.toString(this.raw, true);
                    if (((String)object).equals("secure")) {
                        httpSetCookie.setSecurity(true);
                    } else {
                        parseState3.prepare();
                        if (HttpParser.nextItem(this.raw, parseState3) < 0) {
                            this.error("No value for attribute [" + (String)object + "]");
                        }
                        if (((String)object).equals("comment")) {
                            httpSetCookie.setComment(parseState3.toString(this.raw));
                        } else if (((String)object).equals("domain")) {
                            httpSetCookie.setDomain(parseState3.toString(this.raw));
                        } else if (((String)object).equals("expires")) {
                            string = parseState3.toString(this.raw);
                            bl = true;
                        } else if (((String)object).equals("max-age")) {
                            httpSetCookie.setMaxAge(Integer.parseInt(parseState3.toString(this.raw)));
                        } else if (((String)object).equals("path")) {
                            httpSetCookie.setPath(parseState3.toString(this.raw));
                        } else if (((String)object).equals("version")) {
                            httpSetCookie.setVersion(Integer.parseInt(parseState3.toString(this.raw)));
                        } else {
                            if (httpSetCookie.getName() != null) {
                                this.error("Invalid cookie item [" + (String)object + "]");
                            }
                            httpSetCookie.setName(string2);
                            parseState4.ioff = parseState3.start;
                            parseState4.bufend = parseState2.end;
                            HttpParser.nextItem(this.raw, parseState4);
                            httpSetCookie.setValue(parseState4.toString(this.raw));
                        }
                    }
                }
                parseState2.prepare();
            }
            if (!bl) {
                this.setcookies.addElement(httpSetCookie);
            }
            parseState.prepare();
        }
    }

    public boolean removeSetCookie(String string) {
        this.validate();
        int n = 0;
        while (n < this.setcookies.size()) {
            HttpSetCookie httpSetCookie = (HttpSetCookie)this.setcookies.elementAt(n);
            if (httpSetCookie.getName().equals(string)) {
                this.setcookies.removeElementAt(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void updateByteValue() {
        int n = this.setcookies.size();
        this.raws = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            HttpBuffer httpBuffer = new HttpBuffer();
            HttpSetCookie httpSetCookie = (HttpSetCookie)this.setcookies.elementAt(n2);
            httpBuffer.append(httpSetCookie.getName(), (byte)61, httpSetCookie.getValue());
            String string = httpSetCookie.getComment();
            if (string != null) {
                httpBuffer.append((byte)59);
                httpBuffer.append(" comment", (byte)61, string);
            }
            if ((string = httpSetCookie.getDomain()) != null) {
                httpBuffer.append((byte)59);
                httpBuffer.append(" domain", (byte)61, string);
            }
            if ((n3 = httpSetCookie.getMaxAge()) >= 0) {
                float f = (float)n3 * 1000.0f;
                CookieDate cookieDate = new CookieDate(true, (long)((float)System.currentTimeMillis() + f));
                httpBuffer.append((byte)59);
                httpBuffer.append(" expires=");
                cookieDate.appendValue(httpBuffer);
            }
            if ((string = httpSetCookie.getPath()) != null) {
                httpBuffer.append((byte)59);
                httpBuffer.append(" path", (byte)61, string);
            }
            if (httpSetCookie.getSecurity()) {
                httpBuffer.append(';');
                httpBuffer.append(" secure");
            }
            this.raws.addElement(httpBuffer);
            ++n2;
        }
    }
}

