/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpAcceptEncodingList;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpAcceptEncoding
extends BasicValue {
    String encoding = null;
    double quality = 1.0;
    HttpAcceptEncodingList list = null;

    public HttpAcceptEncoding() {
        this.isValid = false;
    }

    HttpAcceptEncoding(HttpAcceptEncodingList httpAcceptEncodingList, byte[] byArray, int n, int n2) {
        this.list = httpAcceptEncodingList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    HttpAcceptEncoding(boolean bl, String string, double d) {
        this.isValid = bl;
        this.setEncoding(string);
        this.setQuality(d);
    }

    public String getEncoding() {
        this.validate();
        return this.encoding;
    }

    public double getQuality() {
        this.validate();
        return this.quality;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)59;
        parseState.spaceIsSep = false;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid Accept-Encoding: no encoding.");
        }
        this.encoding = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        parseState.prepare();
        parseState.separator = (byte)61;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.quality = 1.0;
        } else {
            parseState.prepare();
            this.quality = HttpParser.parseQuality(this.raw, parseState);
        }
    }

    public void setEncoding(String string) {
        if (this.encoding.equals(string)) {
            return;
        }
        this.invalidateByteValue();
        this.encoding = string;
    }

    public void setQuality(double d) {
        if (this.quality != d) {
            this.invalidateByteValue();
        }
        this.quality = d;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.encoding);
        httpBuffer.append(';');
        httpBuffer.append(this.quality);
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

